/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import com.helpshift.support.model.Issue;
import com.helpshift.support.res.values.HSConfig;
import com.helpshift.support.storage.FaqsDataSource;
import com.helpshift.support.storage.IssuesDataSource;
import com.helpshift.support.util.IssuesUtil;
import com.helpshift.util.HSFormat;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HSStorage {
    static final String TAG = "HelpShiftDebug";
    private static HashMap cacheIndex;
    private final String dbFile = "fullIndex.db";
    private Context context;
    private SharedPreferences storage;

    public HSStorage(Context c) {
        this.context = c;
        this.storage = c.getSharedPreferences("HSJsonData", 0);
    }

    private JSONArray concatJSONArray(JSONArray arr1, JSONArray arr2) throws JSONException {
        int i;
        JSONArray result = new JSONArray();
        for (i = 0; i < arr1.length(); ++i) {
            result.put(arr1.get(i));
        }
        for (i = 0; i < arr2.length(); ++i) {
            result.put(arr2.get(i));
        }
        return result;
    }

    private JSONObject storageGetObj(String key) throws JSONException {
        return new JSONObject(this.storage.getString(key, "{}"));
    }

    private JSONArray storageGetArr(String key) throws JSONException {
        return new JSONArray(this.storage.getString(key, "[]"));
    }

    private String storageGet(String key) {
        return this.storage.getString(key, "");
    }

    private Integer storageGetInt(String key) {
        return this.storage.getInt(key, 0);
    }

    private Float storageGetFloat(String key) {
        return Float.valueOf(this.storage.getFloat(key, 0.0f));
    }

    private Boolean storageGetBoolean(String key) {
        return this.storage.getBoolean(key, false);
    }

    private Long storageGetLong(String key) {
        return this.storage.getLong(key, 0L);
    }

    private void storageSet(String key, JSONArray data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putString(key, data.toString());
        editor.commit();
    }

    private void storageSet(String key, JSONObject data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putString(key, data.toString());
        editor.commit();
    }

    private void storageSet(String key, String data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putString(key, data);
        editor.commit();
    }

    private void storageSet(String key, Integer data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putInt(key, data.intValue());
        editor.commit();
    }

    private void storageSet(String key, Float data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putFloat(key, data.floatValue());
        editor.commit();
    }

    private void storageSet(String key, Boolean data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putBoolean(key, data.booleanValue());
        editor.commit();
    }

    private void storageSet(String key, Long data) {
        SharedPreferences.Editor editor = this.storage.edit();
        editor.putLong(key, data.longValue());
        editor.commit();
    }

    protected JSONArray mergeMessages(JSONArray messages1, JSONArray messages2) throws JSONException {
        int i;
        HashMap<String, JSONObject> messagesMap = new HashMap<String, JSONObject>();
        JSONArray messagesList = new JSONArray();
        ArrayList messagesMapList = new ArrayList();
        JSONArray messages = this.concatJSONArray(messages1, messages2);
        for (i = 0; i < messages.length(); ++i) {
            JSONObject message = messages.getJSONObject(i);
            if (messagesMap.containsKey(message.get("id"))) continue;
            messagesMap.put(message.get("id").toString(), message);
            HashMap<String, Object> messageMap = new HashMap<String, Object>();
            messageMap.put("id", message.get("id"));
            messageMap.put("created_at", message.get("created_at"));
            messagesMapList.add(messageMap);
        }
        Collections.sort(messagesMapList, new Comparator<HashMap>(){

            @Override
            public int compare(HashMap a, HashMap b) {
                try {
                    Date dateA = HSFormat.issueTsFormat.parse(a.get("created_at").toString());
                    Date dateB = HSFormat.issueTsFormat.parse(b.get("created_at").toString());
                    return dateA.compareTo(dateB);
                }
                catch (Exception e) {
                    return 0;
                }
            }
        });
        for (i = 0; i < messagesMapList.size(); ++i) {
            messagesList.put(messagesMap.get(((HashMap)messagesMapList.get(i)).get("id")));
        }
        return messagesList;
    }

    protected JSONObject addMessages(JSONObject issue, JSONArray messages) throws JSONException {
        issue.put("messages", (Object)this.mergeMessages(messages, issue.getJSONArray("messages")));
        return issue;
    }

    public void storeIssues(JSONArray issues, String profileId) {
        IssuesDataSource.storeIssues(IssuesUtil.jsonArrayToIssueList(profileId, issues));
        this.updateOpenConversations(profileId);
        this.updateActiveConversation(profileId);
    }

    private void updateOpenConversations(String profileId) {
        List<Issue> issueList = IssuesDataSource.getIssues(profileId);
        List<String> openConversations = this.getOpenConversations(profileId);
        for (Issue issue : issueList) {
            String issueId = issue.getIssueId();
            Integer status = issue.getStatus();
            if (!openConversations.contains(issueId) && (status.equals(0) || status.equals(1))) {
                openConversations.add(issueId);
            }
            this.setOpenConversations(openConversations, profileId);
        }
    }

    protected void updateActiveConversation(String profileId) {
        Boolean dia = (Boolean)HSConfig.configData.get("dia");
        this.setActiveConversation("", profileId);
        if (!dia.booleanValue()) {
            List<Issue> issueList = IssuesDataSource.getIssues(profileId);
            for (Issue issue : issueList) {
                String issueId = issue.getIssueId();
                Integer status = issue.getStatus();
                List<String> openConversations = this.getOpenConversations(profileId);
                if (status.equals(0) || status.equals(1) || status.equals(2) && openConversations.contains(issueId)) {
                    this.setActiveConversation(issueId, profileId);
                    break;
                }
                if (!status.equals(3) || !issueId.equals(this.getArchivedConversation(profileId))) continue;
                this.setArchivedConversation("", profileId);
            }
        }
    }

    protected void clearAndUpdateActiveConversation(String issueId, String profileId) {
        List<String> openConvs = this.getOpenConversations(profileId);
        if (openConvs.contains(issueId)) {
            openConvs.remove(openConvs.indexOf(issueId));
            this.setOpenConversations(openConvs, profileId);
        }
        this.setArchivedConversation(issueId, profileId);
        this.updateActiveConversation(profileId);
    }

    protected HashMap getIssuesTs(String profileId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String issuesTs = "";
        try {
            JSONObject allIssuesTs = this.storageGetObj("issuesTs");
            issuesTs = allIssuesTs.optString(profileId, "");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getIssuesTs", (Throwable)e);
        }
        if (!TextUtils.isEmpty((CharSequence)issuesTs)) {
            result.put("ts", issuesTs);
            result.put("success", true);
        }
        return result;
    }

    public void setIssuesTs(String dateStr, String profileId) {
        try {
            JSONObject allIssuesTs = this.storageGetObj("issuesTs");
            allIssuesTs.put(profileId, (Object)dateStr);
            this.storageSet("issuesTs", allIssuesTs);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"setIssuesTs", (Throwable)e);
        }
    }

    protected String getIdentity() {
        return this.storageGet("identity");
    }

    protected void setIdentity(String identity) {
        this.storageSet("identity", identity);
    }

    public Integer getActiveNotifCnt(String profileId) {
        Integer activeNotifCnt = 0;
        String issueId = this.getActiveConversation(profileId);
        if (!TextUtils.isEmpty((CharSequence)issueId)) {
            Issue issue = IssuesDataSource.getIssue(issueId);
            activeNotifCnt = issue.getNewMessagesCount();
        }
        return activeNotifCnt;
    }

    protected void resetIssueCount(String issueId) throws JSONException {
        Issue.resetIssueCount(issueId);
        JSONObject pushData = this.storageGetObj("pushData");
        pushData.put(issueId, 0);
        this.storageSet("pushData", pushData);
    }

    protected void clearDatabase() {
        IssuesDataSource.clearDB();
        FaqsDataSource faqsDataSource = new FaqsDataSource();
        faqsDataSource.clearDB();
        SharedPreferences.Editor editor = this.storage.edit();
        editor.clear();
        editor.commit();
    }

    protected String getApiKey() {
        return this.storageGet("apiKey");
    }

    protected void setApiKey(String apiKey) {
        this.storageSet("apiKey", apiKey);
    }

    protected String getDomain() {
        return this.storageGet("domain");
    }

    protected void setDomain(String domain) {
        this.storageSet("domain", domain);
    }

    protected String getAppId() {
        return this.storageGet("appId");
    }

    protected void setAppId(String appId) {
        this.storageSet("appId", appId);
    }

    public String getEmail() {
        return this.storageGet("email");
    }

    protected void setEmail(String email) {
        this.storageSet("email", email);
    }

    public String getUsername() {
        return this.storageGet("username");
    }

    protected void setUsername(String username) {
        this.storageSet("username", username);
    }

    protected String getDeviceIdentifier() {
        String loginIdentifier = this.getLoginIdentifier();
        String deviceIdentifier = TextUtils.isEmpty((CharSequence)loginIdentifier) ? this.storageGet("deviceId") : loginIdentifier;
        return deviceIdentifier;
    }

    protected void setDeviceIdentifier(String deviceId) {
        this.storageSet("deviceId", deviceId);
    }

    public String getDeviceToken() {
        return this.storageGet("deviceToken");
    }

    protected void setDeviceToken(String deviceToken) {
        this.storageSet("deviceToken", deviceToken);
    }

    public String getForegroundIssue() {
        return this.storageGet("foregroundIssue");
    }

    public void setForegroundIssue(String issueId) {
        this.storageSet("foregroundIssue", issueId);
    }

    protected String getLibraryVersion() {
        return this.storageGet("libraryVersion");
    }

    protected void setLibraryVersion(String libraryVersion) {
        this.storageSet("libraryVersion", libraryVersion);
    }

    protected String getApplicationVersion() {
        return this.storageGet("applicationVersion");
    }

    protected void setApplicationVersion(String applicationVersion) {
        this.storageSet("applicationVersion", applicationVersion);
    }

    protected String getSdkType() {
        return this.storageGet("sdkType");
    }

    protected void setSdkType(String sdkType) {
        this.storageSet("sdkType", sdkType);
    }

    public String getActiveConversation(String profileId) {
        String activeConversation = null;
        try {
            JSONObject allActiveConversations = this.storageGetObj("activeConversation");
            activeConversation = allActiveConversations.optString(profileId, null);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getActiveConversation", (Throwable)e);
        }
        return activeConversation;
    }

    protected List<String> getOpenConversations(String profileId) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            JSONObject allOpenConversations = this.storageGetObj("openConversations");
            JSONArray openConversations = allOpenConversations.optJSONArray(profileId);
            if (openConversations != null) {
                int len = openConversations.length();
                for (int i = 0; i < len; ++i) {
                    list.add(openConversations.getString(i));
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getOpenConversations", (Throwable)e);
        }
        return list;
    }

    public String getArchivedConversation(String profileId) {
        String archivedConversation = null;
        try {
            JSONObject allArchivedConversations = this.storageGetObj("archivedConversations");
            archivedConversation = allArchivedConversations.optString(profileId, null);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getArchivedConversation", (Throwable)e);
        }
        return archivedConversation;
    }

    protected int getIssuePushCount(String issueId) throws JSONException {
        int updatedCount = 1;
        JSONObject pushData = this.storageGetObj("pushData");
        if (pushData.has(issueId)) {
            updatedCount = pushData.getInt(issueId) + 1;
        }
        pushData.put(issueId, updatedCount);
        this.storageSet("pushData", pushData);
        return updatedCount;
    }

    protected void setForeground(Boolean state) {
        this.storageSet("foreground", state);
    }

    protected void setActiveConversation(String conversationId, String profileId) {
        try {
            JSONObject allActiveConversations = this.storageGetObj("activeConversation");
            allActiveConversations.put(profileId, (Object)conversationId);
            this.storageSet("activeConversation", allActiveConversations);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"setActiveConversation", (Throwable)e);
        }
    }

    protected void setOpenConversations(List openConversationsList, String profileId) {
        JSONArray openConversations = new JSONArray((Collection)openConversationsList);
        try {
            JSONObject allOpenConversations = this.storageGetObj("openConversations");
            allOpenConversations.put(profileId, (Object)openConversations);
            this.storageSet("openConversations", allOpenConversations);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"setOpenConversations", (Throwable)e);
        }
    }

    protected void setArchivedConversation(String archivedConversationId, String profileId) {
        try {
            JSONObject allArchivedConversations = this.storageGetObj("archivedConversations");
            allArchivedConversations.put(profileId, (Object)archivedConversationId);
            this.storageSet("archivedConversations", allArchivedConversations);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"setArchivedConversation", (Throwable)e);
        }
    }

    public JSONArray getBreadCrumbs() throws JSONException {
        return this.storageGetArr("breadCrumbs");
    }

    protected void pushBreadCrumb(String breadCrumb) {
        int limit = this.getBreadCrumbsLimit();
        try {
            JSONArray crumbsList = this.getBreadCrumbs();
            JSONObject crumbObj = new JSONObject();
            crumbObj.put("action", (Object)breadCrumb);
            crumbObj.put("datetime", (Object)HSFormat.breadCrumbTsFormat.format(new Date()));
            crumbsList.put((Object)crumbObj);
            int length = crumbsList.length();
            if (length > limit) {
                JSONArray newArray = new JSONArray();
                int diff = length - limit;
                for (int i = 0; i < limit; ++i) {
                    newArray.put(i, crumbsList.get(i + diff));
                }
                crumbsList = newArray;
            }
            this.storageSet("breadCrumbs", crumbsList);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"Error while leaving breadcrumb", (Throwable)e);
        }
    }

    protected void clearBreadCrumbs() {
        this.storageSet("breadCrumbs", "[]");
    }

    protected Integer getBreadCrumbsLimit() {
        Integer limit;
        try {
            limit = (Integer)this.getConfig().get("bcl");
        }
        catch (JSONException e) {
            limit = 10;
        }
        return limit;
    }

    protected void updateBreadCrumbsLimit(Integer newLimit) {
        Integer currentLimit = this.getBreadCrumbsLimit();
        if (currentLimit > newLimit) {
            try {
                JSONArray crumbsList = this.getBreadCrumbs();
                JSONArray newArray = new JSONArray();
                Integer diff = currentLimit - newLimit;
                for (int i = 0; i < newLimit; ++i) {
                    newArray.put(i, crumbsList.get(i + diff));
                }
                this.storageSet("breadCrumbs", newArray);
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"Error while updating breadcrumbs limit", (Throwable)e);
            }
        }
    }

    protected JSONObject getConfig() throws JSONException {
        return this.storageGetObj("config");
    }

    protected void setConfig(JSONObject config) {
        this.storageSet("config", config);
    }

    public JSONObject getAppConfig() throws JSONException {
        return this.storageGetObj("appConfig");
    }

    protected void setAppConfig(JSONObject appConfig) {
        this.storageSet("appConfig", appConfig);
    }

    protected int getReviewCounter() {
        return this.storageGetInt("reviewCounter");
    }

    protected void setReviewCounter(int count) {
        this.storageSet("reviewCounter", count);
    }

    protected int getLaunchReviewCounter() {
        return this.storageGetInt("launchReviewCounter");
    }

    protected void setLaunchReviewCounter(int count) {
        this.storageSet("launchReviewCounter", count);
    }

    protected void setReviewed() {
        this.storageSet("reviewed", 1);
    }

    protected void enableReview() {
        this.storageSet("reviewed", 0);
    }

    protected int getReviewed() {
        return this.storageGetInt("reviewed");
    }

    protected JSONArray getStoredFiles() throws JSONException {
        return this.storageGetArr("cachedImages");
    }

    protected void setStoredFiles(JSONArray filenames) {
        this.storageSet("cachedImages", filenames);
    }

    protected JSONObject getEtags() throws JSONException {
        return this.storageGetObj("etags");
    }

    public void setEtag(String url, String etag) {
        try {
            JSONObject etags = this.getEtags();
            etags.put(url, (Object)etag);
            this.storageSet("etags", etags);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"set etag", (Throwable)e);
        }
    }

    protected String getEtag(String url) {
        String etag = "";
        try {
            JSONObject etags = this.getEtags();
            etag = etags.optString(url, "");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"set etag", (Throwable)e);
        }
        return etag;
    }

    protected void storeIndex(HashMap fullIndex) {
        cacheIndex = fullIndex;
        try {
            FileOutputStream fStream = this.context.openFileOutput("fullIndex.db", 0);
            ObjectOutputStream oStream = new ObjectOutputStream(fStream);
            oStream.writeObject(fullIndex);
            oStream.flush();
            oStream.close();
            this.setDBFlag();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"store index", (Throwable)e);
        }
    }

    protected void loadIndex() {
        if (cacheIndex == null) {
            HashMap fullIndex = null;
            try {
                FileInputStream fStream = this.context.openFileInput("fullIndex.db");
                ObjectInputStream oStream = new ObjectInputStream(fStream);
                cacheIndex = fullIndex = (HashMap)oStream.readObject();
                oStream.close();
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"read index", (Throwable)e);
            }
        }
    }

    protected HashMap readIndex() {
        return cacheIndex;
    }

    protected Boolean getDBFlag() {
        return this.storageGetBoolean("dbFlag");
    }

    protected void setDBFlag() {
        this.storageSet("dbFlag", true);
    }

    protected void unsetDBFlag() {
        this.storageSet("dbFlag", false);
    }

    protected void deleteIndex() {
        cacheIndex = null;
        this.context.deleteFile("fullIndex.db");
        this.unsetDBFlag();
    }

    private void setFailedMessages(JSONArray failedMessages, String profileId) {
        try {
            JSONObject allFailedMessages = this.storageGetObj("failedMessages");
            allFailedMessages.put(profileId, (Object)failedMessages);
            this.storageSet("failedMessages", allFailedMessages);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"setFailedMessages", (Throwable)e);
        }
    }

    private JSONArray getFailedMessages(String profileId) throws JSONException {
        JSONArray failedMessages = null;
        try {
            JSONObject allFailedMessages = this.storageGetObj("failedMessages");
            failedMessages = allFailedMessages.optJSONArray(profileId);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getFailedMessages", (Throwable)e);
        }
        if (failedMessages == null) {
            failedMessages = new JSONArray();
        }
        return failedMessages;
    }

    protected JSONObject popFailedMessage(String profileId) throws JSONException {
        JSONArray failedMessages = this.getFailedMessages(profileId);
        JSONArray failedMessagesStore = new JSONArray();
        JSONObject failedMessageRes = null;
        if (failedMessages.length() > 0) {
            for (int i = 0; i < failedMessages.length(); ++i) {
                JSONObject failedMessage = failedMessages.getJSONObject(i);
                if (failedMessageRes == null && failedMessage.getInt("state") > -2) {
                    failedMessageRes = failedMessage;
                    continue;
                }
                failedMessagesStore.put((Object)failedMessage);
            }
            this.setFailedMessages(failedMessagesStore, profileId);
        }
        return failedMessageRes;
    }

    protected JSONObject popFailedMessage(String id2, String profileId) throws JSONException {
        JSONArray failedMessages = this.getFailedMessages(profileId);
        JSONArray failedMessagesStore = new JSONArray();
        JSONObject failedMessageRes = null;
        if (failedMessages.length() > 0) {
            for (int i = 0; i < failedMessages.length(); ++i) {
                JSONObject failedMessage = failedMessages.getJSONObject(i);
                if (failedMessageRes == null && failedMessage.getString("id").equals(id2)) {
                    failedMessageRes = failedMessage;
                    continue;
                }
                failedMessagesStore.put((Object)failedMessage);
            }
            this.setFailedMessages(failedMessagesStore, profileId);
        }
        return failedMessageRes;
    }

    protected JSONArray getFailedMessages(String issueId, String profileId) throws JSONException {
        JSONArray failedMessages = this.getFailedMessages(profileId);
        JSONArray failedMessagesIssue = new JSONArray();
        for (int i = 0; i < failedMessages.length(); ++i) {
            JSONObject failedMessage = failedMessages.getJSONObject(i);
            if (!failedMessage.getString("issue_id").equals(issueId)) continue;
            failedMessagesIssue.put((Object)failedMessage);
        }
        return failedMessagesIssue;
    }

    protected void storeFailedMessage(String issueId, String messageText, String type, String refers, int failedState, String profileId) throws JSONException {
        Date now = new Date();
        JSONObject failedMessage = new JSONObject();
        failedMessage.put("issue_id", (Object)issueId);
        failedMessage.put("body", (Object)messageText);
        failedMessage.put("created_at", (Object)HSFormat.issueTsFormat.format(now));
        failedMessage.put("type", (Object)type);
        failedMessage.put("state", -1);
        failedMessage.put("origin", (Object)"mobile");
        failedMessage.put("refers", (Object)refers);
        failedMessage.put("id", (Object)(now.getTime() + ""));
        failedMessage.put("state", failedState);
        this.storeFailedMessage(failedMessage, profileId);
    }

    protected void storeFailedMessage(JSONObject failedMessage, String profileId) throws JSONException {
        JSONArray failedMessages = this.getFailedMessages(profileId);
        failedMessages.put((Object)failedMessage);
        this.setFailedMessages(failedMessages, profileId);
    }

    protected JSONObject getFailedApiCalls() throws JSONException {
        return this.storageGetObj("failedApiCalls");
    }

    protected void storeFailedApiCall(String key, JSONObject failedApiCall) throws JSONException {
        JSONObject failedApiCalls = this.getFailedApiCalls();
        failedApiCalls.put(key, (Object)failedApiCall);
        this.storageSet("failedApiCalls", failedApiCalls);
    }

    public void storeReply(String replyText, String profileId) {
        try {
            JSONObject allReplyTexts = this.storageGetObj("allReplyTexts");
            allReplyTexts.put(profileId, (Object)replyText);
            this.storageSet("allReplyTexts", allReplyTexts);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"storeReply", (Throwable)e);
        }
    }

    protected String getReply(String profileId) {
        String replyText = "";
        try {
            JSONObject allReplyTexts = this.storageGetObj("allReplyTexts");
            replyText = allReplyTexts.optString(profileId, "");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"storeReply", (Throwable)e);
        }
        return replyText;
    }

    public void storeConversationDetail(String conversationText, String identifier) {
        try {
            JSONObject allConversationDetails = this.storageGetObj("allConversationDetails");
            JSONObject conversationDetail = new JSONObject();
            conversationDetail.put("conversationText", (Object)conversationText);
            conversationDetail.put("conversationTextSetTime", System.nanoTime());
            allConversationDetails.put(identifier, (Object)conversationDetail);
            this.storageSet("allConversationDetails", allConversationDetails);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"storeConversationDetail", (Throwable)e);
        }
    }

    public String getConversationDetail(String identifier) {
        String conversationText = "";
        try {
            JSONObject allConversationDetails = this.storageGetObj("allConversationDetails");
            JSONObject conversationDetail = allConversationDetails.optJSONObject(identifier);
            if (conversationDetail != null) {
                long timeDiff = System.nanoTime() - conversationDetail.getLong("conversationTextSetTime");
                if (timeDiff < 0L || TimeUnit.NANOSECONDS.toSeconds(timeDiff) > 7200L) {
                    this.storeConversationDetail(identifier, "");
                } else {
                    conversationText = conversationDetail.getString("conversationText");
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getConversationDetail", (Throwable)e);
        }
        return conversationText;
    }

    public Float getServerTimeDelta() {
        return this.storageGetFloat("serverTimeDelta");
    }

    protected void setServerTimeDelta(Float delta) {
        this.storageSet("serverTimeDelta", delta);
    }

    protected String getUUID() {
        return this.storageGet("uuid");
    }

    protected void setUUID(String id2) {
        this.storageSet("uuid", id2);
    }

    public void setConversationScreenshot(String screenshotPath, String loginIdentifier) {
        try {
            JSONObject allScreenshots = this.storageGetObj("conversationScreenshots");
            allScreenshots.put(loginIdentifier, (Object)screenshotPath);
            this.storageSet("conversationScreenshots", allScreenshots);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"setConversationScreenshot", (Throwable)e);
        }
    }

    public String getConversationScreenshot(String loginIdentifier) {
        String screenshot = "";
        try {
            JSONObject allScreenshots = this.storageGetObj("conversationScreenshots");
            screenshot = allScreenshots.optString(loginIdentifier, "");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getConversationScreenshot", (Throwable)e);
        }
        return screenshot;
    }

    public Boolean getScreenShotDraft() {
        return this.storageGetBoolean("screenShotDraft");
    }

    public void setScreenShotDraft(Boolean status) {
        this.storageSet("screenShotDraft", status);
    }

    public Boolean getIsConversationShowing() {
        return this.storageGetBoolean("isConversationShowing");
    }

    public void setIsConversationShowing(Boolean status) {
        this.storageSet("isConversationShowing", status);
    }

    public Boolean getRequireEmail() {
        return this.storageGetBoolean("requireEmail");
    }

    public void setRequireEmail(Boolean status) {
        this.storageSet("requireEmail", status);
    }

    public Boolean getEnableFullPrivacy() {
        return this.storageGetBoolean("fullPrivacy");
    }

    public void setEnableFullPrivacy(Boolean status) {
        this.storageSet("fullPrivacy", status);
    }

    public void setShowConversationResolutionQuestion(Boolean status) {
        this.storageSet("showConversationResolutionQuestion", status);
    }

    public Boolean getShowConversationResolutionQuestion() {
        return this.storage.getBoolean("showConversationResolutionQuestion", true);
    }

    public JSONObject getCustomMetaData() {
        try {
            return this.storageGetObj("customMetaData");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"Exception getting meta from storage ", (Throwable)e);
            return null;
        }
    }

    public void setCustomMetaData(JSONObject metaData) {
        if (metaData == null) {
            metaData = new JSONObject();
        }
        this.storageSet("customMetaData", metaData);
    }

    protected JSONObject getIssueCSatStates() {
        try {
            return this.storageGetObj("issueCSatStates");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException : ", (Throwable)e);
            return new JSONObject();
        }
    }

    protected void setIssueCSatStates(JSONObject states) {
        this.storageSet("issueCSatStates", states);
    }

    protected JSONObject getCSatDraft() {
        try {
            return this.storageGetObj("csatDraft");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException : ", (Throwable)e);
            return new JSONObject();
        }
    }

    protected void setCSatDraft(JSONObject draft) {
        this.storageSet("csatDraft", draft);
    }

    public Boolean getHideNameAndEmail() {
        return this.storageGetBoolean("hideNameAndEmail");
    }

    protected void setHideNameAndEmail(Boolean status) {
        this.storageSet("hideNameAndEmail", status);
    }

    public String getConversationPrefillText() {
        return this.storageGet("conversationPrefillText");
    }

    public void setConversationPrefillText(String text) {
        this.storageSet("conversationPrefillText", text);
    }

    public Boolean getShowSearchOnNewConversation() {
        return this.storageGetBoolean("showSearchOnNewConversation");
    }

    protected void setShowSearchOnNewConversation(Boolean status) {
        this.storageSet("showSearchOnNewConversation", status);
    }

    protected JSONObject getCachedAttachmentFiles() {
        try {
            return this.storageGetObj("cachedAttachmentFiles");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getCachedAttachmentFiles : ", (Throwable)e);
            return new JSONObject();
        }
    }

    protected void setCachedAttachmentFiles(JSONObject cachedFiles) {
        this.storageSet("cachedAttachmentFiles", cachedFiles);
    }

    protected void addToCachedAttachmentFiles(String msgId, String path) {
        try {
            JSONObject cachedFiles = this.getCachedAttachmentFiles();
            cachedFiles.put(msgId, (Object)path);
            this.setCachedAttachmentFiles(cachedFiles);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"addToCachedAttachmentFiles : ", (Throwable)e);
        }
    }

    protected void removeFromCachedAttachmentFiles(String msgId) {
        JSONObject cachedFiles = this.getCachedAttachmentFiles();
        cachedFiles.remove(msgId);
        this.setCachedAttachmentFiles(cachedFiles);
    }

    protected void addToDownloadedGenericFiles(String msgId, String filePath) {
        try {
            JSONObject downloadedFiles = this.getDownloadedAttachmentFiles();
            downloadedFiles.put(msgId, (Object)filePath);
            this.setDownloadedAttachmentFiles(downloadedFiles);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"addToDownloadedGenericFiles : ", (Throwable)e);
        }
    }

    protected void removeFromDownloadedGenericFiles(String msgId) {
        JSONObject downloadedGenericFiles = this.getDownloadedAttachmentFiles();
        downloadedGenericFiles.remove(msgId);
        this.setDownloadedAttachmentFiles(downloadedGenericFiles);
    }

    protected String getFilePathForGenericAttachment(String msgId) {
        JSONObject downloadedFiles = this.getDownloadedAttachmentFiles();
        if (downloadedFiles.has(msgId)) {
            try {
                return downloadedFiles.getString(msgId);
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"getFilePathForGenericAttachment : ", (Throwable)e);
            }
        }
        return "";
    }

    protected JSONObject getDownloadedAttachmentFiles() {
        try {
            return this.storageGetObj("downloadedAttachmentFiles");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException : ", (Throwable)e);
            return new JSONObject();
        }
    }

    protected void setDownloadedAttachmentFiles(JSONObject downloadedAttachmentFiles) {
        this.storageSet("downloadedAttachmentFiles", downloadedAttachmentFiles);
    }

    protected JSONObject getDownloadedThumbnailFiles() {
        try {
            return this.storageGetObj("downloadedThumbnailFiles");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getDownloadedThumbnailFiles ", (Throwable)e);
            return new JSONObject();
        }
    }

    protected void setDownloadedThumbnailFiles(JSONObject downloadedThumbnailFiles) {
        this.storageSet("downloadedThumbnailFiles", downloadedThumbnailFiles);
    }

    protected void addToDownloadedThumbnailFiles(String msgId, String filePath) {
        try {
            JSONObject downloadedThumbnailFiles = this.getDownloadedThumbnailFiles();
            downloadedThumbnailFiles.put(msgId, (Object)filePath);
            this.setDownloadedThumbnailFiles(downloadedThumbnailFiles);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"addToDownloadedThumbnailFiles : ", (Throwable)e);
        }
    }

    protected void removeFromDownloadedThumbnailFiles(String msgId) {
        JSONObject downloadedThumbnailFiles = this.getDownloadedThumbnailFiles();
        downloadedThumbnailFiles.remove(msgId);
        this.setDownloadedThumbnailFiles(downloadedThumbnailFiles);
    }

    protected String getFilePathForThumbnail(String msgId) {
        try {
            JSONObject downloadedThumbnailFiles = this.getDownloadedThumbnailFiles();
            if (downloadedThumbnailFiles.has(msgId)) {
                return downloadedThumbnailFiles.getString(msgId);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getFilePathForThumbnail : ", (Throwable)e);
        }
        return "";
    }

    protected JSONObject getDownloadedImageFiles() {
        try {
            return this.storageGetObj("downloadedImageFiles");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getDownloadedImageFiles : ", (Throwable)e);
            return new JSONObject();
        }
    }

    protected void setDownloadedImageFiles(JSONObject downloadedImageFiles) {
        this.storageSet("downloadedImageFiles", downloadedImageFiles);
    }

    protected void addToDownloadedImageFiles(String msgId, String filePath) {
        try {
            JSONObject downloadedImageFiles = this.getDownloadedImageFiles();
            downloadedImageFiles.put(msgId, (Object)filePath);
            this.setDownloadedImageFiles(downloadedImageFiles);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"addToDownloadedImageFiles : ", (Throwable)e);
        }
    }

    protected void removeFromDownloadedImageFiles(String msgId) {
        JSONObject downloadedImageFiles = this.getDownloadedImageFiles();
        downloadedImageFiles.remove(msgId);
        this.setDownloadedImageFiles(downloadedImageFiles);
    }

    protected String getFilePathForImage(String msgId) {
        try {
            JSONObject downloadedImageFiles = this.getDownloadedImageFiles();
            if (downloadedImageFiles.has(msgId)) {
                return downloadedImageFiles.getString(msgId);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getFilePathForImage : ", (Throwable)e);
        }
        return "";
    }

    protected JSONObject getActiveDownloads() {
        try {
            return this.storageGetObj("activeDownloads");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getActiveDownloads : ", (Throwable)e);
            return new JSONObject();
        }
    }

    protected void setActiveDownloads(JSONObject activeDownloads) {
        this.storageSet("activeDownloads", activeDownloads);
    }

    protected void addToActiveDownloads(String msgId, String issueId) {
        try {
            JSONObject activeDownloads = this.getActiveDownloads();
            activeDownloads.put(msgId, (Object)issueId);
            this.setActiveDownloads(activeDownloads);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"addToActiveDownloads : ", (Throwable)e);
        }
    }

    protected void removeFromActiveDownloads(String msgId) {
        JSONObject activeDownloads = this.getActiveDownloads();
        activeDownloads.remove(msgId);
        this.setActiveDownloads(activeDownloads);
    }

    protected boolean isDownloadActive(String msgId) {
        JSONObject activeDownloads = this.getActiveDownloads();
        return activeDownloads.has(msgId);
    }

    protected String getLoginIdentifier() {
        return this.storageGet("loginIdentifier");
    }

    protected void setLoginIdentifier(String loginIdentifier) {
        this.storageSet("loginIdentifier", loginIdentifier);
    }

    public void saveNotification(String issueId, int issueTs, int newMessageCount, String chatLaunchSource, String contentTitle) {
        String profileId = Issue.getProfileId(issueId);
        if (!TextUtils.isEmpty((CharSequence)profileId)) {
            JSONObject notifications = this.getNotifications(profileId);
            try {
                JSONObject newNotification = new JSONObject();
                newNotification.put("issueTs", issueTs);
                newNotification.put("newMessageCount", newMessageCount);
                newNotification.put("chatLaunchSource", (Object)chatLaunchSource);
                newNotification.put("contentTitle", (Object)contentTitle);
                notifications.put(issueId, (Object)newNotification);
                this.setNotifications(profileId, notifications);
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"saveNotification", (Throwable)e);
            }
        }
    }

    private void setNotifications(String profileId, JSONObject notifications) {
        try {
            JSONObject allNotifications = this.storageGetObj("notifications");
            allNotifications.put(profileId, (Object)notifications);
            this.storageSet("notifications", allNotifications);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"setNotifications", (Throwable)e);
        }
    }

    protected JSONObject getNotifications(String profileId) {
        JSONObject notifications = null;
        try {
            JSONObject allNotifications = this.storageGetObj("notifications");
            notifications = allNotifications.optJSONObject(profileId);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getNotifications", (Throwable)e);
        }
        if (notifications == null) {
            notifications = new JSONObject();
        }
        return notifications;
    }

    protected void clearNotification(String issueId) {
        String profileId = Issue.getProfileId(issueId);
        if (!TextUtils.isEmpty((CharSequence)profileId)) {
            try {
                JSONObject notifications = this.getNotifications(profileId);
                notifications.put(issueId, null);
                this.setNotifications(profileId, notifications);
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"clearNotification", (Throwable)e);
            }
        }
    }

    public String getSdkLanguage() {
        return this.storageGet("sdkLanguage");
    }

    protected void setSdkLanguage(String language) {
        this.storageSet("sdkLanguage", language);
    }

    public void updateDisableHelpshiftBranding() {
        Boolean brandingDisabledFromInstall = false;
        try {
            JSONObject config = this.getAppConfig();
            if (config.has("disableHelpshiftBranding")) {
                brandingDisabledFromInstall = config.getBoolean("disableHelpshiftBranding");
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"isHelpshiftBrandingDisabled", (Throwable)e);
        }
        Boolean brandingDisabledFromThemeData = false;
        if (HSConfig.themeData.containsKey("hl")) {
            brandingDisabledFromThemeData = !HSConfig.themeData.get("hl").equals("true");
        }
        this.storageSet("disableHelpshiftBranding", brandingDisabledFromInstall != false || brandingDisabledFromThemeData != false);
    }

    public boolean isHelpshiftBrandingDisabled() {
        return this.storageGetBoolean("disableHelpshiftBranding");
    }

    public long getLastErrorReportedTime() {
        return this.storageGetLong("lastErrorReportedTime");
    }

    public void setLastErrorReportedTime(long time) {
        this.storageSet("lastErrorReportedTime", time);
    }
}

