/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import com.helpshift.support.res.values.HSConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public final class Log {
    public static final String TAG = "HelpshiftDebug";
    private static LinkedList<HashMap> logs = new LinkedList();
    static final int LIMIT = 100;

    private static void updateLogs(HashMap log) {
        Integer logLimit = (Integer)HSConfig.configData.get("dbgl");
        if (logs.size() > 100) {
            try {
                logs.removeLast();
            }
            catch (NoSuchElementException e) {
                android.util.Log.d((String)TAG, (String)"Exception No Such Element", (Throwable)e);
            }
        }
        if (logLimit != 0) {
            logs.addFirst(log);
        }
    }

    public static ArrayList<HashMap> getLogs(int limit) {
        ArrayList<HashMap> logOutput = new ArrayList<HashMap>();
        int size = logs.size();
        for (int i = 0; i < size && i < limit; ++i) {
            try {
                logOutput.add(logs.removeFirst());
                continue;
            }
            catch (NoSuchElementException e) {
                android.util.Log.d((String)TAG, (String)"Exception No Such Element", (Throwable)e);
            }
        }
        logs.clear();
        return logOutput;
    }

    private static void appendLog(Integer level, String tag, String msg) {
        HashMap<String, Object> log = new HashMap<String, Object>();
        log.put("message", msg);
        log.put("level", level);
        log.put("tag", tag);
        Log.updateLogs(log);
    }

    private static void appendLog(Integer level, String tag, String msg, Throwable tr) {
        HashMap<String, Object> log = new HashMap<String, Object>();
        log.put("message", msg);
        log.put("level", level);
        log.put("tag", tag);
        log.put("exception", Log.getStackTraceString(tr));
        Log.updateLogs(log);
    }

    private static void appendLog(Integer level, String tag, Throwable tr) {
        HashMap<String, Object> log = new HashMap<String, Object>();
        log.put("level", level);
        log.put("tag", tag);
        log.put("exception", Log.getStackTraceString(tr));
        Log.updateLogs(log);
    }

    public static int v(String tag, String msg) {
        Log.appendLog((Integer)2, tag, msg);
        return android.util.Log.v((String)tag, (String)msg);
    }

    public static int v(String tag, String msg, Throwable tr) {
        Log.appendLog(2, tag, msg, tr);
        return android.util.Log.v((String)tag, (String)msg, (Throwable)tr);
    }

    public static int d(String tag, String msg) {
        Log.appendLog((Integer)3, tag, msg);
        return android.util.Log.d((String)tag, (String)msg);
    }

    public static int d(String tag, String msg, Throwable tr) {
        Log.appendLog(3, tag, msg, tr);
        return android.util.Log.d((String)tag, (String)msg, (Throwable)tr);
    }

    public static int i(String tag, String msg) {
        Log.appendLog((Integer)4, tag, msg);
        return android.util.Log.i((String)tag, (String)msg);
    }

    public static int i(String tag, String msg, Throwable tr) {
        Log.appendLog(4, tag, msg, tr);
        return android.util.Log.i((String)tag, (String)msg, (Throwable)tr);
    }

    public static int w(String tag, String msg) {
        Log.appendLog((Integer)5, tag, msg);
        return android.util.Log.w((String)tag, (String)msg);
    }

    public static int w(String tag, String msg, Throwable tr) {
        Log.appendLog(5, tag, msg, tr);
        return android.util.Log.e((String)tag, (String)msg, (Throwable)tr);
    }

    public static boolean isLoggable(String tag, int level) {
        return android.util.Log.isLoggable((String)tag, (int)level);
    }

    public static int w(String tag, Throwable tr) {
        Log.appendLog((Integer)5, tag, tr);
        return android.util.Log.w((String)tag, (Throwable)tr);
    }

    public static int e(String tag, String msg) {
        Log.appendLog((Integer)6, tag, msg);
        return android.util.Log.e((String)tag, (String)msg);
    }

    public static int e(String tag, String msg, Throwable tr) {
        Log.appendLog(6, tag, msg, tr);
        return android.util.Log.e((String)tag, (String)msg, (Throwable)tr);
    }

    public static int wtf(String tag, String msg) {
        Log.appendLog((Integer)-1, tag, msg);
        return android.util.Log.wtf((String)tag, (String)msg);
    }

    public static int wtf(String tag, Throwable tr) {
        Log.appendLog((Integer)-1, tag, tr);
        return android.util.Log.wtf((String)tag, (Throwable)tr);
    }

    public static int wtf(String tag, String msg, Throwable tr) {
        Log.appendLog(-1, tag, msg, tr);
        return android.util.Log.wtf((String)tag, (String)msg, (Throwable)tr);
    }

    public static String getStackTraceString(Throwable tr) {
        return android.util.Log.getStackTraceString((Throwable)tr);
    }

    public static int println(int priority, String tag, String msg) {
        return android.util.Log.println((int)priority, (String)tag, (String)msg);
    }
}

