/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.content.Context;
import com.helpshift.support.model.Profile;
import com.helpshift.support.storage.ProfilesDataSource;
import com.helpshift.util.HelpshiftContext;
import java.util.UUID;

public class ProfilesManager {
    private static final String TAG = "HelpShiftDebug";
    private ProfilesDataSource storage;

    public ProfilesManager(Context context) {
        this.storage = new ProfilesDataSource(context);
    }

    public static ProfilesManager getInstance() {
        return Holder.INSTANCE;
    }

    public Profile getProfile(String identifier) {
        Profile profile = this.storage.getProfile(identifier);
        if (profile == null) {
            profile = new Profile(identifier);
            profile.setSalt(UUID.randomUUID().toString());
        }
        return profile;
    }

    public String getProfileId(String identifier) {
        return this.getProfile(identifier).getProfileId();
    }

    public void setProfileId(String identifier, String profileId) {
        Profile profile = this.getProfile(identifier);
        profile.setProfileId(profileId);
        this.storage.addProfile(profile);
    }

    public void setName(String identifier, String name) {
        Profile profile = this.getProfile(identifier);
        profile.setName(name);
        this.storage.addProfile(profile);
    }

    public String getName(String identifier) {
        return this.getProfile(identifier).getName();
    }

    public void setEmail(String identifier, String email) {
        Profile profile = this.getProfile(identifier);
        profile.setEmail(email);
        this.storage.addProfile(profile);
    }

    public String getEmail(String identifier) {
        return this.getProfile(identifier).getEmail();
    }

    private static class Holder {
        private static final ProfilesManager INSTANCE = new ProfilesManager(HelpshiftContext.getApplicationContext());

        private Holder() {
        }
    }
}

