/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.helpshift.support.AlertToRateAppListener;
import com.helpshift.support.Callable;
import com.helpshift.support.ContactUsFilter;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSLifecycleCallbacks;
import com.helpshift.support.HSRetryService;
import com.helpshift.support.HSReview;
import com.helpshift.support.HSReviewFragment;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Initializer;
import com.helpshift.support.UncaughtExceptionHandler;
import com.helpshift.support.activities.ParentActivity;
import com.helpshift.support.constants.ErrorReportTypes;
import com.helpshift.support.flows.Flow;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.model.Issue;
import com.helpshift.support.res.drawable.HSImages;
import com.helpshift.support.res.values.HSConfig;
import com.helpshift.support.storage.ErrorReportsDataSource;
import com.helpshift.support.storage.IssuesDataSource;
import com.helpshift.support.util.DBUtil;
import com.helpshift.support.util.DynamicFormUtil;
import com.helpshift.support.util.HSActivityUtil;
import com.helpshift.support.util.HSNotification;
import com.helpshift.support.util.Meta;
import com.helpshift.util.HSPattern;
import com.helpshift.util.HelpshiftConnectionUtil;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TimeUtil;
import java.io.File;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class SupportInternal {
    public static final String UserAcceptedTheSolution = "User accepted the solution";
    public static final String UserRejectedTheSolution = "User rejected the solution";
    public static final String UserSentScreenShot = "User sent a screenshot";
    public static final String UserReviewedTheApp = "User reviewed the app";
    public static final String JSON_PREFS = "HSJsonData";
    public static final String TAG = "HelpShiftDebug";
    public static final String libraryVersion = "4.2.0";
    public static final String CONVERSATION_FLOW = "conversationFlow";
    public static final String FAQS_FLOW = "faqsFlow";
    public static final String FAQ_SECTION_FLOW = "faqSectionFlow";
    public static final String SINGLE_FAQ_FLOW = "singleFaqFlow";
    public static final String DYNAMIC_FORM_FLOW = "dynamicFormFlow";
    public static final String IssueTagsKey = "hs-tags";
    public static final String TagsKey = "hs-tags";
    public static final String CustomMetadataKey = "hs-custom-metadata";
    private static HSApiData data = null;
    private static HSStorage storage = null;
    private static Context c = null;
    private static Delegate delegate;

    private SupportInternal() {
    }

    private static void init(Application application) {
        SupportInternal.initialize(application.getApplicationContext());
    }

    private static void init(Context context) {
        SupportInternal.initialize(context.getApplicationContext());
    }

    private static void initialize(Context context) {
        HelpshiftContext.setApplicationContext(context);
        if (c == null) {
            data = new HSApiData(context);
            storage = SupportInternal.data.storage;
            ContactUsFilter.init(context);
            Initializer.init(context);
            c = context;
        }
    }

    private static void cleanStorage() {
        String identity = storage.getIdentity();
        String uuid = storage.getUUID();
        Boolean requireEmail = storage.getRequireEmail();
        Boolean fullPrivacy = storage.getEnableFullPrivacy();
        Boolean hideNameEmail = storage.getHideNameAndEmail();
        Boolean showSearchOnNewConversation = storage.getShowSearchOnNewConversation();
        JSONObject metaData = storage.getCustomMetaData();
        Float timeDelta = storage.getServerTimeDelta();
        String oldVersion = storage.getLibraryVersion();
        if (oldVersion.length() > 0 && !oldVersion.equals(libraryVersion)) {
            storage.clearDatabase();
            storage.setIdentity(identity);
            if (!TextUtils.isEmpty((CharSequence)uuid)) {
                storage.setUUID(uuid);
            }
            storage.setRequireEmail(requireEmail);
            storage.setEnableFullPrivacy(fullPrivacy);
            storage.setHideNameAndEmail(hideNameEmail);
            storage.setShowSearchOnNewConversation(showSearchOnNewConversation);
            storage.setCustomMetaData(metaData);
            storage.setServerTimeDelta(timeDelta);
        }
        storage.setLibraryVersion(libraryVersion);
    }

    public static void install(Application application, String apiKey, String domain, String appId) {
        SupportInternal.install(application, apiKey, domain, appId, new HashMap());
    }

    @TargetApi(value=14)
    public static void install(Application application, String apiKey, String domain, String appId, Map config) {
        Object enableDialogUIForTablets;
        Object notifSound;
        SupportInternal.init(application);
        config = new HashMap<String, Constable>(config);
        if (!config.containsKey("disableErrorLogging") || !((Boolean)config.get("disableErrorLogging")).booleanValue()) {
            UncaughtExceptionHandler.init(application.getApplicationContext());
        }
        SupportInternal.cleanStorage();
        DBUtil.restoreDatabaseBackup("__hs__db_profiles");
        if (config == null) {
            config = new HashMap();
        }
        String profileId = data.getProfileId();
        if ((String)config.get("sdkType") != null) {
            storage.setSdkType((String)config.get("sdkType"));
        } else {
            storage.setSdkType("android");
        }
        Object notifIcon = config.get("notificationIcon");
        if (notifIcon != null && notifIcon instanceof String) {
            String mDrawableName = (String)notifIcon;
            int resId = application.getResources().getIdentifier(mDrawableName, "drawable", application.getPackageName());
            config.put("notificationIcon", Integer.valueOf(resId));
        }
        if ((notifSound = config.get("notificationSound")) != null && notifSound instanceof String) {
            String mDrawableName = (String)notifSound;
            int resId = application.getResources().getIdentifier(mDrawableName, "raw", application.getPackageName());
            config.put("notificationSound", Integer.valueOf(resId));
        }
        if ((enableDialogUIForTablets = config.get("enableDialogUIForTablets")) != null && enableDialogUIForTablets instanceof Boolean) {
            Boolean enableDialogUi = (Boolean)enableDialogUIForTablets;
            config.put("enableDialogUIForTablets", enableDialogUi);
        }
        storage.updateDisableHelpshiftBranding();
        try {
            String applicationVersion = SupportInternal.c.getPackageManager().getPackageInfo((String)SupportInternal.c.getPackageName(), (int)0).versionName;
            if (!storage.getApplicationVersion().equals(applicationVersion)) {
                data.resetReviewCounter();
                data.enableReview();
                storage.setApplicationVersion(applicationVersion);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)TAG, (String)"Application Name Not Found", (Throwable)e);
        }
        HSImages.initImages(c);
        storage.setAppConfig(new JSONObject(config));
        storage.setActiveDownloads(new JSONObject());
        data.install(apiKey, domain, appId);
        if (!TextUtils.isEmpty((CharSequence)profileId)) {
            try {
                data.getLatestIssues(new Handler(), new Handler());
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"Install - Get Latest Issues", (Throwable)e);
            }
        }
        if (Build.VERSION.SDK_INT >= 14) {
            HSLifecycleCallbacks hsLifecycleCallbacks = HSLifecycleCallbacks.getInstance();
            application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)hsLifecycleCallbacks);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)hsLifecycleCallbacks);
        } else {
            data.updateReviewCounter();
            if (data.showReviewP().booleanValue()) {
                Intent i = new Intent(c, HSReview.class);
                i.setFlags(0x10000000);
                c.startActivity(i);
            }
            try {
                data.getConfig(new Handler(){

                    public void handleMessage(Message msg) {
                        HSConfig.updateConfig((JSONObject)msg.obj);
                        storage.updateActiveConversation(data.getProfileId());
                    }
                }, new Handler());
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)e.toString(), (Throwable)e);
            }
            if (HelpshiftConnectionUtil.isOnline(c)) {
                c.startService(new Intent(c, HSRetryService.class));
            }
            data.startInAppService();
            data.reportAppStartEvent();
            if (ErrorReportsDataSource.hasReports()) {
                long lastReportedTime = storage.getLastErrorReportedTime();
                long currentElapsedTime = TimeUtil.getAdjustedTimeInMillis(storage.getServerTimeDelta());
                if (currentElapsedTime - lastReportedTime > 86400000L) {
                    storage.setLastErrorReportedTime(currentElapsedTime);
                    data.sendErrorReports(ErrorReportTypes.RUNTIME_ERROR);
                }
            }
        }
    }

    public static Integer getNotificationCount() {
        if (data != null) {
            return SupportInternal.data.storage.getActiveNotifCnt(data.getProfileId());
        }
        return 0;
    }

    public static void getNotificationCount(Handler success, final Handler failure) {
        if (success != null) {
            if (data == null || storage == null) {
                if (HelpshiftContext.getApplicationContext() != null) {
                    SupportInternal.init(HelpshiftContext.getApplicationContext());
                } else {
                    return;
                }
            }
            Integer activeCnt = storage.getActiveNotifCnt(data.getProfileId());
            Message msgToPost = success.obtainMessage();
            Bundle countData = new Bundle();
            countData.putInt("value", activeCnt.intValue());
            countData.putBoolean("cache", true);
            msgToPost.obj = countData;
            success.sendMessage(msgToPost);
            Handler localFailure = new Handler(){

                public void handleMessage(Message msg) {
                    if (failure != null) {
                        Message msgToPost = failure.obtainMessage();
                        msgToPost.obj = msg.obj;
                        failure.sendMessage(msgToPost);
                    }
                }
            };
            String profileId = data.getProfileId();
            if (!TextUtils.isEmpty((CharSequence)profileId)) {
                data.getNotificationCount(success, localFailure);
            } else {
                Message failureMsg = localFailure.obtainMessage();
                Bundle failureCount = new Bundle();
                failureCount.putInt("value", -1);
                failureMsg.obj = failureCount;
                localFailure.sendMessage(failureMsg);
            }
        }
    }

    public static void setNameAndEmail(String name, String email) {
        name = name == null ? "" : name.trim();
        email = email == null ? "" : email.trim();
        if (TextUtils.isEmpty((CharSequence)name) && TextUtils.isEmpty((CharSequence)email)) {
            data.setUsername("");
            data.setEmail("");
        }
        if (!TextUtils.isEmpty((CharSequence)name) && !HSPattern.checkSpecialCharacters(name)) {
            data.setUsername(name);
        }
        if (!TextUtils.isEmpty((CharSequence)email) && HSPattern.checkEmail(email)) {
            data.setEmail(email);
        }
    }

    public static void setUserIdentifier(String userIdentifier) {
        if (userIdentifier != null) {
            storage.setDeviceIdentifier(userIdentifier.trim());
        }
    }

    public static void registerDeviceToken(Context context, String deviceToken) {
        SupportInternal.init(context);
        if (deviceToken != null) {
            String profileId = data.getProfileId();
            storage.setDeviceToken(deviceToken);
            if (!TextUtils.isEmpty((CharSequence)profileId)) {
                data.updateUAToken();
            }
        } else {
            Log.d((String)TAG, (String)"Device Token is null");
        }
    }

    public static void leaveBreadCrumb(String breadCrumb) {
        if (breadCrumb != null && !TextUtils.isEmpty((CharSequence)breadCrumb.trim())) {
            storage.pushBreadCrumb(breadCrumb);
        }
    }

    public static void clearBreadCrumbs() {
        storage.clearBreadCrumbs();
    }

    public static void showConversation(Activity a) {
        SupportInternal.showConversation(a, new HashMap());
    }

    public static void showConversation(Activity a, Map config) {
        HashMap configHashMap = new HashMap(config);
        Intent i = new Intent((Context)a, ParentActivity.class);
        i.putExtra("support_mode", 1);
        i.putExtra("decomp", true);
        i.putExtras(SupportInternal.cleanConfig(configHashMap));
        i.putExtra("showInFullScreen", (Serializable)HSActivityUtil.isFullScreen(a));
        i.putExtra("chatLaunchSource", "support");
        i.putExtra("isRoot", true);
        i.putExtra("search_performed", false);
        a.startActivity(i);
    }

    public static void showFAQSection(Activity a, String sectionPublishId) {
        SupportInternal.showFAQSection(a, sectionPublishId, new HashMap());
    }

    public static void showFAQSection(Activity a, String sectionPublishId, Map config) {
        HashMap configHashMap = new HashMap(config);
        Intent i = new Intent((Context)a, ParentActivity.class);
        i.putExtra("support_mode", 2);
        i.putExtras(SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap)));
        i.putExtra("sectionPublishId", sectionPublishId);
        i.putExtra("showInFullScreen", (Serializable)HSActivityUtil.isFullScreen(a));
        i.putExtra("decomp", true);
        i.putExtra("isRoot", true);
        a.startActivity(i);
    }

    public static void showSingleFAQ(Activity a, String questionPublishId) {
        SupportInternal.showSingleFAQ(a, questionPublishId, new HashMap());
    }

    public static void showSingleFAQ(Activity a, String questionPublishId, Map config) {
        HashMap configHashMap = new HashMap(config);
        Intent i = new Intent((Context)a, ParentActivity.class);
        i.putExtra("support_mode", 3);
        i.putExtras(SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap)));
        i.putExtra("questionPublishId", questionPublishId);
        i.putExtra("showInFullScreen", (Serializable)HSActivityUtil.isFullScreen(a));
        i.putExtra("decomp", true);
        i.putExtra("isRoot", true);
        a.startActivity(i);
    }

    public static void setMetadataCallback(Callable f) {
        Meta.setMetadataCallback(f);
        try {
            storage.setCustomMetaData(Meta.getCustomMeta());
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"Exception getting custom meta ", (Throwable)e);
        }
    }

    private static void createMetadataCallback(final HashMap config) {
        Callable f = null;
        if (config.containsKey(CustomMetadataKey)) {
            f = new Callable(){

                @Override
                public HashMap call() {
                    if (config.get(SupportInternal.CustomMetadataKey) instanceof HashMap) {
                        return (HashMap)config.get(SupportInternal.CustomMetadataKey);
                    }
                    return null;
                }
            };
            SupportInternal.setMetadataCallback(f);
        }
    }

    public static void showFAQs(Activity a) {
        SupportInternal.showFAQs(a, new HashMap());
    }

    public static void showFAQs(Activity a, Map config) {
        HashMap configHashMap = new HashMap(config);
        Intent i = new Intent((Context)a, ParentActivity.class);
        i.putExtras(SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap)));
        i.putExtra("showInFullScreen", (Serializable)HSActivityUtil.isFullScreen(a));
        i.putExtra("decomp", false);
        i.putExtra("isRoot", true);
        a.startActivity(i);
    }

    public static void showDynamicForm(Activity activity, List<Flow> flowList) {
        Intent intent = new Intent((Context)activity, ParentActivity.class);
        ParentActivity.FlowListHolder.setFlowList(flowList);
        intent.putExtra("showInFullScreen", (Serializable)HSActivityUtil.isFullScreen(activity));
        intent.putExtra("support_mode", 4);
        activity.startActivity(intent);
    }

    public static void showDynamicFormFromData(Activity activity, List<HashMap<String, Object>> flowArray) {
        SupportInternal.showDynamicForm(activity, DynamicFormUtil.toFlowList((Context)activity, flowArray));
    }

    public static HashMap removeFAQFlowUnsupportedConfigs(HashMap config) {
        String[] unsupportedConfigs;
        if (config == null) {
            config = new HashMap();
        }
        for (String s : unsupportedConfigs = new String[]{"conversationPrefillText"}) {
            config.remove(s);
            if (!s.equals("showSearchOnNewConversation")) continue;
            storage.setShowSearchOnNewConversation(false);
        }
        return config;
    }

    public static Bundle cleanConfig(HashMap configMap) {
        ContactUsFilter.setConfig(configMap);
        Bundle cleanConfig = new Bundle();
        if (configMap != null) {
            SupportInternal.createMetadataCallback(configMap);
            JSONObject config = new JSONObject((Map)configMap);
            Boolean showConvOnReportIssue = config.optBoolean("gotoCoversationAfterContactUs", false) || config.optBoolean("gotoConversationAfterContactUs", false);
            try {
                if (config.has("requireEmail")) {
                    storage.setRequireEmail(config.getBoolean("requireEmail"));
                }
                if (config.has("hideNameAndEmail")) {
                    storage.setHideNameAndEmail(config.getBoolean("hideNameAndEmail"));
                }
                if (config.has("showSearchOnNewConversation")) {
                    storage.setShowSearchOnNewConversation(config.getBoolean("showSearchOnNewConversation"));
                }
                if (config.has("enableFullPrivacy")) {
                    storage.setEnableFullPrivacy(config.getBoolean("enableFullPrivacy"));
                }
                if (config.has("showConversationResolutionQuestion")) {
                    storage.setShowConversationResolutionQuestion(config.getBoolean("showConversationResolutionQuestion"));
                }
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)("Exception parsing config : " + (Object)((Object)e)));
            }
            storage.setConversationPrefillText(null);
            try {
                if (config.has("conversationPrefillText") && !config.getString("conversationPrefillText").equals("null")) {
                    String prefillText;
                    if (config.has(CustomMetadataKey)) {
                        cleanConfig.putBoolean("dropMeta", true);
                    }
                    if (!TextUtils.isEmpty((CharSequence)(prefillText = config.getString("conversationPrefillText").trim()))) {
                        storage.setConversationPrefillText(prefillText);
                    }
                }
                if (config.has("toolbarId")) {
                    cleanConfig.putInt("toolbarId", config.getInt("toolbarId"));
                }
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"JSON exception while parsing config : ", (Throwable)e);
            }
            cleanConfig.putBoolean("showConvOnReportIssue", showConvOnReportIssue.booleanValue());
            cleanConfig.putBoolean("showSearchOnNewConversation", config.optBoolean("showSearchOnNewConversation", false));
            cleanConfig.putSerializable("withTagsMatching", (Serializable)SupportInternal.cleanFaqTagFilter(configMap.get("withTagsMatching")));
        }
        return cleanConfig;
    }

    private static FaqTagFilter cleanFaqTagFilter(Object filterTagsConfigObject) {
        if (filterTagsConfigObject == null) {
            return null;
        }
        try {
            Map filterTagsConfig = (Map)filterTagsConfigObject;
            String operator = (String)filterTagsConfig.get("operator");
            if (!TextUtils.isEmpty((CharSequence)operator)) {
                operator = operator.trim().toLowerCase(Locale.US);
                String[] tags = (String[])filterTagsConfig.get("tags");
                if (tags != null && tags.length > 0) {
                    if (operator.equals("and")) {
                        return new FaqTagFilter(FaqTagFilter.Operator.AND, tags);
                    }
                    if (operator.equals("or")) {
                        return new FaqTagFilter(FaqTagFilter.Operator.OR, tags);
                    }
                    if (operator.equals("not")) {
                        return new FaqTagFilter(FaqTagFilter.Operator.NOT, tags);
                    }
                }
            }
        }
        catch (ClassCastException e) {
            Log.d((String)TAG, (String)"Invalid FaqTagFilter object in config", (Throwable)e);
        }
        return null;
    }

    public static void handlePush(Context context, Intent i) {
        SupportInternal.init(context);
        String issueId = i.getExtras().getString("issue_id");
        if (!storage.getForegroundIssue().equals(issueId)) {
            try {
                int messCnt = storage.getIssuePushCount(issueId);
                Issue issue = IssuesDataSource.getIssue(issueId);
                if (issue != null) {
                    HSNotification.showNotif(c, issue, messCnt, "push", i);
                }
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"handlePush JSONException", (Throwable)e);
            }
        }
    }

    public static void handlePush(Context context, Bundle data) {
        Intent pushIntent = new Intent();
        pushIntent.putExtras(data);
        SupportInternal.handlePush(context, pushIntent);
    }

    public static void showAlertToRateApp(String url, AlertToRateAppListener alertToRateAppListener) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)url)) {
            intent.setData(Uri.parse((String)url.trim()));
        }
        if (TextUtils.isEmpty((CharSequence)url) || intent.resolveActivity(c.getPackageManager()) == null) {
            if (alertToRateAppListener != null) {
                alertToRateAppListener.onAction(3);
            }
            return;
        }
        HSReviewFragment.setAlertToRateAppListener(alertToRateAppListener);
        Intent i = new Intent(c, HSReview.class);
        i.putExtra("disableReview", false);
        i.putExtra("rurl", url.trim());
        i.setFlags(0x10000000);
        c.startActivity(i);
    }

    public static Delegate getDelegate() {
        return delegate;
    }

    public static void setDelegate(Delegate delegate) {
        SupportInternal.delegate = delegate;
    }

    public static void login(String identifier, String name, String email) {
        boolean loginSucceeded = data.login(identifier);
        if (loginSucceeded) {
            SupportInternal.setNameAndEmail(name, email);
        }
    }

    public static void logout() {
        data.logout();
    }

    public static void setSDKLanguage(String locale) {
        storage.setSdkLanguage(locale);
    }

    public static SupportFragment getFAQsFragment(Activity activity) {
        return SupportInternal.getFAQsFragment(activity, new HashMap());
    }

    public static SupportFragment getFAQsFragment(Activity activity, Map config) {
        HashMap configHashMap = new HashMap(config);
        Bundle bundle = SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap));
        bundle.putBoolean("showInFullScreen", HSActivityUtil.isFullScreen(activity).booleanValue());
        return SupportFragment.newInstance(bundle);
    }

    public static SupportFragment getConversationFragment(Activity activity) {
        return SupportInternal.getConversationFragment(activity, new HashMap());
    }

    public static SupportFragment getConversationFragment(Activity activity, Map config) {
        HashMap configHashMap = new HashMap(config);
        Bundle bundle = SupportInternal.cleanConfig(configHashMap);
        bundle.putBoolean("showInFullScreen", HSActivityUtil.isFullScreen(activity).booleanValue());
        bundle.putInt("support_mode", 1);
        bundle.putBoolean("decomp", true);
        bundle.putBoolean("showInFullScreen", HSActivityUtil.isFullScreen(activity).booleanValue());
        bundle.putString("chatLaunchSource", "support");
        bundle.putBoolean("isRoot", true);
        bundle.putBoolean("search_performed", false);
        return SupportFragment.newInstance(bundle);
    }

    public static SupportFragment getFAQSectionFragment(Activity activity, String sectionPublishId) {
        return SupportInternal.getFAQSectionFragment(activity, sectionPublishId, new HashMap());
    }

    public static SupportFragment getFAQSectionFragment(Activity activity, String sectionPublishId, Map config) {
        HashMap configHashMap = new HashMap(config);
        Bundle bundle = SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap));
        bundle.putInt("support_mode", 2);
        bundle.putString("sectionPublishId", sectionPublishId);
        bundle.putBoolean("showInFullScreen", HSActivityUtil.isFullScreen(activity).booleanValue());
        bundle.putBoolean("decomp", true);
        bundle.putBoolean("isRoot", true);
        return SupportFragment.newInstance(bundle);
    }

    public static SupportFragment getSingleFAQFragment(Activity activity, String questionPublishId) {
        return SupportInternal.getSingleFAQFragment(activity, questionPublishId, new HashMap());
    }

    public static SupportFragment getSingleFAQFragment(Activity activity, String questionPublishId, Map config) {
        HashMap configHashMap = new HashMap(config);
        Bundle bundle = SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(configHashMap));
        bundle.putInt("support_mode", 3);
        bundle.putString("questionPublishId", questionPublishId);
        bundle.putBoolean("showInFullScreen", HSActivityUtil.isFullScreen(activity).booleanValue());
        bundle.putBoolean("decomp", true);
        bundle.putBoolean("isRoot", true);
        return SupportFragment.newInstance(bundle);
    }

    public static SupportFragment getDynamicFormFragment(Activity activity, List<Flow> flowList) {
        return SupportInternal.getDynamicFormFragment(activity, flowList, new HashMap());
    }

    public static SupportFragment getDynamicFormFragment(Activity activity, List<Flow> flowList, Map config) {
        ParentActivity.FlowListHolder.setFlowList(flowList);
        HashMap configHashMap = new HashMap(config);
        Bundle bundle = SupportInternal.cleanConfig(configHashMap);
        bundle.putInt("support_mode", 4);
        bundle.putBoolean("showInFullScreen", HSActivityUtil.isFullScreen(activity).booleanValue());
        return SupportFragment.newInstance(bundle);
    }

    public static class EnableContactUs {
        public static final Integer ALWAYS = 0;
        public static final Integer NEVER = 1;
        public static final Integer AFTER_VIEWING_FAQS = 2;
        public static final Integer AFTER_MARKING_ANSWER_UNHELPFUL = 3;
    }

    public static class RateAlert {
        public static final int SUCCESS = 0;
        public static final int FEEDBACK = 1;
        public static final int CLOSE = 2;
        public static final int FAIL = 3;
    }

    public static interface Delegate {
        public void sessionBegan();

        public void sessionEnded();

        public void newConversationStarted(String var1);

        public void userRepliedToConversation(String var1);

        public void userCompletedCustomerSatisfactionSurvey(int var1, String var2);

        public void displayAttachmentFile(File var1);

        public void didReceiveNotification(int var1);
    }
}

