/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.adapters;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.support.adapters.MessageListAdapterHolders;
import com.helpshift.support.model.Message;
import java.util.List;

public class MessageListAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final List<Message> messages;
    private final View.OnLongClickListener onLongClickListener;
    private final View.OnClickListener onClickListener;

    public MessageListAdapter(List<Message> messages, View.OnLongClickListener onLongClickListener, View.OnClickListener onClickListener) {
        this.messages = messages;
        this.onLongClickListener = onLongClickListener;
        this.onClickListener = onClickListener;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 1: {
                return MessageListAdapterHolders.MobileTxtHolder.create(parent, this.onLongClickListener);
            }
            case 2: {
                return MessageListAdapterHolders.AdminTxtHolder.create(parent, this.onLongClickListener);
            }
            case 3: {
                return MessageListAdapterHolders.AdminRarHolder.create(parent, this.onLongClickListener, this.onClickListener);
            }
            case 4: {
                return MessageListAdapterHolders.AdminAttachmentImageHolder.create(parent, this.onLongClickListener);
            }
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        Message message = this.messages.get(position);
        if (holder instanceof MessageListAdapterHolders.MobileTxtHolder) {
            MessageListAdapterHolders.MobileTxtHolder.configure((MessageListAdapterHolders.MobileTxtHolder)holder, message);
        } else if (holder instanceof MessageListAdapterHolders.AdminTxtHolder) {
            MessageListAdapterHolders.AdminTxtHolder.configure((MessageListAdapterHolders.AdminTxtHolder)holder, message);
        } else if (holder instanceof MessageListAdapterHolders.AdminRarHolder) {
            MessageListAdapterHolders.AdminRarHolder.configure((MessageListAdapterHolders.AdminRarHolder)holder, message);
        } else if (holder instanceof MessageListAdapterHolders.AdminAttachmentImageHolder) {
            MessageListAdapterHolders.AdminAttachmentImageHolder.configure((MessageListAdapterHolders.AdminAttachmentImageHolder)holder, message);
        }
    }

    public int getItemCount() {
        return this.messages.size();
    }

    public int getItemViewType(int position) {
        Message message = this.messages.get(position);
        String origin = message.getOrigin();
        String type = message.getType();
        if (origin.equals("mobile") && type.equals("txt")) {
            return 1;
        }
        if (origin.equals("admin") && type.equals("txt")) {
            return 2;
        }
        if (origin.equals("admin") && type.equals("rar")) {
            return 3;
        }
        if (origin.equals("admin") && type.equals("admin_attachment_image")) {
            return 4;
        }
        return 0;
    }
}

