/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.BackgroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.support.ContactUsFilter;
import com.helpshift.support.Faq;
import com.helpshift.support.util.HSTransliterator;
import com.helpshift.support.util.Styles;
import java.util.ArrayList;
import java.util.List;

public class SearchResultAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_HEADER = 1;
    private static final int TYPE_FOOTER = 2;
    private static final int TYPE_QUESTION = 3;
    private List<Faq> questions;
    private View.OnClickListener onQuestionClickedListener;
    private View.OnClickListener onContactUsClickedListener;

    public SearchResultAdapter(List<Faq> questions, View.OnClickListener onQuestionClickedListener, View.OnClickListener sendAnywayClickedListener) {
        this.questions = questions;
        this.onQuestionClickedListener = onQuestionClickedListener;
        this.onContactUsClickedListener = sendAnywayClickedListener;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 1: {
                TextView headerView = (TextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hs__search_result_header, parent, false);
                return new HeaderViewHolder(headerView);
            }
            case 2: {
                LinearLayout linearLayout = (LinearLayout)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hs__search_result_footer, parent, false);
                return new FooterViewHolder(linearLayout);
            }
        }
        TextView textView = (TextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.hs_simple_recycler_view_item, parent, false);
        return new QuestionViewHolder(textView);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof FooterViewHolder) {
            FooterViewHolder footerViewHolder = (FooterViewHolder)holder;
            this.configureFooterViewHolder(footerViewHolder);
        } else if (holder instanceof QuestionViewHolder) {
            QuestionViewHolder questionViewHolder = (QuestionViewHolder)holder;
            this.configureQuestionViewHolder(questionViewHolder, position);
        }
    }

    private void configureFooterViewHolder(FooterViewHolder holder) {
        if (ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.SEARCH_FOOTER)) {
            holder.rootView.setVisibility(0);
            holder.button.setOnClickListener(this.onContactUsClickedListener);
        } else {
            holder.rootView.setVisibility(8);
        }
    }

    private void configureQuestionViewHolder(QuestionViewHolder holder, int position) {
        Faq question = this.questions.get(position - 1);
        ArrayList<String> matchedWords = question.getSearchTerms();
        String title = question.getTitle();
        if (matchedWords != null && matchedWords.size() > 0) {
            int highlightColor = Styles.getColor(holder.textView.getContext(), R.attr.hs__searchHighlightColor);
            SpannableString spannedTitle = new SpannableString((CharSequence)title);
            boolean isEnglish = title.equals(HSTransliterator.unidecode(title));
            if (isEnglish) {
                title = title.toLowerCase();
                for (String word : matchedWords) {
                    if (word.length() < 3) continue;
                    int index = TextUtils.indexOf((CharSequence)title, (CharSequence)word, (int)0);
                    while (index >= 0) {
                        spannedTitle.setSpan((Object)new BackgroundColorSpan(highlightColor), index, index + word.length(), 33);
                        index = TextUtils.indexOf((CharSequence)title, (CharSequence)word, (int)(index + word.length()));
                    }
                }
            } else {
                int titleLength = title.length();
                String transliteration = "";
                ArrayList<Integer> titleIndex = new ArrayList<Integer>();
                for (int i = 0; i < titleLength; ++i) {
                    char character = title.charAt(i);
                    String charTransliteration = HSTransliterator.unidecode(character + "");
                    for (int j = 0; j < charTransliteration.length(); ++j) {
                        transliteration = transliteration + charTransliteration.charAt(j);
                        titleIndex.add(i);
                    }
                }
                transliteration = transliteration.toLowerCase();
                for (String word : matchedWords) {
                    if ((word = word.toLowerCase()).length() < 3) continue;
                    int index = TextUtils.indexOf((CharSequence)transliteration, (CharSequence)word, (int)0);
                    while (index >= 0) {
                        spannedTitle.setSpan((Object)new BackgroundColorSpan(highlightColor), ((Integer)titleIndex.get(index)).intValue(), (Integer)titleIndex.get(index + word.length() - 1) + 1, 33);
                        index = TextUtils.indexOf((CharSequence)transliteration, (CharSequence)word, (int)(index + word.length()));
                    }
                }
            }
            holder.textView.setText((CharSequence)spannedTitle);
        } else {
            holder.textView.setText((CharSequence)title);
        }
        holder.textView.setOnClickListener(this.onQuestionClickedListener);
        holder.textView.setTag((Object)question.getPublishId());
    }

    public Faq getFaq(String publishId) {
        if (this.questions != null) {
            for (Faq question : this.questions) {
                if (!question.getPublishId().equals(publishId)) continue;
                return question;
            }
        }
        return null;
    }

    public int getItemViewType(int position) {
        if (position == 0) {
            return 1;
        }
        if (this.isPositionFooter(position)) {
            return 2;
        }
        return 3;
    }

    public long getItemId(int position) {
        if (position == 0) {
            return 1L;
        }
        if (this.isPositionFooter(position)) {
            return 2L;
        }
        return Long.valueOf(this.questions.get(position - 1).getPublishId());
    }

    public int getItemCount() {
        return this.questions.size() + 2;
    }

    private boolean isPositionFooter(int position) {
        return position == this.getItemCount() - 1;
    }

    protected static class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        public HeaderViewHolder(TextView headerView) {
            super((View)headerView);
        }
    }

    protected static class FooterViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout rootView;
        private Button button;

        public FooterViewHolder(LinearLayout linearLayout) {
            super((View)linearLayout);
            this.rootView = linearLayout;
            this.button = (Button)linearLayout.findViewById(R.id.send_anyway_button);
        }
    }

    protected static class QuestionViewHolder
    extends RecyclerView.ViewHolder {
        private TextView textView;

        public QuestionViewHolder(TextView textView) {
            super((View)textView);
            this.textView = textView;
        }
    }
}

