/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.compositions;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.R;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.Section;
import com.helpshift.support.constants.GetSectionsCallBackStatus;
import com.helpshift.support.contracts.FaqFragmentListener;
import com.helpshift.support.fragments.FaqFlowFragment;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.QuestionListFragment;
import com.helpshift.support.fragments.SectionListFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.support.util.SnackbarUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class FaqFragment
extends MainFragment {
    private int sectionsSize = 0;
    private FaqFragmentListener faqFragmentListener;
    private FaqTagFilter faqTagFilter;
    private HSApiData data;

    public static FaqFragment newInstance(Bundle bundle, FaqFragmentListener faqFragmentListener) {
        FaqFragment faqFragment = new FaqFragment();
        faqFragment.setArguments(bundle);
        faqFragment.faqFragmentListener = faqFragmentListener;
        return faqFragment;
    }

    private void updateFragment(FaqFragment faqFragment, ArrayList<Section> sections) {
        if ((sections = faqFragment.data.getPopulatedSections(sections, faqFragment.faqTagFilter)).size() == 1) {
            Bundle bundle = new Bundle();
            bundle.putString("sectionPublishId", sections.get(0).getPublishId());
            QuestionListFragment questionListFragment = QuestionListFragment.newInstance(bundle, faqFragment.faqFragmentListener);
            try {
                FragmentUtil.startFragment(faqFragment.getRetainedChildFragmentManager(), R.id.faq_fragment_container, questionListFragment, null, null, false);
            }
            catch (IllegalStateException e) {}
        } else {
            Bundle bundle = faqFragment.getBundle();
            bundle.putParcelableArrayList("sections", sections);
            SectionListFragment sectionListFragment = SectionListFragment.newInstance(bundle, faqFragment.faqFragmentListener);
            try {
                FragmentUtil.startFragment(faqFragment.getRetainedChildFragmentManager(), R.id.faq_fragment_container, sectionListFragment, null, null, false);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        this.sendFaqLoadedEvent();
    }

    private void sendFaqLoadedEvent() {
        SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
        if (supportFragment != null) {
            supportFragment.setFaqLoaded(true);
        }
    }

    public void updateFaqLoadingUI(int state) {
        FaqFlowFragment faqFlowFragment = (FaqFlowFragment)this.getParentFragment();
        SupportFragment supportFragment = null;
        if (faqFlowFragment != null) {
            supportFragment = (SupportFragment)faqFlowFragment.getParentFragment();
        }
        if (supportFragment != null) {
            if (state == 1) {
                faqFlowFragment.showVerticalDivider(true);
                faqFlowFragment.updateSelectQuestionUI();
            } else {
                faqFlowFragment.showVerticalDivider(false);
                faqFlowFragment.updateSelectQuestionUI(false);
            }
            supportFragment.updateFaqLoadingUI(state);
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getActivity(this).getIntent().getExtras();
        if (extras != null) {
            this.faqTagFilter = (FaqTagFilter)extras.getSerializable("withTagsMatching");
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__faq_fragment, container, false);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.data = new HSApiData(context);
    }

    public void onResume() {
        super.onResume();
        if (this.sectionsSize == 0) {
            this.updateFaqLoadingUI(0);
        }
        this.data.getSections(new Success(this), new Failure(this), this.faqTagFilter);
    }

    public void onStart() {
        super.onStart();
        if (!this.isChangingConfigurations()) {
            HSFunnel.pushEvent("l");
        }
        this.addVisibleFragment();
    }

    @Override
    public void onStop() {
        super.onStop();
        this.removeVisibleFragment();
        this.updateFaqLoadingUI(1);
    }

    public void retryGetSections() {
        if (this.sectionsSize == 0) {
            this.updateFaqLoadingUI(0);
        }
        this.data.getSections(new Success(this), new Failure(this), this.faqTagFilter);
    }

    private ArrayList<Section> removeEmptySections(ArrayList<Section> sections) {
        ArrayList<Section> nonEmptySections = new ArrayList<Section>();
        for (Section section : sections) {
            ArrayList faqsForSection = this.data.getFaqsForSection(section.getPublishId(), this.faqTagFilter);
            if (faqsForSection == null || faqsForSection.isEmpty()) continue;
            nonEmptySections.add(section);
        }
        return nonEmptySections;
    }

    private static class Failure
    extends Handler {
        private final WeakReference<FaqFragment> faqFragmentWeakReference;
        private final String networkErrorMessage;

        public Failure(FaqFragment fragment) {
            this.faqFragmentWeakReference = new WeakReference<FaqFragment>(fragment);
            this.networkErrorMessage = fragment.getString(R.string.hs__network_error_msg);
        }

        public void handleMessage(Message msg) {
            FaqFragment faqFragment = (FaqFragment)((Object)this.faqFragmentWeakReference.get());
            if (faqFragment != null && !faqFragment.isDetached()) {
                SnackbarUtil.showSnackbar(faqFragment.getView(), this.networkErrorMessage, -1);
                if (faqFragment.sectionsSize == 0) {
                    faqFragment.updateFaqLoadingUI(3);
                } else {
                    faqFragment.updateFaqLoadingUI(1);
                }
            }
        }
    }

    private static class Success
    extends Handler {
        private final WeakReference<FaqFragment> faqFragmentWeakReference;

        public Success(FaqFragment fragment) {
            this.faqFragmentWeakReference = new WeakReference<FaqFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            FaqFragment faqFragment = (FaqFragment)((Object)this.faqFragmentWeakReference.get());
            if (faqFragment != null) {
                ArrayList sections = (ArrayList)msg.obj;
                int status = msg.what;
                if (sections != null) {
                    sections = faqFragment.removeEmptySections(sections);
                    faqFragment.sectionsSize = sections.size();
                }
                if (status == GetSectionsCallBackStatus.DATABASE_SUCCESS) {
                    if (faqFragment.sectionsSize != 0) {
                        faqFragment.updateFaqLoadingUI(1);
                        faqFragment.updateFragment(faqFragment, sections);
                    }
                } else if (status == GetSectionsCallBackStatus.API_SUCCESS_NEW_DATA) {
                    if (faqFragment.sectionsSize == 0) {
                        faqFragment.updateFaqLoadingUI(2);
                    } else {
                        faqFragment.updateFaqLoadingUI(1);
                        faqFragment.updateFragment(faqFragment, sections);
                    }
                } else if (status == GetSectionsCallBackStatus.API_SUCCESS_NO_NEW_DATA && faqFragment.sectionsSize == 0) {
                    faqFragment.updateFaqLoadingUI(2);
                }
            }
        }
    }

    public static class FaqLoadingStatus {
        public static final int IN_PROGRESS = 0;
        public static final int HIDE = 1;
        public static final int NO_FAQS = 2;
        public static final int ERROR = 3;
    }
}

