/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.compositions;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.helpshift.R;
import com.helpshift.support.Section;
import com.helpshift.support.compositions.SectionPagerAdapter;
import com.helpshift.support.contracts.FaqFragmentListener;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.util.Styles;
import java.util.ArrayList;
import java.util.List;

public class SectionPagerFragment
extends MainFragment {
    private FaqFragmentListener faqFragmentListener;
    private TabLayout tabLayout;
    private FrameLayout viewPagerContainer;
    private int tabLayoutPadding = 0;

    public static SectionPagerFragment newInstance(Bundle bundle) {
        SectionPagerFragment sectionPagerFragment = new SectionPagerFragment();
        sectionPagerFragment.setArguments(bundle);
        return sectionPagerFragment;
    }

    public void setFaqFragmentListener(FaqFragmentListener faqFragmentListener) {
        this.faqFragmentListener = faqFragmentListener;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__section_pager_fragment, container, false);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.tabLayoutPadding = (int)Styles.dpToPx(context, 48.0f);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        ArrayList sections = this.getArguments().getParcelableArrayList("sections");
        ViewPager viewPager = (ViewPager)view.findViewById(R.id.section_pager);
        viewPager.setAdapter((PagerAdapter)new SectionPagerAdapter(this.getChildFragmentManager(), this.faqFragmentListener, sections));
        this.tabLayout = (TabLayout)view.findViewById(R.id.pager_tabs);
        this.tabLayout.getChildAt(0).setPadding(this.tabLayoutPadding, 0, this.tabLayoutPadding, 0);
        this.tabLayout.setupWithViewPager(viewPager);
        String sectionPublishId = this.getArguments().getString("sectionPublishId");
        viewPager.setCurrentItem(this.getSectionPosition(sections, sectionPublishId));
        this.viewPagerContainer = (FrameLayout)view.findViewById(R.id.view_pager_container);
    }

    private int getSectionPosition(List<Section> sections, String sectionPublishId) {
        for (int i = 0; i < sections.size(); ++i) {
            Section section = sections.get(i);
            if (!section.getPublishId().equals(sectionPublishId)) continue;
            return i;
        }
        return 0;
    }

    public void onResume() {
        super.onResume();
        this.showToolbarElevation(false);
        this.showTabLayoutElevation();
    }

    public void onStart() {
        super.onStart();
        this.addVisibleFragment();
    }

    @Override
    public void onStop() {
        super.onStop();
        this.removeVisibleFragment();
        this.showToolbarElevation(true);
    }

    private void showTabLayoutElevation() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.tabLayout.setElevation(Styles.dpToPx(this.getContext(), 4.0f));
        } else {
            this.viewPagerContainer.setForeground(this.getResources().getDrawable(R.drawable.hs__actionbar_compat_shadow));
        }
    }
}

