/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.controllers;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.MenuItem;
import com.helpshift.R;
import com.helpshift.support.Faq;
import com.helpshift.support.HSAddIssueFragment;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.HSMessagesFragment;
import com.helpshift.support.HSStorage;
import com.helpshift.support.activities.ParentActivity;
import com.helpshift.support.contracts.ConversationFlowView;
import com.helpshift.support.contracts.HSMessagesListener;
import com.helpshift.support.contracts.NewConversationListener;
import com.helpshift.support.contracts.ScreenshotPreviewListener;
import com.helpshift.support.contracts.SearchResultListener;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.fragments.ConversationFlowFragment;
import com.helpshift.support.fragments.ScreenshotPreviewFragment;
import com.helpshift.support.fragments.SearchResultFragment;
import com.helpshift.support.fragments.SingleQuestionFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.util.FragmentUtil;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class ConversationFlowController
implements MenuItem.OnMenuItemClickListener,
ScreenshotPreviewListener,
NewConversationListener,
SearchResultListener,
HSMessagesListener {
    private static final String TAG = ConversationFlowController.class.getSimpleName();
    private final ConversationFlowView conversationFlowView;
    private final FragmentManager fragmentManager;
    private final Bundle bundle;
    private final HSApiData data;
    private final HSStorage storage;
    private boolean isControllerStarted;
    private String pendingScreenshotPath;
    private int screenshotPreviewFragmentMode;
    private int pickImageMessagePosition;

    public ConversationFlowController(ConversationFlowView conversationFlowView, FragmentManager fragmentManager, Bundle bundle, HSApiData data) {
        this.conversationFlowView = conversationFlowView;
        this.fragmentManager = fragmentManager;
        this.bundle = bundle;
        this.data = data;
        this.storage = data.storage;
    }

    public void start() {
        if (!this.isControllerStarted) {
            this.showFragment();
        }
        this.isControllerStarted = true;
        if (!TextUtils.isEmpty((CharSequence)this.pendingScreenshotPath)) {
            this.startScreenshotPreviewFragment(this.pendingScreenshotPath, this.screenshotPreviewFragmentMode);
            this.setPendingScreenshotPath(null);
        }
    }

    private void showFragment() {
        String activeConversation = this.storage.getActiveConversation(this.data.getProfileId());
        String archivedConversation = this.storage.getArchivedConversation(this.data.getProfileId());
        if (!TextUtils.isEmpty((CharSequence)archivedConversation)) {
            this.bundle.putString("issueId", archivedConversation);
            this.showMessagesFragment();
        } else if (!TextUtils.isEmpty((CharSequence)activeConversation)) {
            this.bundle.putString("issueId", activeConversation);
            this.showMessagesFragment();
        } else {
            this.showHsAddIssueFragment();
        }
    }

    private void showMessagesFragment() {
        this.screenshotPreviewFragmentMode = 3;
        FragmentUtil.startFragmentWithoutBackStack(this.fragmentManager, R.id.conversation_fragment_container, (Fragment)HSMessagesFragment.newInstance(this.bundle), null, this, true);
    }

    private void showHsAddIssueFragment() {
        this.screenshotPreviewFragmentMode = 1;
        FragmentUtil.startFragmentWithoutBackStack(this.fragmentManager, R.id.conversation_fragment_container, (Fragment)HSAddIssueFragment.newInstance(this.bundle, this), null, this, true);
    }

    public void setPendingScreenshotPath(String screenshotPath) {
        this.pendingScreenshotPath = screenshotPath;
    }

    @Override
    public void startScreenshotPreviewFragment(String screenshotPath, int mode) {
        ScreenshotPreviewFragment screenshotPreviewFragment = FragmentUtil.getScreenshotPreviewFragment(this.fragmentManager);
        if (screenshotPreviewFragment == null) {
            screenshotPreviewFragment = ScreenshotPreviewFragment.newInstance(this.bundle, this, mode);
            FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.conversation_fragment_container, screenshotPreviewFragment, null, false);
        }
        screenshotPreviewFragment.setScreenshotPath(screenshotPath);
    }

    public boolean onMenuItemClick(MenuItem menuItem) {
        int menuItemId = menuItem.getItemId();
        if (menuItemId == R.id.hs__attach_screenshot) {
            this.pickImageMessagePosition = 0;
            this.conversationFlowView.pickImage();
            return true;
        }
        if (menuItemId == R.id.hs__start_new_conversation) {
            HSAddIssueFragment hsAddIssueFragment = FragmentUtil.getHsAddIssueFragment(this.fragmentManager);
            if (hsAddIssueFragment != null) {
                hsAddIssueFragment.checkAndStartNewConversation();
            }
        } else if (menuItemId == R.id.hs__action_done) {
            this.actionDone();
        }
        return false;
    }

    public void actionDone() {
        this.sendTicketAvoidedEvent();
        this.storage.storeConversationDetail("", this.data.getLoginId());
        this.storage.setConversationScreenshot("", this.data.getLoginId());
        SupportFragment supportFragment = this.conversationFlowView.getSupportFragment();
        SupportController supportController = supportFragment.getSupportController();
        int supportMode = supportController.getSupportMode();
        if (supportMode == 1) {
            this.exitSdkSession();
        } else {
            FragmentUtil.popBackStackImmediate(supportController.getFragmentManager(), ConversationFlowFragment.class.getSimpleName());
        }
    }

    private void sendTicketAvoidedEvent() {
        String questionId;
        SingleQuestionFragment singleQuestionFragment = FragmentUtil.getSingleQuestionFragment(this.fragmentManager);
        if (singleQuestionFragment != null && !TextUtils.isEmpty((CharSequence)(questionId = singleQuestionFragment.getQuestionId()))) {
            JSONObject eventData = new JSONObject();
            try {
                eventData.put("id", (Object)questionId);
                eventData.put("str", (Object)this.storage.getConversationDetail(this.data.getLoginId()));
                HSFunnel.pushEvent("ta", eventData);
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"sendTicketAvoidedEvent : ", (Throwable)e);
            }
        }
    }

    @Override
    public void add(String screenshotPath) {
        FragmentUtil.popBackStack(this.fragmentManager, ScreenshotPreviewFragment.class.getSimpleName());
        HSAddIssueFragment hsAddIssueFragment = FragmentUtil.getHsAddIssueFragment(this.fragmentManager);
        if (hsAddIssueFragment != null) {
            hsAddIssueFragment.setScreenshot(screenshotPath);
        }
    }

    @Override
    public void send(String screenshotPath) {
        FragmentUtil.popBackStackImmediate(this.fragmentManager, ScreenshotPreviewFragment.class.getSimpleName());
        HSMessagesFragment hsMessagesFragment = FragmentUtil.getHsMessagesFragment(this.fragmentManager);
        if (hsMessagesFragment != null) {
            hsMessagesFragment.sendScreenshot(screenshotPath, this.pickImageMessagePosition);
        }
    }

    @Override
    public void remove() {
        FragmentUtil.popBackStack(this.fragmentManager, ScreenshotPreviewFragment.class.getSimpleName());
        HSAddIssueFragment hsAddIssueFragment = FragmentUtil.getHsAddIssueFragment(this.fragmentManager);
        if (hsAddIssueFragment != null) {
            hsAddIssueFragment.clearScreenshot();
        }
    }

    @Override
    public void change() {
        this.conversationFlowView.pickImage();
    }

    @Override
    public void showSearchResultFragment(ArrayList<Faq> questions) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("results", questions);
        FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.conversation_fragment_container, SearchResultFragment.newInstance(bundle, this), null, false);
    }

    @Override
    public void showConversationOnReportIssue() {
        FragmentUtil.removeHsAddIssueFragmentImmediate(this.fragmentManager);
        this.showFragment();
    }

    @Override
    public void exitSdkSession() {
        SupportFragment supportFragment = this.conversationFlowView.getSupportFragment();
        if (supportFragment.getActivity() instanceof ParentActivity) {
            supportFragment.getActivity().finish();
        } else {
            FragmentUtil.removeFragment(supportFragment.getActivity().getSupportFragmentManager(), supportFragment);
        }
    }

    @Override
    public void clear() {
        this.refreshMenu();
    }

    @Override
    public void reportingIssue() {
        this.refreshMenu();
    }

    @Override
    public void onQuestionSelected(String questionPublishId, ArrayList<String> searchTerms) {
        Bundle bundle = new Bundle();
        bundle.putString("questionPublishId", questionPublishId);
        if (searchTerms != null) {
            bundle.putStringArrayList("searchTerms", searchTerms);
        }
        FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.conversation_fragment_container, SingleQuestionFragment.newInstance(bundle, 2), null, false);
    }

    @Override
    public void sendAnyway() {
        HSFunnel.pushEvent("taf");
        FragmentUtil.popBackStackImmediate(this.fragmentManager, SearchResultFragment.class.getSimpleName());
        HSAddIssueFragment hsAddIssueFragment = FragmentUtil.getHsAddIssueFragment(this.fragmentManager);
        if (hsAddIssueFragment != null) {
            hsAddIssueFragment.startNewConversation();
        }
    }

    @Override
    public void pickImage(int position) {
        this.pickImageMessagePosition = position;
        this.conversationFlowView.pickImage();
    }

    @Override
    public void startNewConversation() {
        this.showFragment();
    }

    @Override
    public void showResolutionRequest() {
        this.refreshMenu();
    }

    @Override
    public void rejectResolution() {
        this.refreshMenu();
    }

    @Override
    public void acceptResolution() {
        this.refreshMenu();
    }

    @Override
    public void reloadMenu() {
        this.refreshMenu();
    }

    public void refreshMenu() {
        this.conversationFlowView.getSupportFragment().refreshMenu();
    }
}

