/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.controllers;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.widget.SearchView;
import android.text.TextUtils;
import android.view.MenuItem;
import com.helpshift.R;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.Log;
import com.helpshift.support.compositions.FaqFragment;
import com.helpshift.support.compositions.SectionPagerFragment;
import com.helpshift.support.contracts.FaqFlowView;
import com.helpshift.support.contracts.FaqFragmentListener;
import com.helpshift.support.contracts.SearchListener;
import com.helpshift.support.fragments.QuestionListFragment;
import com.helpshift.support.fragments.SearchFragment;
import com.helpshift.support.fragments.SingleQuestionFragment;
import com.helpshift.support.util.ConversationsPoller;
import com.helpshift.support.util.FragmentUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class FaqFlowController
implements FaqFragmentListener,
MenuItemCompat.OnActionExpandListener,
SearchView.OnQueryTextListener {
    private static final String TAG = FaqFlowController.class.getSimpleName();
    private final FaqFlowView faqFlowView;
    private final FragmentManager fragmentManager;
    private final boolean isScreenLarge;
    private final Bundle bundle;
    private boolean isControllerStarted;
    private SearchListener searchListener;
    private boolean retainSearchFragmentState;
    private static final int POLLING_INTERVAL = 3;
    private final HSApiData data;
    private final ConversationsPoller conversationsPoller;
    private String currentQuery = "";
    private String lastQuery = "";

    public FaqFlowController(FaqFlowView faqFlowView, Context context, FragmentManager fragmentManager, Bundle bundle) {
        this.faqFlowView = faqFlowView;
        this.isScreenLarge = context.getResources().getBoolean(R.bool.is_screen_large);
        this.fragmentManager = fragmentManager;
        this.bundle = bundle;
        this.data = new HSApiData(context);
        ConversationPollerSuccessHandler pollerSuccessHandler = new ConversationPollerSuccessHandler(this);
        this.conversationsPoller = new ConversationsPoller(3, pollerSuccessHandler, new Handler(), this.data);
    }

    public void start() {
        if (!this.isControllerStarted) {
            int supportMode = this.bundle.getInt("support_mode", 0);
            switch (supportMode) {
                case 2: {
                    this.startQuestionListFragment();
                    break;
                }
                case 3: {
                    this.startSingleQuestionFragment();
                    break;
                }
                default: {
                    this.startFaqFragment();
                }
            }
        }
        this.isControllerStarted = true;
    }

    public void startPoller() {
        this.conversationsPoller.start();
    }

    public void stopPoller() {
        this.conversationsPoller.stop();
    }

    public void quitPoller() {
        this.conversationsPoller.quit();
    }

    private void startFaqFragment() {
        FaqFragment faqFragment = FaqFragment.newInstance(this.bundle, this);
        FragmentUtil.startFragmentWithoutBackStack(this.fragmentManager, R.id.list_fragment_container, (Fragment)faqFragment, null, this, true);
    }

    private void startQuestionListFragment() {
        QuestionListFragment questionListFragment = QuestionListFragment.newInstance(this.bundle, this);
        FragmentUtil.startFragmentWithoutBackStack(this.fragmentManager, R.id.list_fragment_container, (Fragment)questionListFragment, null, this, false);
    }

    private void startSingleQuestionFragment() {
        this.faqFlowView.getSupportFragment().getSupportController().setSearchPerformed(true);
        SingleQuestionFragment singleQuestionFragment = SingleQuestionFragment.newInstance(this.bundle, 1);
        int singleQuestionContainer = R.id.list_fragment_container;
        if (this.isScreenLarge) {
            singleQuestionContainer = R.id.single_question_container;
        }
        FragmentUtil.startFragmentWithoutBackStack(this.fragmentManager, singleQuestionContainer, (Fragment)singleQuestionFragment, null, this, false);
    }

    public void setRetainSearchFragmentState(boolean retainSearchFragmentState) {
        this.retainSearchFragmentState = retainSearchFragmentState;
    }

    @Override
    public void onSectionSelected(Bundle bundle) {
        if (this.isScreenLarge) {
            QuestionListFragment questionListFragment = QuestionListFragment.newInstance(bundle, this);
            FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.list_fragment_container, questionListFragment, null, false);
        } else {
            SectionPagerFragment sectionPagerFragment = SectionPagerFragment.newInstance(bundle);
            sectionPagerFragment.setFaqFragmentListener(this);
            FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.list_fragment_container, sectionPagerFragment, null, false);
        }
    }

    @Override
    public void onQuestionSelected(String questionPublishId, ArrayList<String> searchTerms) {
        this.performedSearch();
        this.faqFlowView.getSupportFragment().getSupportController().setSearchPerformed(true);
        Bundle bundle = new Bundle();
        bundle.putString("questionPublishId", questionPublishId);
        bundle.putStringArrayList("searchTerms", searchTerms);
        if (this.isScreenLarge) {
            int singleQuestionFragmentResourceId = R.id.details_fragment_container;
            FragmentUtil.startFragmentWithoutBackStack(this.fragmentManager, singleQuestionFragmentResourceId, (Fragment)SingleQuestionFragment.newInstance(bundle, 1), null, this, false);
        } else {
            int singleQuestionFragmentResourceId = R.id.list_fragment_container;
            FragmentUtil.startFragmentWithBackStack(this.fragmentManager, singleQuestionFragmentResourceId, SingleQuestionFragment.newInstance(bundle, 1), null, false);
        }
    }

    public boolean onMenuItemActionExpand(MenuItem item) {
        if (this.searchListener == null) {
            SearchFragment searchFragment = SearchFragment.newInstance(this.bundle);
            searchFragment.setFaqFragmentListener(this);
            this.searchListener = searchFragment;
            FragmentUtil.startFragmentWithBackStack(this.fragmentManager, R.id.list_fragment_container, searchFragment, SearchFragment.TAG, false);
        }
        return true;
    }

    public boolean onMenuItemActionCollapse(MenuItem item) {
        this.performedSearch();
        if (!this.retainSearchFragmentState) {
            this.lastQuery = "";
            this.currentQuery = "";
            this.searchListener = null;
            FragmentUtil.popBackStack(this.fragmentManager, SearchFragment.class.getSimpleName());
        }
        return true;
    }

    public boolean onQueryTextSubmit(String query) {
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        if (TextUtils.isEmpty((CharSequence)newText) && this.currentQuery.length() > 2) {
            this.performedSearch();
        }
        this.currentQuery = newText;
        return this.onQuery(newText);
    }

    private boolean onQuery(String query) {
        if (!this.retainSearchFragmentState && this.searchListener != null) {
            this.searchListener.onQuery(query, this.bundle.getString("sectionPublishId"));
            return true;
        }
        return false;
    }

    public void performedSearch() {
        if (!TextUtils.isEmpty((CharSequence)this.currentQuery.trim()) && !this.lastQuery.equals(this.currentQuery)) {
            this.faqFlowView.getSupportFragment().getSupportController().setSearchPerformed(true);
            this.bundle.putBoolean("search_performed", true);
            JSONObject eventObj = new JSONObject();
            try {
                eventObj.put("s", (Object)this.currentQuery);
            }
            catch (JSONException e) {
                Log.d(TAG, "performedSearch", e);
            }
            HSFunnel.pushEvent("s", eventObj);
        }
        this.lastQuery = this.currentQuery;
    }

    private static class ConversationPollerSuccessHandler
    extends Handler {
        private final WeakReference<FaqFlowController> faqFlowControllerWeakReference;

        public ConversationPollerSuccessHandler(FaqFlowController faqFlowController) {
            this.faqFlowControllerWeakReference = new WeakReference<FaqFlowController>(faqFlowController);
        }

        public void handleMessage(Message msg) {
            String profileId;
            HSApiData data;
            int count;
            FaqFlowController faqFlowController = (FaqFlowController)this.faqFlowControllerWeakReference.get();
            if (faqFlowController != null && (count = data.storage.getActiveNotifCnt(profileId = (data = faqFlowController.data).getProfileId()).intValue()) > 0) {
                faqFlowController.faqFlowView.getSupportFragment().setNewMessagesCount(count);
            }
        }
    }
}

