/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.controllers;

import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.view.MenuItem;
import com.helpshift.R;
import com.helpshift.support.activities.ParentActivity;
import com.helpshift.support.controllers.FaqFlowController;
import com.helpshift.support.flows.Flow;
import com.helpshift.support.fragments.ConversationFlowFragment;
import com.helpshift.support.fragments.DynamicFormFragment;
import com.helpshift.support.fragments.FaqFlowFragment;
import com.helpshift.support.util.FragmentUtil;
import java.util.List;

public class SupportController
implements MenuItem.OnMenuItemClickListener {
    private final FragmentManager fragmentManager;
    private final Bundle bundle;
    private boolean isControllerStarted;
    private int supportMode;
    private boolean searchPerformed = false;

    public SupportController(FragmentManager fragmentManager, Bundle bundle) {
        this.fragmentManager = fragmentManager;
        this.bundle = bundle;
    }

    public void setSearchPerformed(boolean searchPerformed) {
        this.searchPerformed = searchPerformed;
    }

    public void start() {
        if (!this.isControllerStarted) {
            this.supportMode = this.bundle.getInt("support_mode", 0);
            switch (this.supportMode) {
                case 1: {
                    this.startConversationFlow(this.bundle, false);
                    break;
                }
                case 4: {
                    this.startDynamicForm(ParentActivity.FlowListHolder.getFlowList(), false);
                    break;
                }
                default: {
                    this.startFaqFlow(this.bundle, false);
                }
            }
        }
        this.isControllerStarted = true;
    }

    public void startFaqFlow(Bundle bundle, boolean addToBackStack) {
        FaqFlowFragment faqFlowFragment = FaqFlowFragment.newInstance(bundle);
        String backStackName = null;
        if (addToBackStack) {
            backStackName = FaqFlowFragment.class.getSimpleName();
        }
        FragmentUtil.startFragment(this.fragmentManager, R.id.flow_fragment_container, faqFlowFragment, null, backStackName, false);
    }

    public void startConversationFlow(Bundle bundle, boolean addToBackStack) {
        bundle.putBoolean("search_performed", this.searchPerformed);
        ConversationFlowFragment conversationFlowFragment = ConversationFlowFragment.newInstance(bundle);
        String backStackName = null;
        if (addToBackStack) {
            backStackName = ConversationFlowFragment.class.getSimpleName();
        }
        FragmentUtil.startFragment(this.fragmentManager, R.id.flow_fragment_container, conversationFlowFragment, null, backStackName, false);
    }

    public void startDynamicForm(List<Flow> flowList, boolean addToBackStack) {
        DynamicFormFragment dynamicFormFragment = DynamicFormFragment.newInstance(this.bundle, flowList, this);
        String backStackName = null;
        if (addToBackStack) {
            backStackName = ConversationFlowFragment.class.getSimpleName();
        }
        FragmentUtil.startFragment(this.fragmentManager, R.id.flow_fragment_container, dynamicFormFragment, null, backStackName, false);
    }

    public int getSupportMode() {
        return this.supportMode;
    }

    public FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    public boolean onMenuItemClick(MenuItem menuItem) {
        int menuItemId = menuItem.getItemId();
        if (menuItemId == R.id.hs__contact_us) {
            this.onContactUsClicked(null);
            return true;
        }
        return false;
    }

    public void onContactUsClicked(String query) {
        FaqFlowController faqFlowController = this.getFaqFlowController();
        if (faqFlowController != null) {
            faqFlowController.performedSearch();
        }
        if (!TextUtils.isEmpty((CharSequence)query)) {
            this.bundle.putString("message", query);
        }
        this.bundle.putString("chatLaunchSource", "support");
        this.startConversationFlow(this.bundle, true);
    }

    private FaqFlowController getFaqFlowController() {
        FaqFlowFragment faqFlowFragment = FragmentUtil.getFaqFlowFragment(this.fragmentManager);
        if (faqFlowFragment != null) {
            return faqFlowFragment.getFaqFlowController();
        }
        return null;
    }
}

