/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.customadapters;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.text.Html;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.support.D;
import com.helpshift.support.HSMessagesFragment;
import com.helpshift.support.util.AttachmentUtil;
import com.helpshift.support.util.Styles;
import com.helpshift.support.viewstructs.HSMsg;
import java.io.File;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public final class MessagesAdapter
extends ArrayAdapter {
    private static final int TYPE_TXT_ADMIN = 1;
    private static final int TYPE_TXT_MOBILE = 2;
    private static final int TYPE_CB = 5;
    private static final int TYPE_CA_MOBILE = 6;
    private static final int TYPE_CR_MOBILE = 7;
    private static final int TYPE_SC_MOBILE = 8;
    private static final int TYPE_RAR = 11;
    private static final int TYPE_AR_MOBILE = 12;
    private static final int TYPE_RSC = 13;
    private static final int TYPE_LOCAL_RSC = 14;
    private static final int TYPE_IMAGE_ATTACHMENT_ADMIN = 15;
    private static final int TYPE_GENERIC_ATTACHMENT_ADMIN = 16;
    private final LayoutInflater inflater;
    private final double imageAttachmentLandMaxWidth;
    private final double imageAttachmentPortMaxHeight;
    private HSMessagesFragment f;
    private Context c;
    private List<HSMsg> items;
    private boolean enableBtn;

    public MessagesAdapter(Fragment f, int textViewResourceId, List<HSMsg> objects) {
        super(f.getContext(), textViewResourceId, objects);
        this.f = (HSMessagesFragment)f;
        this.c = f.getContext();
        this.items = objects;
        this.inflater = (LayoutInflater)this.c.getSystemService("layout_inflater");
        DisplayMetrics metrics = new DisplayMetrics();
        this.f.getActivity(this.f).getWindowManager().getDefaultDisplay().getMetrics(metrics);
        this.imageAttachmentLandMaxWidth = (double)metrics.widthPixels * 0.8;
        this.imageAttachmentPortMaxHeight = (double)metrics.heightPixels * 0.4;
    }

    public void enableButtons(boolean enable) {
        this.enableBtn = enable;
    }

    public boolean isEnabled(int position) {
        return false;
    }

    public int getViewTypeCount() {
        return 20;
    }

    public int getItemViewType(int position) {
        HSMsg item = this.items.get(position);
        if (item.type.equals("txt") && (item.state == -1 || item.state == 1) || item.type.equals("txt") && item.state <= -2 || item.type.equals("txt") && item.origin.equals("mobile")) {
            return 2;
        }
        if (item.origin.equals("admin") && (item.type.equals("txt") || item.type.equals("rfr"))) {
            return 1;
        }
        if (item.type.equals("cb") && item.origin.equals("admin")) {
            return 5;
        }
        if (item.type.equals("rsc") && item.origin.equals("admin")) {
            if (item.id.startsWith("localRscMessage_")) {
                return 14;
            }
            return 13;
        }
        if (item.type.equals("ca") && item.origin.equals("mobile")) {
            return 6;
        }
        if (item.type.equals("ncr") && item.origin.equals("mobile")) {
            return 7;
        }
        if (item.type.equals("sc") && item.origin.equals("mobile")) {
            return 8;
        }
        if (item.type.equals("rar") && item.origin.equals("admin")) {
            return 11;
        }
        if (item.type.equals("ar") && item.origin.equals("mobile")) {
            return 12;
        }
        if (item.type.equals("admin_attachment_image")) {
            return 15;
        }
        if (item.type.equals("admin_attachment_generic")) {
            return 16;
        }
        if (item.type.equals("admin_attachment_image")) {
            return 15;
        }
        return 0;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        HSMsg item = this.items.get(position);
        if (item != null) {
            switch (this.getItemViewType(position)) {
                case 1: {
                    return this.setConvertView(convertView, item, new TxtAdminHolder());
                }
                case 2: {
                    return this.setConvertView(convertView, item, new TxtUserHolder());
                }
                case 5: {
                    return this.setConvertView(convertView, item, position, new CBViewHolder());
                }
                case 6: {
                    return this.setConvertView(convertView, item, true, new CSViewHolder());
                }
                case 7: {
                    return this.setConvertView(convertView, item, false, new CSViewHolder());
                }
                case 13: {
                    return this.setConvertView(convertView, item, position, new RSCViewHolder());
                }
                case 14: {
                    return this.setConvertView(convertView, item, position, new LocalRSCViewHolder());
                }
                case 8: {
                    return this.setConvertView(convertView, item, new SCViewHolder());
                }
                case 11: {
                    return this.setConvertView(convertView, item, position, new RARViewHolder());
                }
                case 12: {
                    return this.setConvertView(convertView, item, new ARViewHolder());
                }
                case 16: {
                    return this.setConvertView(convertView, item, position, new AdminAttachmentGenericViewHolder());
                }
                case 15: {
                    return this.setConvertView(convertView, item, position, new AdminAttachmentImageViewHolder());
                }
            }
        }
        return null;
    }

    private View setConvertView(View convertView, HSMsg item, TxtAdminHolder holder) {
        if (convertView == null) {
            convertView = this.inflater.inflate(D.layout.hs__msg_txt_admin, null);
            Styles.setAdminChatBubbleColor(this.c, convertView.findViewById(D.id.admin_message).getBackground());
            holder.text1 = (TextView)convertView.findViewById(16908308);
            holder.text1.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this.f);
            holder.text2 = (TextView)convertView.findViewById(16908309);
            convertView.setTag((Object)holder);
        } else {
            holder = (TxtAdminHolder)convertView.getTag();
        }
        holder.text1.setText((CharSequence)this.getText(item.body));
        holder.text2.setText((CharSequence)item.date);
        return convertView;
    }

    private View setConvertView(View convertView, final HSMsg item, TxtUserHolder holder) {
        if (convertView == null) {
            convertView = this.inflater.inflate(D.layout.hs__msg_txt_user, null);
            Styles.setUserChatBubbleColor(this.c, convertView.findViewById(D.id.user_message).getBackground());
            holder.text1 = (TextView)convertView.findViewById(16908308);
            holder.text1.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this.f);
            holder.text2 = (TextView)convertView.findViewById(16908309);
            convertView.setTag((Object)holder);
        } else {
            holder = (TxtUserHolder)convertView.getTag();
        }
        if (item.type.equals("txt") && (item.state == -1 || item.state == 1)) {
            holder.text1.setText((CharSequence)this.getText(item.body));
            holder.text2.setText(D.string.hs__sending_msg);
        } else if (item.type.equals("txt") && item.state <= -2) {
            holder.text1.setText((CharSequence)this.getText(item.body));
            holder.text1.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MessagesAdapter.this.f.retryMessage(item.id);
                }
            });
            holder.text2.setText(D.string.hs__sending_fail_msg);
        } else {
            holder.text1.setText((CharSequence)this.getText(item.body));
            holder.text2.setText((CharSequence)item.date);
        }
        return convertView;
    }

    private View setConvertView(View convertView, final HSMsg item, final int position, CBViewHolder holder) {
        if (convertView == null) {
            convertView = this.inflater.inflate(D.layout.hs__msg_confirmation_box, null);
            Styles.setAdminChatBubbleColor(this.c, convertView.findViewById(D.id.admin_message).getBackground());
            holder.text1 = (TextView)convertView.findViewById(16908308);
            holder.progress = (ProgressBar)convertView.findViewById(16908301);
            holder.btnContainer = (LinearLayout)convertView.findViewById(16908312);
            holder.button1 = (ImageButton)convertView.findViewById(16908313);
            holder.button2 = (ImageButton)convertView.findViewById(16908314);
            Styles.setAcceptButtonIconColor(this.c, holder.button1.getDrawable());
            Styles.setRejectButtonIconColor(this.c, holder.button2.getDrawable());
            convertView.setTag((Object)holder);
        } else {
            holder = (CBViewHolder)convertView.getTag();
        }
        holder.text1.setText((CharSequence)this.getText(item.body));
        if (item.inProgress.booleanValue()) {
            holder.progress.setVisibility(0);
            holder.btnContainer.setVisibility(8);
        } else if (!item.invisible.booleanValue()) {
            holder.btnContainer.setVisibility(0);
            holder.progress.setVisibility(8);
            holder.button1.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (item.clickable.booleanValue()) {
                        MessagesAdapter.this.f.replyConfirmation(item.id, true, position);
                    }
                }
            });
            holder.button2.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (item.clickable.booleanValue()) {
                        MessagesAdapter.this.f.replyConfirmation(item.id, false, position);
                    }
                }
            });
            holder.button1.setEnabled(this.enableBtn);
            holder.button2.setEnabled(this.enableBtn);
        } else {
            holder.progress.setVisibility(8);
            holder.btnContainer.setVisibility(8);
        }
        return convertView;
    }

    private View setConvertView(View convertView, HSMsg item, boolean accepted, CSViewHolder holder) {
        if (convertView == null) {
            convertView = this.inflater.inflate(D.layout.hs__msg_confirmation_status, null);
            Styles.setAdminChatBubbleColor(this.c, convertView.findViewById(D.id.admin_message).getBackground());
            holder.text1 = (TextView)convertView.findViewById(16908308);
            holder.text2 = (TextView)convertView.findViewById(16908309);
            convertView.setTag((Object)holder);
        } else {
            holder = (CSViewHolder)convertView.getTag();
        }
        if (accepted) {
            holder.text1.setText(D.string.hs__ca_msg);
        } else {
            holder.text1.setText(D.string.hs__cr_msg);
        }
        holder.text2.setText((CharSequence)item.date);
        return convertView;
    }

    private View setConvertView(View convertView, final HSMsg item, final int position, RSCViewHolder holder) {
        if (convertView == null) {
            convertView = this.inflater.inflate(D.layout.hs__msg_request_screenshot, null);
            Styles.setAdminChatBubbleColor(this.c, convertView.findViewById(D.id.admin_message).getBackground());
            Styles.setUserChatBubbleColor(this.c, convertView.findViewById(D.id.user_message).getBackground());
            holder.text1 = (TextView)convertView.findViewById(16908308);
            holder.attachBtn = (Button)convertView.findViewById(16908313);
            holder.progress = (ProgressBar)convertView.findViewById(16908301);
            holder.imagePreview = (LinearLayout)convertView.findViewById(16908291);
            holder.image = (ImageView)convertView.findViewById(0x1020010);
            holder.doneBtn = convertView.findViewById(R.id.user_message);
            holder.adminMessage = (LinearLayout)convertView.findViewById(D.id.admin_message);
            holder.errorText = (TextView)convertView.findViewById(R.id.errorText);
            holder.textRetry = (TextView)convertView.findViewById(R.id.text_retry);
            convertView.setTag((Object)holder);
        } else {
            holder = (RSCViewHolder)convertView.getTag();
        }
        holder.text1.setText((CharSequence)this.getText(item.body));
        holder.image.setVisibility(0);
        if (item.inProgress.booleanValue()) {
            holder.adminMessage.setVisibility(0);
            holder.attachBtn.setVisibility(8);
            holder.imagePreview.setVisibility(0);
            Bitmap screenshotImage = AttachmentUtil.getBitmap(item.screenshot, 250);
            this.setImageAttachmentDimensions(screenshotImage, holder.image);
            holder.image.setImageBitmap(screenshotImage);
            holder.progress.setVisibility(0);
            holder.doneBtn.setVisibility(0);
            holder.textRetry.setVisibility(8);
            holder.errorText.setVisibility(8);
        } else if (item.screenshot != null && !TextUtils.isEmpty((CharSequence)item.screenshot)) {
            holder.adminMessage.setVisibility(0);
            holder.attachBtn.setVisibility(8);
            holder.imagePreview.setVisibility(0);
            Bitmap screenshotImage = AttachmentUtil.getBitmap(item.screenshot, 250);
            holder.progress.setVisibility(8);
            holder.errorText.setVisibility(8);
            holder.textRetry.setVisibility(8);
            if (screenshotImage == null) {
                holder.image.setVisibility(8);
                holder.errorText.setVisibility(0);
            } else {
                this.setImageAttachmentDimensions(screenshotImage, holder.image);
                holder.image.setImageBitmap(screenshotImage);
                holder.doneBtn.setVisibility(0);
                if (Build.VERSION.SDK_INT >= 11) {
                    holder.image.setAlpha(0.5f);
                }
                holder.textRetry.setVisibility(0);
                if (holder.errorText.getVisibility() != 0) {
                    holder.doneBtn.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (item.clickable.booleanValue()) {
                                MessagesAdapter.this.f.attachImage(position);
                            }
                        }
                    });
                }
            }
        } else if (!item.invisible.booleanValue()) {
            holder.adminMessage.setVisibility(0);
            holder.attachBtn.setVisibility(0);
            holder.attachBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (item.clickable.booleanValue()) {
                        MessagesAdapter.this.f.selectImagePopup(position);
                    }
                }
            });
            holder.imagePreview.setVisibility(8);
            holder.image.setImageBitmap(null);
            holder.progress.setVisibility(8);
            holder.errorText.setVisibility(8);
            holder.textRetry.setVisibility(8);
        } else {
            holder.adminMessage.setVisibility(0);
            holder.attachBtn.setVisibility(8);
            holder.imagePreview.setVisibility(8);
            holder.image.setImageBitmap(null);
            holder.progress.setVisibility(8);
            holder.errorText.setVisibility(8);
            holder.textRetry.setVisibility(8);
        }
        holder.doneBtn.setEnabled(this.enableBtn);
        holder.attachBtn.setEnabled(this.enableBtn);
        return convertView;
    }

    private View setConvertView(View convertView, final HSMsg item, final int position, LocalRSCViewHolder holder) {
        if (convertView == null) {
            convertView = this.inflater.inflate(D.layout.hs__local_msg_request_screenshot, null);
            Styles.setUserChatBubbleColor(this.c, convertView.findViewById(D.id.user_message).getBackground());
            holder.imagePreview = (LinearLayout)convertView.findViewById(16908299);
            holder.progress = (ProgressBar)convertView.findViewById(16908301);
            holder.image = (ImageView)convertView.findViewById(0x1020010);
            holder.doneBtn = convertView.findViewById(R.id.user_message);
            holder.errorText = (TextView)convertView.findViewById(R.id.errorText);
            holder.textRetry = (TextView)convertView.findViewById(R.id.text_retry);
            convertView.setTag((Object)holder);
        } else {
            holder = (LocalRSCViewHolder)convertView.getTag();
        }
        Bitmap screenshotImage = AttachmentUtil.getBitmap(item.screenshot, 250);
        if (item.inProgress.booleanValue()) {
            this.setImageAttachmentDimensions(screenshotImage, holder.image);
            holder.image.setImageBitmap(screenshotImage);
            holder.image.setVisibility(0);
            holder.imagePreview.setVisibility(0);
            holder.progress.setVisibility(0);
            holder.errorText.setVisibility(8);
            holder.textRetry.setVisibility(8);
        } else if (!TextUtils.isEmpty((CharSequence)item.screenshot)) {
            holder.imagePreview.setVisibility(0);
            if (screenshotImage == null) {
                holder.image.setVisibility(8);
                holder.errorText.setVisibility(0);
                holder.progress.setVisibility(8);
                holder.textRetry.setVisibility(8);
            } else {
                this.setImageAttachmentDimensions(screenshotImage, holder.image);
                holder.image.setImageBitmap(screenshotImage);
                holder.image.setVisibility(0);
                if (Build.VERSION.SDK_INT >= 11) {
                    holder.image.setAlpha(0.5f);
                }
                holder.errorText.setVisibility(8);
                holder.progress.setVisibility(8);
                holder.doneBtn.setVisibility(0);
                holder.doneBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (item.clickable.booleanValue()) {
                            MessagesAdapter.this.f.attachImage(position);
                        }
                    }
                });
                holder.textRetry.setVisibility(0);
            }
        } else if (item.invisible.booleanValue()) {
            holder.imagePreview.setVisibility(8);
            holder.textRetry.setVisibility(8);
        }
        holder.doneBtn.setEnabled(this.enableBtn);
        return convertView;
    }

    private View setConvertView(View convertView, HSMsg item, SCViewHolder holder) {
        if (convertView == null) {
            convertView = this.inflater.inflate(D.layout.hs__msg_screenshot_status, null);
            Styles.setUserChatBubbleColor(this.c, convertView.findViewById(D.id.user_message).getBackground());
            holder.progress = (ProgressBar)convertView.findViewById(16908301);
            holder.image = (ImageView)convertView.findViewById(0x1020010);
            convertView.setTag((Object)holder);
        } else {
            holder = (SCViewHolder)convertView.getTag();
        }
        if (TextUtils.isEmpty((CharSequence)item.screenshot)) {
            holder.progress.setVisibility(0);
            holder.image.setVisibility(8);
            holder.image.setImageBitmap(null);
        } else {
            Bitmap screenshotImage = AttachmentUtil.getBitmap(item.screenshot, -1);
            this.setImageAttachmentDimensions(screenshotImage, holder.image);
            holder.progress.setVisibility(8);
            holder.image.setVisibility(0);
            holder.image.setImageBitmap(screenshotImage);
        }
        return convertView;
    }

    @TargetApi(value=11)
    private void setImageAttachmentDimensions(Bitmap image, ImageView imageView) {
        if (image == null) {
            return;
        }
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        imageView.setScaleType(ImageView.ScaleType.MATRIX);
        Matrix matrix = new Matrix();
        matrix.set(imageView.getMatrix());
        if (imageWidth >= imageHeight) {
            float scale = (float)(this.imageAttachmentLandMaxWidth / (double)imageWidth);
            ViewGroup.LayoutParams layoutParams = imageView.getLayoutParams();
            layoutParams.width = (int)this.imageAttachmentLandMaxWidth;
            layoutParams.height = (int)((float)imageHeight * scale);
            matrix.preScale(scale, scale);
            imageView.setImageMatrix(matrix);
            imageView.setLayoutParams(layoutParams);
        } else {
            float scale = (float)(this.imageAttachmentPortMaxHeight / (double)imageHeight);
            ViewGroup.LayoutParams layoutParams = imageView.getLayoutParams();
            layoutParams.width = (int)((float)imageWidth * scale);
            layoutParams.height = (int)this.imageAttachmentPortMaxHeight;
            matrix.preScale(scale, scale);
            imageView.setImageMatrix(matrix);
            imageView.setLayoutParams(layoutParams);
        }
    }

    private View setConvertView(View convertView, final HSMsg item, final int position, RARViewHolder holder) {
        if (convertView == null) {
            convertView = this.inflater.inflate(D.layout.hs__msg_review_request, null);
            Styles.setAdminChatBubbleColor(this.c, convertView.findViewById(D.id.admin_message).getBackground());
            holder.message = (TextView)convertView.findViewById(16908308);
            holder.progress = (ProgressBar)convertView.findViewById(16908301);
            holder.reviewBtn = (Button)convertView.findViewById(16908313);
            holder.date = (TextView)convertView.findViewById(16908309);
            convertView.setTag((Object)holder);
        } else {
            holder = (RARViewHolder)convertView.getTag();
        }
        holder.message.setText(D.string.hs__review_request_message);
        holder.date.setText((CharSequence)item.date);
        if (item.inProgress.booleanValue()) {
            holder.progress.setVisibility(0);
            holder.reviewBtn.setVisibility(8);
        } else if (!item.invisible.booleanValue()) {
            holder.progress.setVisibility(8);
            holder.reviewBtn.setVisibility(0);
            holder.reviewBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (item.clickable.booleanValue()) {
                        MessagesAdapter.this.f.replyReview(item.id, position);
                    }
                }
            });
        } else {
            holder.progress.setVisibility(8);
            holder.reviewBtn.setVisibility(8);
        }
        return convertView;
    }

    private View setConvertView(View convertView, HSMsg item, ARViewHolder holder) {
        if (convertView == null) {
            convertView = this.inflater.inflate(D.layout.hs__msg_review_accepted, null);
            Styles.setUserChatBubbleColor(convertView.getContext(), convertView.findViewById(D.id.user_message).getBackground());
            holder.text1 = (TextView)convertView.findViewById(16908308);
            holder.date = (TextView)convertView.findViewById(16908309);
            convertView.setTag((Object)holder);
        } else {
            holder = (ARViewHolder)convertView.getTag();
        }
        holder.text1.setText(D.string.hs__review_accepted_message);
        holder.date.setText((CharSequence)item.date);
        return convertView;
    }

    private View setConvertView(View convertView, final HSMsg item, final int position, AdminAttachmentGenericViewHolder holder) {
        if (convertView == null) {
            convertView = this.inflater.inflate(D.layout.hs__msg_attachment_generic, null);
            Styles.setAdminChatBubbleColor(this.c, convertView.findViewById(D.id.admin_message).getBackground());
            holder.fileName = (TextView)convertView.findViewById(R.id.attachment_file_name);
            holder.fileType = (TextView)convertView.findViewById(R.id.attachment_file_type);
            holder.fileSize = (TextView)convertView.findViewById(R.id.attachment_file_size);
            holder.downloadButton = convertView.findViewById(R.id.admin_message);
            holder.progress = (ProgressBar)convertView.findViewById(16908301);
            holder.downloadIcon = (ImageView)convertView.findViewById(R.id.download_icon);
            holder.attachmentIcon = (ImageView)convertView.findViewById(R.id.attachment_icon);
            Styles.setAccentColor(this.c, holder.downloadIcon.getDrawable());
            Styles.setAccentColor(this.c, holder.attachmentIcon.getDrawable());
            holder.date = (TextView)convertView.findViewById(16908309);
            convertView.setTag((Object)holder);
        } else {
            holder = (AdminAttachmentGenericViewHolder)convertView.getTag();
        }
        holder.date.setText((CharSequence)item.date);
        try {
            final JSONObject attachmentObj = new JSONObject(item.body);
            String fileName = attachmentObj.getString("file-name");
            String contentType = attachmentObj.getString("content-type");
            String fileType = AttachmentUtil.getFileType(this.f.getContext(), contentType, fileName);
            int size = attachmentObj.getInt("size");
            String fileSize = size < 1024 ? size + " B" : (size < 0x100000 ? size / 1024 + " KB" : String.format("%.1f", Float.valueOf((float)size / 1048576.0f)) + " MB");
            holder.fileName.setText((CharSequence)fileName);
            holder.fileType.setText((CharSequence)fileType);
            holder.fileSize.setText((CharSequence)fileSize);
            holder.downloadIcon.setVisibility(8);
            holder.attachmentIcon.setVisibility(8);
            holder.progress.setVisibility(8);
            holder.progress.setIndeterminate(true);
            switch (item.state) {
                case 0: {
                    holder.downloadIcon.setVisibility(0);
                    break;
                }
                case 1: {
                    holder.downloadIcon.setVisibility(0);
                    holder.progress.setVisibility(0);
                    break;
                }
                case 2: {
                    holder.downloadIcon.setVisibility(0);
                    holder.progress.setVisibility(0);
                    holder.progress.setIndeterminate(false);
                    break;
                }
                case 3: {
                    holder.attachmentIcon.setVisibility(0);
                }
            }
            holder.downloadButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (item.state == 3) {
                        MessagesAdapter.this.f.launchAttachment(item);
                    } else if (item.state == 0) {
                        MessagesAdapter.this.f.downloadAdminAttachment(attachmentObj, position, 6);
                    }
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return convertView;
    }

    private View setConvertView(View convertView, final HSMsg item, final int position, AdminAttachmentImageViewHolder holder) {
        if (convertView == null) {
            convertView = this.inflater.inflate(D.layout.hs__msg_attachment_image, null);
            Styles.setAdminChatBubbleColor(this.c, convertView.findViewById(D.id.admin_message).getBackground());
            holder.image = (ImageView)convertView.findViewById(0x1020010);
            holder.progress = (ProgressBar)convertView.findViewById(16908301);
            holder.downloadBtn = convertView.findViewById(R.id.admin_message);
            holder.errorText = (TextView)convertView.findViewById(R.id.errorText);
            holder.downloadIcon = (ImageView)convertView.findViewById(R.id.download_icon);
            holder.imageIcon = (ImageView)convertView.findViewById(R.id.image_icon);
            Styles.setAccentColor(this.c, holder.downloadIcon.getDrawable());
            Styles.setAccentColor(this.c, holder.imageIcon.getDrawable());
            holder.fileName = (TextView)convertView.findViewById(R.id.attachment_file_name);
            holder.fileType = (TextView)convertView.findViewById(R.id.attachment_file_type);
            holder.fileSize = (TextView)convertView.findViewById(R.id.attachment_file_size);
            holder.date = (TextView)convertView.findViewById(16908309);
            convertView.setTag((Object)holder);
        } else {
            holder = (AdminAttachmentImageViewHolder)convertView.getTag();
        }
        holder.date.setText((CharSequence)item.date);
        try {
            final JSONObject attachmentObj = new JSONObject(item.body);
            String fileName = attachmentObj.getString("file-name");
            String contentType = attachmentObj.getString("content-type");
            String fileType = AttachmentUtil.getFileType((Context)this.f.getActivity(), contentType, fileName);
            int size = attachmentObj.getInt("size");
            String fileSize = size < 1024 ? size + " B" : (size < 0x100000 ? size / 1024 + " KB" : String.format("%.1f", Float.valueOf((float)size / 1048576.0f)) + " MB");
            holder.fileName.setText((CharSequence)fileName);
            holder.fileType.setText((CharSequence)fileType);
            holder.fileSize.setText((CharSequence)fileSize);
            File imageFile = new File(item.screenshot);
            holder.downloadIcon.setVisibility(8);
            holder.imageIcon.setVisibility(8);
            if (Build.VERSION.SDK_INT >= 11) {
                holder.image.setAlpha(1.0f);
            }
            holder.errorText.setVisibility(8);
            switch (item.state) {
                case 0: {
                    holder.downloadIcon.setVisibility(0);
                    holder.image.setVisibility(8);
                    holder.progress.setVisibility(0);
                    this.f.downloadAdminAttachment(attachmentObj, position, 8);
                    break;
                }
                case 1: {
                    holder.downloadIcon.setVisibility(0);
                    holder.progress.setVisibility(8);
                    if (!imageFile.exists()) break;
                    Bitmap thumbnail = AttachmentUtil.getBitmap(item.screenshot, 250);
                    holder.image.setImageBitmap(thumbnail);
                    holder.image.setVisibility(0);
                    break;
                }
                case 2: {
                    holder.downloadIcon.setVisibility(0);
                    if (imageFile.exists()) {
                        Bitmap thumbnail = AttachmentUtil.getBitmap(item.screenshot, 250);
                        holder.image.setImageBitmap(thumbnail);
                        holder.image.setVisibility(0);
                    }
                    holder.progress.setVisibility(0);
                    break;
                }
                case 3: {
                    holder.progress.setVisibility(8);
                    holder.imageIcon.setVisibility(0);
                    if (!imageFile.exists()) break;
                    Bitmap imageBitmap = AttachmentUtil.getBitmap(item.screenshot, 250);
                    if (imageBitmap == null) {
                        holder.image.setVisibility(8);
                        holder.imageIcon.setVisibility(8);
                        holder.downloadIcon.setVisibility(8);
                        holder.errorText.setVisibility(0);
                        holder.fileName.setVisibility(8);
                        holder.fileType.setVisibility(8);
                        holder.fileSize.setVisibility(8);
                        break;
                    }
                    holder.errorText.setVisibility(8);
                    holder.image.setImageBitmap(imageBitmap);
                    holder.image.setVisibility(0);
                }
            }
            if (holder.errorText.getVisibility() != 0) {
                holder.downloadBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (item.state == 3) {
                            MessagesAdapter.this.f.launchAttachment(item);
                        } else if (item.state != 2) {
                            MessagesAdapter.this.f.downloadAdminAttachment(attachmentObj, position, 7);
                        }
                    }
                });
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return convertView;
    }

    private String getText(String input) {
        return Html.fromHtml((String)input.replace("\n", "<br/>")).toString();
    }

    private static class AdminAttachmentImageViewHolder {
        public ImageView image;
        public ProgressBar progress;
        public View downloadBtn;
        public TextView errorText;
        public ImageView downloadIcon;
        public ImageView imageIcon;
        public TextView fileName;
        public TextView fileType;
        public TextView fileSize;
        public TextView date;

        private AdminAttachmentImageViewHolder() {
        }
    }

    private static class AdminAttachmentGenericViewHolder {
        public TextView fileName;
        public TextView fileType;
        public TextView fileSize;
        public View downloadButton;
        public ProgressBar progress;
        public ImageView downloadIcon;
        public ImageView attachmentIcon;
        public TextView date;

        private AdminAttachmentGenericViewHolder() {
        }
    }

    private static class ARViewHolder {
        public TextView text1;
        public TextView date;

        private ARViewHolder() {
        }
    }

    private static class RARViewHolder {
        public TextView message;
        public ProgressBar progress;
        public Button reviewBtn;
        public TextView date;

        private RARViewHolder() {
        }
    }

    private static class SCViewHolder {
        public ProgressBar progress;
        public ImageView image;

        private SCViewHolder() {
        }
    }

    private static class LocalRSCViewHolder {
        public LinearLayout imagePreview;
        public ProgressBar progress;
        public ImageView image;
        public View doneBtn;
        public TextView errorText;
        public TextView textRetry;

        private LocalRSCViewHolder() {
        }
    }

    private static class RSCViewHolder {
        public TextView text1;
        public Button attachBtn;
        public ProgressBar progress;
        public LinearLayout imagePreview;
        public ImageView image;
        public View doneBtn;
        public LinearLayout adminMessage;
        public TextView errorText;
        public TextView textRetry;

        private RSCViewHolder() {
        }
    }

    private static class CSViewHolder {
        public TextView message;
        public TextView text1;
        public TextView text2;

        private CSViewHolder() {
        }
    }

    private static class CBViewHolder {
        public TextView text1;
        public ProgressBar progress;
        public LinearLayout btnContainer;
        public ImageButton button1;
        public ImageButton button2;

        private CBViewHolder() {
        }
    }

    private static class TxtUserHolder {
        public TextView text1;
        public TextView text2;

        private TxtUserHolder() {
        }
    }

    private static class TxtAdminHolder {
        public TextView text1;
        public TextView text2;

        private TxtAdminHolder() {
        }
    }
}

