/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.flows;

import android.os.Bundle;
import com.helpshift.support.SupportInternal;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.flows.Flow;
import java.util.HashMap;
import java.util.Map;

public class SingleFAQFlow
implements Flow {
    private final int labelResId;
    private final String label;
    private final String questionPublishId;
    private final HashMap config;
    private SupportController supportController;

    public SingleFAQFlow(int labelResId, String questionPublishId) {
        this(labelResId, questionPublishId, new HashMap());
    }

    public SingleFAQFlow(int labelResId, String questionPublishId, Map config) {
        this.labelResId = labelResId;
        this.questionPublishId = questionPublishId;
        this.config = new HashMap(config);
        this.label = null;
    }

    public SingleFAQFlow(String label, String questionPublishId) {
        this(label, questionPublishId, new HashMap());
    }

    public SingleFAQFlow(String label, String questionPublishId, Map config) {
        this.label = label;
        this.questionPublishId = questionPublishId;
        this.config = new HashMap(config);
        this.labelResId = 0;
    }

    public void setSupportController(SupportController supportController) {
        this.supportController = supportController;
    }

    @Override
    public int getLabelResId() {
        return this.labelResId;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void performAction() {
        Bundle bundle = SupportInternal.cleanConfig(SupportInternal.removeFAQFlowUnsupportedConfigs(this.config));
        bundle.putString("questionPublishId", this.questionPublishId);
        bundle.putInt("support_mode", 3);
        this.supportController.startFaqFlow(bundle, true);
    }
}

