/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.R;
import com.helpshift.support.HSApiData;
import com.helpshift.support.adapters.MessageListAdapter;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.model.Issue;
import com.helpshift.support.storage.IssuesDataSource;
import com.helpshift.support.util.ConversationsPoller;
import java.lang.ref.WeakReference;

public class ConversationFragment
extends MainFragment
implements View.OnLongClickListener,
View.OnClickListener {
    private HSApiData data;
    private RecyclerView messagesRecyclerView;
    private ConversationsPoller conversationsPoller;

    public static ConversationFragment newInstance(Bundle bundle) {
        ConversationFragment conversationFragment = new ConversationFragment();
        conversationFragment.setArguments(bundle);
        return conversationFragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.data = new HSApiData(context);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__conversation_fragment, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState == null) {
            this.messagesRecyclerView = (RecyclerView)view.findViewById(R.id.messages);
            this.messagesRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext()));
            ConversationPollerSuccessHandler pollerSuccessHandler = new ConversationPollerSuccessHandler(this);
            ConversationPollerFailHandler pollerFailHandler = new ConversationPollerFailHandler(this);
            this.conversationsPoller = new ConversationsPoller(5, pollerSuccessHandler, pollerFailHandler, this.data);
        }
    }

    public boolean onLongClick(View view) {
        return true;
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.review_button) {
            // empty if block
        }
    }

    public void onResume() {
        super.onResume();
        this.refreshMessages();
        this.conversationsPoller.start();
    }

    public void onPause() {
        super.onPause();
        this.conversationsPoller.stop();
    }

    private void refreshMessages() {
        String issueId = this.getArguments().getString("issueId");
        Issue issue = IssuesDataSource.getIssue(issueId);
        MessageListAdapter messageListAdapter = new MessageListAdapter(issue.getMessageList(), this, this);
        this.messagesRecyclerView.setAdapter((RecyclerView.Adapter)messageListAdapter);
    }

    private static class ConversationPollerFailHandler
    extends Handler {
        private final WeakReference<ConversationFragment> conversationFragmentWeakReference;

        public ConversationPollerFailHandler(ConversationFragment fragment) {
            this.conversationFragmentWeakReference = new WeakReference<ConversationFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            ConversationFragment conversationFragment = (ConversationFragment)((Object)this.conversationFragmentWeakReference.get());
            if (conversationFragment != null) {
                // empty if block
            }
        }
    }

    private static class ConversationPollerSuccessHandler
    extends Handler {
        private final WeakReference<ConversationFragment> conversationFragmentWeakReference;

        public ConversationPollerSuccessHandler(ConversationFragment fragment) {
            this.conversationFragmentWeakReference = new WeakReference<ConversationFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            ConversationFragment conversationFragment = (ConversationFragment)((Object)this.conversationFragmentWeakReference.get());
            if (conversationFragment != null) {
                conversationFragment.refreshMessages();
            }
        }
    }
}

