/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.R;
import com.helpshift.support.compositions.FaqFragment;
import com.helpshift.support.contracts.FaqFlowView;
import com.helpshift.support.controllers.FaqFlowController;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.util.FragmentUtil;

public class FaqFlowFragment
extends MainFragment
implements FaqFlowView {
    private FaqFlowController faqFlowController;
    private View verticalDivider;
    private View selectQuestionView;

    public static FaqFlowFragment newInstance(Bundle bundle) {
        FaqFlowFragment faqFlowFragment = new FaqFlowFragment();
        faqFlowFragment.setArguments(bundle);
        return faqFlowFragment;
    }

    public FaqFlowController getFaqFlowController() {
        return this.faqFlowController;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.faqFlowController == null) {
            this.faqFlowController = new FaqFlowController(this, context, this.getRetainedChildFragmentManager(), this.getArguments());
            this.getSupportFragment().setSearchListeners(this.faqFlowController);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__faq_flow_fragment, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.verticalDivider = view.findViewById(R.id.vertical_divider);
        this.selectQuestionView = view.findViewById(R.id.select_question_view);
    }

    public void onResume() {
        super.onResume();
        this.faqFlowController.start();
        this.faqFlowController.startPoller();
        this.updateSelectQuestionUI();
    }

    public void updateSelectQuestionUI() {
        if (this.isScreenLarge() && this.selectQuestionView != null) {
            if (this.getRetainedChildFragmentManager().findFragmentById(R.id.details_fragment_container) == null) {
                this.updateSelectQuestionUI(true);
            } else {
                this.updateSelectQuestionUI(false);
            }
        }
    }

    public void updateSelectQuestionUI(boolean visible) {
        if (this.selectQuestionView != null) {
            if (visible) {
                this.selectQuestionView.setVisibility(0);
            } else {
                this.selectQuestionView.setVisibility(8);
            }
        }
    }

    public void onPause() {
        super.onPause();
        this.faqFlowController.stopPoller();
    }

    public void onDestroy() {
        super.onDestroy();
        this.faqFlowController.quitPoller();
    }

    @Override
    public SupportFragment getSupportFragment() {
        return (SupportFragment)this.getParentFragment();
    }

    public void showVerticalDivider(boolean visible) {
        if (this.verticalDivider != null) {
            if (visible) {
                this.verticalDivider.setVisibility(0);
            } else {
                this.verticalDivider.setVisibility(8);
            }
        }
    }

    public void retryGetSections() {
        FaqFragment faqFragment = FragmentUtil.getFaqFragment(this.getRetainedChildFragmentManager());
        if (faqFragment != null) {
            faqFragment.retryGetSections();
        }
    }
}

