/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import android.widget.FrameLayout;
import com.helpshift.R;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.support.util.LocaleUtil;
import com.helpshift.support.util.Styles;
import com.helpshift.util.HelpshiftContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class MainFragment
extends Fragment {
    public static final String TOOLBAR_ID = "toolbarId";
    private static final String TAG = SupportFragment.class.getSimpleName();
    private final String fragmentName = ((Object)((Object)this)).getClass().getSimpleName();
    private FragmentManager retainedChildFragmentManager;
    private int toolbarId = 0;
    private Toolbar toolbar = null;
    private List<Integer> fragmentMenuItems = null;
    private boolean isChangingConfigurations;
    private boolean isScreenLarge;

    public FragmentManager getRetainedChildFragmentManager() {
        if (this.retainedChildFragmentManager == null) {
            this.retainedChildFragmentManager = this.getChildFragmentManager();
        }
        return this.retainedChildFragmentManager;
    }

    public boolean isChangingConfigurations() {
        return this.isChangingConfigurations;
    }

    public Context getContext() {
        Context context = super.getContext();
        if (context != null) {
            return context;
        }
        return HelpshiftContext.getApplicationContext();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (HelpshiftContext.getApplicationContext() == null) {
            HelpshiftContext.setApplicationContext(context.getApplicationContext());
        }
        LocaleUtil.changeLanguage(this.getContext());
        this.isScreenLarge = this.getResources().getBoolean(R.bool.is_screen_large);
        if (this.retainedChildFragmentManager != null) {
            try {
                Field childFMField = Fragment.class.getDeclaredField("mChildFragmentManager");
                childFMField.setAccessible(true);
                childFMField.set((Object)this, this.retainedChildFragmentManager);
            }
            catch (NoSuchFieldException e) {
                Log.d((String)TAG, (String)"NoSuchFieldException", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.d((String)TAG, (String)"IllegalAccessException", (Throwable)e);
            }
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.toolbarId = bundle.getInt(TOOLBAR_ID);
        }
        if (this.toolbarId == 0 && this.getMenuResourceId() != 0) {
            this.setHasOptionsMenu(true);
        }
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.toolbarId != 0 && this.getMenuResourceId() != 0) {
            this.toolbar = (Toolbar)this.getActivity().findViewById(this.toolbarId);
            Menu parentMenu = this.toolbar.getMenu();
            ArrayList<Integer> parentMenuItems = new ArrayList<Integer>();
            for (int i = 0; i < parentMenu.size(); ++i) {
                parentMenuItems.add(parentMenu.getItem(i).getItemId());
            }
            this.toolbar.inflateMenu(this.getMenuResourceId());
            this.attachMenuListeners(this.toolbar.getMenu());
            Menu fragmentMenu = this.toolbar.getMenu();
            this.fragmentMenuItems = new ArrayList<Integer>();
            for (int i = 0; i < fragmentMenu.size(); ++i) {
                int menuItemId = fragmentMenu.getItem(i).getItemId();
                if (parentMenuItems.contains(menuItemId)) continue;
                this.fragmentMenuItems.add(menuItemId);
            }
        }
    }

    public void onStop() {
        super.onStop();
        if (Build.VERSION.SDK_INT >= 11) {
            this.isChangingConfigurations = this.getActivity(this).isChangingConfigurations();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.toolbar != null) {
            Menu toolbarMenu = this.toolbar.getMenu();
            for (Integer menuItem : this.fragmentMenuItems) {
                toolbarMenu.removeItem(menuItem.intValue());
            }
        }
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        inflater.inflate(this.getMenuResourceId(), menu2);
        this.attachMenuListeners(menu2);
        super.onCreateOptionsMenu(menu2, inflater);
    }

    protected Bundle getBundle() {
        Bundle bundle = new Bundle();
        if (this.toolbarId != 0) {
            bundle.putInt(TOOLBAR_ID, this.toolbarId);
        }
        return bundle;
    }

    protected int getMenuResourceId() {
        return 0;
    }

    protected void attachMenuListeners(Menu menu2) {
    }

    public Activity getActivity(Fragment fragment) {
        if (fragment == null) {
            return null;
        }
        while (fragment.getParentFragment() != null) {
            fragment = fragment.getParentFragment();
        }
        return fragment.getActivity();
    }

    public boolean isScreenLarge() {
        return this.isScreenLarge;
    }

    public void setToolbarTitle(String title) {
        if (this instanceof SupportFragment) {
            ((SupportFragment)this).setTitle(title);
        } else {
            SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
            if (supportFragment != null) {
                supportFragment.setTitle(title);
            }
        }
    }

    public void showToolbarElevation(boolean visible) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.showToolbarElevationLollipop(visible);
        } else {
            this.showToolbarElevationPreLollipop(visible);
        }
    }

    @TargetApi(value=21)
    private void showToolbarElevationLollipop(boolean visible) {
        if (this.toolbar != null) {
            if (visible) {
                this.toolbar.setElevation(Styles.dpToPx(this.getContext(), 4.0f));
            } else {
                this.toolbar.setElevation(0.0f);
            }
        } else {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity(this)).getSupportActionBar();
            if (actionBar != null) {
                if (visible) {
                    actionBar.setElevation(Styles.dpToPx(this.getContext(), 4.0f));
                } else {
                    actionBar.setElevation(0.0f);
                }
            }
        }
    }

    private void showToolbarElevationPreLollipop(boolean visible) {
        FrameLayout flowFragmentContainer = (FrameLayout)this.getActivity(this).findViewById(R.id.flow_fragment_container);
        if (flowFragmentContainer != null) {
            if (visible) {
                Drawable shadow = this.getResources().getDrawable(R.drawable.hs__actionbar_compat_shadow);
                flowFragmentContainer.setForeground(shadow);
            } else {
                flowFragmentContainer.setForeground((Drawable)new ColorDrawable(0));
            }
        }
    }

    public void addVisibleFragment() {
        SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
        if (supportFragment != null) {
            supportFragment.addVisibleFragment(this.fragmentName);
        }
    }

    public void addVisibleFragment(String fragmentName) {
        SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
        if (supportFragment != null) {
            supportFragment.addVisibleFragment(fragmentName);
        }
    }

    public void removeVisibleFragment() {
        SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
        if (supportFragment != null) {
            supportFragment.removeVisibleFragment(this.fragmentName);
        }
    }

    public void removeVisibleFragment(String fragmentName) {
        SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
        if (supportFragment != null) {
            supportFragment.removeVisibleFragment(fragmentName);
        }
    }
}

