/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import com.helpshift.R;
import com.helpshift.exceptions.IdentityException;
import com.helpshift.support.Faq;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.HSSearch;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Support;
import com.helpshift.support.contracts.NewConversationListener;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.model.Form;
import com.helpshift.support.model.Message;
import com.helpshift.support.res.values.HSConfig;
import com.helpshift.support.storage.IssuesDataSource;
import com.helpshift.support.util.AttachmentUtil;
import com.helpshift.support.util.IdentityFilter;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.support.viewstructs.HSMsg;
import com.helpshift.util.HSPattern;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NewConversationFragment
extends MainFragment
implements View.OnClickListener {
    private static final String TAG = NewConversationFragment.class.getSimpleName();
    private NewConversationListener newConversationListener;
    private HSApiData data;
    private HSStorage storage;
    private EditText descriptionField;
    private EditText usernameField;
    private EditText emailField;
    private ImageView screenshotImageView;
    private String screenshotPath;
    private Form validatedForm;
    private CreateIssueSuccessHandler createIssueSuccessHandler;
    private ProfileExistsHandler profileExistsHandler;
    private GetIssuesSuccessHandler getIssuesSuccessHandler;
    private CreateIssueFailureHandler createIssueFailureHandler;
    private GetLatestIssuesSuccessHandler getLatestIssuesSuccessHandler;

    public static NewConversationFragment newInstance(Bundle bundle, NewConversationListener listener) {
        NewConversationFragment newConversationFragment = new NewConversationFragment();
        newConversationFragment.setArguments(bundle);
        newConversationFragment.newConversationListener = listener;
        return newConversationFragment;
    }

    public void setScreenshotPath(String screenshotPath) {
        this.screenshotPath = screenshotPath;
        this.setScreenshotInImageView();
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.data = new HSApiData(context);
        this.storage = this.data.storage;
        this.data.loadIndex();
        this.createIssueSuccessHandler = new CreateIssueSuccessHandler(this);
        this.profileExistsHandler = new ProfileExistsHandler(this);
        this.getIssuesSuccessHandler = new GetIssuesSuccessHandler(this);
        this.createIssueFailureHandler = new CreateIssueFailureHandler(this);
        this.getLatestIssuesSuccessHandler = new GetLatestIssuesSuccessHandler(this);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__new_conversation_frag, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (savedInstanceState == null) {
            this.descriptionField = (EditText)view.findViewById(R.id.conversation_detail);
            this.usernameField = (EditText)view.findViewById(R.id.username);
            this.emailField = (EditText)view.findViewById(R.id.email);
            this.screenshotImageView = (ImageView)view.findViewById(R.id.screenshot);
            this.screenshotImageView.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onResume() {
        super.onResume();
        this.setScreenshotInImageView();
    }

    public void setScreenshotInImageView() {
        if (this.isResumed()) {
            if (TextUtils.isEmpty((CharSequence)this.screenshotPath)) {
                this.screenshotImageView.setImageDrawable(null);
            } else {
                File screenshotFile = new File(this.screenshotPath);
                if (screenshotFile.exists()) {
                    this.screenshotImageView.setImageURI(Uri.fromFile((File)screenshotFile));
                }
            }
        }
    }

    public void checkAndStartNewConversation() {
        Form form = this.validateForm();
        if (form.isFormValid()) {
            this.validatedForm = form;
            if (this.isSearchOnNewConversationEnabled()) {
                ArrayList<Faq> questions = this.getSearchResults(this.validatedForm.getDescription());
                if (questions.size() > 0) {
                    this.newConversationListener.showSearchResultFragment(questions);
                }
            } else {
                this.startNewConversation();
            }
        }
    }

    private static HashMap getUserInfo(Form form, HSStorage storage) {
        HashMap<String, String> data = null;
        if (IdentityFilter.sendNameEmail(storage)) {
            data = new HashMap<String, String>();
            data.put("name", form.getUsername());
            String email = form.getEmail();
            if (!TextUtils.isEmpty((CharSequence)email)) {
                data.put("email", email);
            }
        }
        return data;
    }

    private void clearScreenshot() {
        this.screenshotPath = null;
        this.storage.setConversationScreenshot("", this.data.getLoginId());
        this.setScreenshotInImageView();
    }

    private void handleExit() {
        this.setIsReportingIssue(false);
        boolean dia = (Boolean)HSConfig.configData.get("dia");
        boolean showConversationOnReportIssue = this.getArguments().getBoolean("showConvOnReportIssue", false);
        if (showConversationOnReportIssue && !dia) {
            this.newConversationListener.showConversationOnReportIssue();
        } else {
            this.newConversationListener.exitSdkSession();
        }
    }

    public void startNewConversation() {
        try {
            this.setIsReportingIssue(true);
            this.data.createIssue(this.createIssueSuccessHandler, this.createIssueFailureHandler, this.validatedForm.getDescription(), NewConversationFragment.getUserInfo(this.validatedForm, this.storage));
        }
        catch (IdentityException e) {
            this.data.registerProfile(this.profileExistsHandler, this.createIssueFailureHandler, this.validatedForm.getUsername(), this.validatedForm.getEmail(), this.data.getLoginId());
        }
    }

    private void uploadScreenshot(String issueId) {
        if (!TextUtils.isEmpty((CharSequence)this.screenshotPath)) {
            this.storage.setForegroundIssue(issueId);
            HSMsg msgData = AttachmentUtil.addAndGetLocalRscMsg(this.storage, issueId, this.screenshotPath, true);
            this.data.client.addScMessage(new ScreenshotUploadSuccessHandler(this, issueId, this.screenshotPath), new ScreenshotUploadFailureHandler(this, msgData), this.data.getProfileId(), issueId, "", "sc", msgData.id, msgData.screenshot);
        } else {
            this.handleExit();
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.screenshot && !TextUtils.isEmpty((CharSequence)this.screenshotPath)) {
            this.newConversationListener.startScreenshotPreviewFragment(this.screenshotPath, 2);
        }
    }

    private void setIsReportingIssue(boolean isReportingIssue) {
    }

    private boolean isSearchOnNewConversationEnabled() {
        boolean searchPerformed = true;
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            searchPerformed = bundle.getBoolean("search_performed", true);
        }
        return !searchPerformed && this.storage.getShowSearchOnNewConversation() != false;
    }

    private ArrayList<Faq> getSearchResults(String issueText) {
        return this.data.localFaqSearch(issueText, HSSearch.HS_SEARCH_OPTIONS.KEYWORD_SEARCH);
    }

    private Form validateForm() {
        String email;
        String username;
        boolean isFormValid = true;
        boolean requireEmail = IdentityFilter.requireEmailFromUI(this.data.storage);
        boolean isNameEmailFormShown = IdentityFilter.showNameEmailForm(this.data);
        String issueText = this.descriptionField.getText().toString();
        if (isNameEmailFormShown) {
            username = this.usernameField.getText().toString();
            email = this.emailField.getText().toString();
        } else {
            username = this.data.getUsername();
            email = this.data.getEmail();
        }
        if (issueText.trim().length() == 0) {
            this.descriptionField.setError((CharSequence)this.getString(R.string.hs__conversation_detail_error));
            isFormValid = false;
        } else {
            Resources resources = this.getResources();
            int descriptionMinLength = resources.getInteger(R.integer.hs__issue_description_min_chars);
            if (issueText.replaceAll("\\s+", "").length() < descriptionMinLength) {
                this.descriptionField.setError((CharSequence)resources.getString(R.string.hs__description_invalid_length_error));
                isFormValid = false;
            } else if (HSPattern.checkSpecialCharacters(issueText)) {
                this.descriptionField.setError((CharSequence)this.getString(R.string.hs__invalid_description_error));
                isFormValid = false;
            }
        }
        if (isNameEmailFormShown && username.trim().length() == 0 || HSPattern.checkSpecialCharacters(username)) {
            this.usernameField.setError((CharSequence)this.getString(R.string.hs__username_blank_error));
            isFormValid = false;
        }
        if (requireEmail && TextUtils.isEmpty((CharSequence)email) && !HSPattern.checkEmail(email)) {
            this.emailField.setError((CharSequence)this.getString(R.string.hs__invalid_email_error));
            isFormValid = false;
        } else if (!TextUtils.isEmpty((CharSequence)email) && !HSPattern.checkEmail(email)) {
            this.emailField.setError((CharSequence)this.getString(R.string.hs__invalid_email_error));
            isFormValid = false;
        }
        return new Form(issueText, username, email, isFormValid);
    }

    private static class CreateIssueFailureHandler
    extends Handler {
        private final WeakReference<NewConversationFragment> newConversationFragmentWeakReference;

        public CreateIssueFailureHandler(NewConversationFragment fragment) {
            this.newConversationFragmentWeakReference = new WeakReference<NewConversationFragment>(fragment);
        }

        public void handleMessage(android.os.Message msg) {
            NewConversationFragment newConversationFragment = (NewConversationFragment)((Object)this.newConversationFragmentWeakReference.get());
            if (newConversationFragment != null) {
                newConversationFragment.setIsReportingIssue(false);
                HashMap result = (HashMap)msg.obj;
                Integer status = (Integer)result.get("status");
                if (!newConversationFragment.isDetached()) {
                    SnackbarUtil.showErrorSnackbar(status, newConversationFragment.getView());
                }
            }
        }
    }

    private static class GetIssuesSuccessHandler
    extends Handler {
        private final WeakReference<NewConversationFragment> newConversationFragmentWeakReference;

        public GetIssuesSuccessHandler(NewConversationFragment fragment) {
            this.newConversationFragmentWeakReference = new WeakReference<NewConversationFragment>(fragment);
        }

        public void handleMessage(android.os.Message msg) {
            NewConversationFragment newConversationFragment = (NewConversationFragment)((Object)this.newConversationFragmentWeakReference.get());
            if (newConversationFragment != null) {
                newConversationFragment.startNewConversation();
            }
        }
    }

    private static class ProfileExistsHandler
    extends Handler {
        private final WeakReference<NewConversationFragment> newConversationFragmentWeakReference;

        public ProfileExistsHandler(NewConversationFragment fragment) {
            this.newConversationFragmentWeakReference = new WeakReference<NewConversationFragment>(fragment);
        }

        public void handleMessage(android.os.Message msg) {
            NewConversationFragment newConversationFragment = (NewConversationFragment)((Object)this.newConversationFragmentWeakReference.get());
            if (newConversationFragment != null) {
                HSApiData data = newConversationFragment.data;
                GetIssuesSuccessHandler getIssuesSuccessHandler = newConversationFragment.getIssuesSuccessHandler;
                CreateIssueFailureHandler createIssueFailureHandler = newConversationFragment.createIssueFailureHandler;
                try {
                    HashMap result = (HashMap)msg.obj;
                    JSONObject profileResult = (JSONObject)result.get("response");
                    data.setProfileId(profileResult.get("id").toString());
                    data.getIssues(getIssuesSuccessHandler, createIssueFailureHandler);
                    data.updateUAToken();
                }
                catch (JSONException e) {
                    Log.d((String)TAG, (String)"ProfileExistsHandler", (Throwable)e);
                }
            }
        }
    }

    private static class CreateIssueSuccessHandler
    extends Handler {
        private final WeakReference<NewConversationFragment> newConversationFragmentWeakReference;

        public CreateIssueSuccessHandler(NewConversationFragment fragment) {
            this.newConversationFragmentWeakReference = new WeakReference<NewConversationFragment>(fragment);
        }

        public void handleMessage(android.os.Message msg) {
            NewConversationFragment newConversationFragment = (NewConversationFragment)((Object)this.newConversationFragmentWeakReference.get());
            if (newConversationFragment != null) {
                Form validatedForm = newConversationFragment.validatedForm;
                HSApiData data = newConversationFragment.data;
                HSStorage storage = newConversationFragment.storage;
                try {
                    HashMap result = (HashMap)msg.obj;
                    JSONObject issue = (JSONObject)result.get("response");
                    JSONArray issues = new JSONArray();
                    issues.put((Object)issue);
                    storage.setIssuesTs(issue.getString("created_at"), data.getProfileId());
                    storage.storeIssues(issues, data.getProfileId());
                    data.setUsername(validatedForm.getUsername());
                    data.setEmail(validatedForm.getEmail());
                    storage.storeReply("", data.getProfileId());
                    storage.storeConversationDetail("", data.getLoginId());
                    newConversationFragment.descriptionField.setText((CharSequence)"");
                    HSFunnel.pushEvent("p");
                    String issueId = issue.getString("id");
                    newConversationFragment.uploadScreenshot(issueId);
                    data.startInAppService();
                    Support.Delegate supportDelegate = Support.getDelegate();
                    if (supportDelegate != null) {
                        supportDelegate.newConversationStarted(validatedForm.getDescription());
                    }
                }
                catch (JSONException e) {
                    Log.d((String)TAG, (String)e.toString(), (Throwable)e);
                }
            }
        }
    }

    private static class GetLatestIssuesSuccessHandler
    extends Handler {
        private final WeakReference<NewConversationFragment> newConversationFragmentWeakReference;

        public GetLatestIssuesSuccessHandler(NewConversationFragment fragment) {
            this.newConversationFragmentWeakReference = new WeakReference<NewConversationFragment>(fragment);
        }

        public void handleMessage(android.os.Message msg) {
            NewConversationFragment newConversationFragment = (NewConversationFragment)((Object)this.newConversationFragmentWeakReference.get());
            if (newConversationFragment != null) {
                newConversationFragment.clearScreenshot();
                newConversationFragment.handleExit();
            }
        }
    }

    private static class ScreenshotUploadFailureHandler
    extends Handler {
        private final WeakReference<NewConversationFragment> newConversationFragmentWeakReference;
        private final HSMsg msgData;

        public ScreenshotUploadFailureHandler(NewConversationFragment fragment, HSMsg msgData) {
            this.newConversationFragmentWeakReference = new WeakReference<NewConversationFragment>(fragment);
            this.msgData = msgData;
        }

        public void handleMessage(android.os.Message msg) {
            NewConversationFragment newConversationFragment = (NewConversationFragment)((Object)this.newConversationFragmentWeakReference.get());
            if (newConversationFragment != null) {
                Message.setInProgress(this.msgData.id, false);
                newConversationFragment.clearScreenshot();
                newConversationFragment.handleExit();
            }
        }
    }

    private static class ScreenshotUploadSuccessHandler
    extends Handler {
        private final WeakReference<NewConversationFragment> newConversationFragmentWeakReference;
        private final String issueId;
        private final String screenshotPath;

        public ScreenshotUploadSuccessHandler(NewConversationFragment fragment, String issueId, String screenshotPath) {
            this.newConversationFragmentWeakReference = new WeakReference<NewConversationFragment>(fragment);
            this.issueId = issueId;
            this.screenshotPath = screenshotPath;
        }

        public void handleMessage(android.os.Message msg) {
            NewConversationFragment newConversationFragment = (NewConversationFragment)((Object)this.newConversationFragmentWeakReference.get());
            if (newConversationFragment != null) {
                HSApiData data = newConversationFragment.data;
                GetLatestIssuesSuccessHandler getLatestIssuesSuccessHandler = newConversationFragment.getLatestIssuesSuccessHandler;
                HashMap result = (HashMap)msg.obj;
                JSONObject message = (JSONObject)result.get("response");
                try {
                    JSONObject eventData = new JSONObject();
                    eventData.put("type", (Object)"url");
                    eventData.put("body", (Object)message.getJSONObject("meta").getJSONArray("attachments").getJSONObject(0).getString("url"));
                    eventData.put("id", (Object)this.issueId);
                    HSFunnel.pushEvent("m", eventData);
                    Support.Delegate supportDelegate = Support.getDelegate();
                    if (supportDelegate != null) {
                        supportDelegate.userRepliedToConversation("User sent a screenshot");
                    }
                    AttachmentUtil.copyAttachment((Context)newConversationFragment.getActivity(), data, this.screenshotPath, message.getJSONObject("meta").getString("refers"), 0);
                }
                catch (IOException e) {
                    Log.d((String)TAG, (String)"ScreenshotUploadSuccessHandler - IOException", (Throwable)e);
                }
                catch (JSONException e) {
                    Log.d((String)TAG, (String)"ScreenshotUploadSuccessHandler - JSONException", (Throwable)e);
                }
                try {
                    String refers = message.getJSONObject("meta").getString("refers");
                    if (!TextUtils.isEmpty((CharSequence)refers)) {
                        IssuesDataSource.deleteMessage(refers);
                    }
                    data.getLatestIssues(getLatestIssuesSuccessHandler, getLatestIssuesSuccessHandler);
                }
                catch (JSONException e) {
                    Log.d((String)TAG, (String)"uploadSuccessHandler", (Throwable)e);
                }
            }
        }
    }
}

