/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.R;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.Section;
import com.helpshift.support.adapters.QuestionListAdapter;
import com.helpshift.support.contracts.FaqFragmentListener;
import com.helpshift.support.fragments.FaqFlowFragment;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.support.util.SnackbarUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class QuestionListFragment
extends MainFragment {
    private static final String TAG = QuestionListFragment.class.getSimpleName();
    private FaqFragmentListener faqFragmentListener;
    private HSApiData data;
    private FaqTagFilter faqTagFilter;
    private String sectionTitle;
    private String sectionId;
    private RecyclerView questionList;
    private View.OnClickListener onQuestionClickedListener;
    private boolean eventSent = false;
    private boolean isConfigurationChanged = false;

    public static QuestionListFragment newInstance(Bundle bundle, FaqFragmentListener faqFragmentListener) {
        QuestionListFragment questionListFragment = new QuestionListFragment();
        questionListFragment.setArguments(bundle);
        questionListFragment.faqFragmentListener = faqFragmentListener;
        return questionListFragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getActivity(this).getIntent().getExtras();
        if (extras != null) {
            this.faqTagFilter = (FaqTagFilter)extras.getSerializable("withTagsMatching");
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__question_list_fragment, container, false);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.data = new HSApiData(context);
        this.sectionTitle = this.getString(R.string.hs__help_header);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.questionList = (RecyclerView)view.findViewById(R.id.question_list);
        this.questionList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext()));
        this.onQuestionClickedListener = new View.OnClickListener(){

            public void onClick(View v) {
                String questionPublishId = (String)v.getTag();
                QuestionListFragment.this.faqFragmentListener.onQuestionSelected(questionPublishId, null);
            }
        };
        String sectionPublishId = this.getArguments().getString("sectionPublishId");
        if (this.isScreenLarge()) {
            this.getSectionTitle(sectionPublishId);
        }
        SectionSuccessHandler sectionSuccessHandler = new SectionSuccessHandler(this);
        SectionFailureHandler sectionFailHandler = new SectionFailureHandler(this);
        int supportMode = this.getArguments().getInt("support_mode", 0);
        switch (supportMode) {
            case 2: {
                this.data.getSection(sectionPublishId, sectionSuccessHandler, sectionFailHandler, this.faqTagFilter);
                break;
            }
            default: {
                this.data.getSectionSync(sectionPublishId, sectionSuccessHandler, sectionFailHandler);
            }
        }
    }

    private void updateSectionData(Section section) {
        ArrayList questions = this.data.getFaqsForSection(section.getPublishId(), this.faqTagFilter);
        if (questions == null || questions.isEmpty()) {
            if (!this.isDetached()) {
                SnackbarUtil.showErrorSnackbar(404, this.getView());
            }
        } else {
            this.questionList.setAdapter((RecyclerView.Adapter)new QuestionListAdapter(questions, this.onQuestionClickedListener));
            SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
            if (supportFragment != null) {
                supportFragment.setFaqLoaded(true);
            }
            if (TextUtils.isEmpty((CharSequence)this.sectionId)) {
                this.getSectionId(this.getArguments().getString("sectionPublishId"));
            }
            if (this.getUserVisibleHint() && !TextUtils.isEmpty((CharSequence)this.sectionId) && !this.eventSent && !this.isConfigurationChanged) {
                try {
                    JSONObject eventData = new JSONObject();
                    eventData.put("id", (Object)this.sectionId);
                    HSFunnel.pushEvent("b", eventData);
                    this.eventSent = true;
                }
                catch (JSONException e) {
                    Log.d((String)TAG, (String)e.toString(), (Throwable)e);
                }
            }
        }
    }

    private void getSectionTitle(String sectionPublishId) {
        Section section = this.data.getSection(sectionPublishId);
        if (section != null) {
            this.sectionTitle = section.getTitle();
        }
    }

    private void getSectionId(String sectionPublishId) {
        Section section = this.data.getSection(sectionPublishId);
        if (section != null) {
            this.sectionId = section.getSectionId();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.isScreenLarge()) {
            this.setToolbarTitle(this.sectionTitle);
        }
    }

    public void onStart() {
        super.onStart();
        this.isConfigurationChanged = this.isChangingConfigurations();
        this.eventSent = false;
        if (this.getParentFragment() instanceof FaqFlowFragment) {
            this.addVisibleFragment();
        }
    }

    @Override
    public void onStop() {
        if (this.isScreenLarge()) {
            this.setToolbarTitle(this.getString(R.string.hs__help_header));
        }
        if (this.getParentFragment() instanceof FaqFlowFragment) {
            this.removeVisibleFragment();
        }
        super.onStop();
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        if (isVisibleToUser && !TextUtils.isEmpty((CharSequence)this.sectionId) && !this.isConfigurationChanged) {
            try {
                JSONObject eventData = new JSONObject();
                eventData.put("id", (Object)this.sectionId);
                HSFunnel.pushEvent("b", eventData);
                this.eventSent = true;
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)e.toString(), (Throwable)e);
            }
        }
    }

    private static class SectionFailureHandler
    extends Handler {
        private final WeakReference<QuestionListFragment> questionListFragmentWeakReference;

        public SectionFailureHandler(QuestionListFragment fragment) {
            this.questionListFragmentWeakReference = new WeakReference<QuestionListFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            QuestionListFragment questionListFragment = (QuestionListFragment)((Object)this.questionListFragmentWeakReference.get());
            if (questionListFragment != null && !questionListFragment.isDetached()) {
                HashMap result = (HashMap)msg.obj;
                Integer status = (Integer)result.get("status");
                SnackbarUtil.showErrorSnackbar(status, questionListFragment.getView());
            }
        }
    }

    private static class SectionSuccessHandler
    extends Handler {
        private final WeakReference<QuestionListFragment> questionListFragmentWeakReference;

        public SectionSuccessHandler(QuestionListFragment fragment) {
            this.questionListFragmentWeakReference = new WeakReference<QuestionListFragment>(fragment);
        }

        public void handleMessage(Message msg) {
            QuestionListFragment questionListFragment = (QuestionListFragment)((Object)this.questionListFragmentWeakReference.get());
            if (questionListFragment != null && !questionListFragment.isDetached()) {
                if (msg.obj != null) {
                    Section section = (Section)msg.obj;
                    questionListFragment.updateSectionData(section);
                } else {
                    SnackbarUtil.showErrorSnackbar(404, questionListFragment.getView());
                }
            }
        }
    }
}

