/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import com.helpshift.R;
import com.helpshift.support.contracts.ScreenshotPreviewListener;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.util.AttachmentUtil;

public class ScreenshotPreviewFragment
extends MainFragment
implements View.OnClickListener {
    private ScreenshotPreviewListener screenshotPreviewListener;
    private int mode;
    private ImageView screenshotPreview;
    private String screenshotPath;
    private Button secondaryButton;

    public static ScreenshotPreviewFragment newInstance(Bundle bundle, ScreenshotPreviewListener listener, int mode) {
        ScreenshotPreviewFragment screenshotPreviewFragment = new ScreenshotPreviewFragment();
        screenshotPreviewFragment.setArguments(bundle);
        screenshotPreviewFragment.screenshotPreviewListener = listener;
        screenshotPreviewFragment.mode = mode;
        return screenshotPreviewFragment;
    }

    public void setScreenshotPath(String screenshotPath) {
        this.screenshotPath = screenshotPath;
        this.setScreenshotPreview();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__screenshot_preview_fragment, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.screenshotPreview = (ImageView)view.findViewById(R.id.screenshot_preview);
        Button changeButton = (Button)view.findViewById(R.id.change);
        changeButton.setOnClickListener((View.OnClickListener)this);
        this.secondaryButton = (Button)view.findViewById(R.id.secondary_button);
        this.secondaryButton.setOnClickListener((View.OnClickListener)this);
    }

    public void onResume() {
        super.onResume();
        ScreenshotPreviewFragment.setSecondaryButtonText(this.secondaryButton, this.mode);
        this.setScreenshotPreview();
    }

    private static void setSecondaryButtonText(Button button, int mode) {
        String buttonText;
        Resources resources = button.getResources();
        switch (mode) {
            case 1: {
                buttonText = resources.getString(R.string.hs__screenshot_add);
                break;
            }
            case 2: {
                buttonText = resources.getString(R.string.hs__screenshot_remove);
                break;
            }
            case 3: {
                buttonText = resources.getString(R.string.hs__send_msg_btn);
                break;
            }
            default: {
                buttonText = "";
            }
        }
        button.setText((CharSequence)buttonText);
    }

    private void setScreenshotPreview() {
        if (this.isResumed() && !TextUtils.isEmpty((CharSequence)this.screenshotPath)) {
            Bitmap screenshotBitmap = AttachmentUtil.getBitmap(this.screenshotPath, -1);
            this.screenshotPreview.setImageBitmap(screenshotBitmap);
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.secondary_button && !TextUtils.isEmpty((CharSequence)this.screenshotPath)) {
            switch (this.mode) {
                case 1: {
                    this.screenshotPreviewListener.add(this.screenshotPath);
                    break;
                }
                case 3: {
                    this.screenshotPreviewListener.send(this.screenshotPath);
                    break;
                }
                case 2: {
                    this.screenshotPreviewListener.remove();
                }
            }
        } else if (id2 == R.id.change) {
            if (this.mode == 2) {
                this.mode = 1;
            }
            this.screenshotPreviewListener.change();
        }
    }

    public static class Modes {
        public static final int ADD = 1;
        public static final int REMOVE = 2;
        public static final int SEND = 3;
    }
}

