/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.helpshift.R;
import com.helpshift.support.Faq;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSSearch;
import com.helpshift.support.adapters.SearchListAdapter;
import com.helpshift.support.contracts.FaqFragmentListener;
import com.helpshift.support.contracts.SearchListener;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.util.FragmentUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SearchFragment
extends MainFragment
implements SearchListener {
    public static final String TAG = SearchFragment.class.getSimpleName();
    private FaqFragmentListener faqFragmentListener;
    private HSApiData data;
    private FaqTagFilter faqTagFilter;
    private RecyclerView searchList;
    private View.OnClickListener onQuestionClickedListener;
    private View.OnClickListener onContactUsClickedListener;
    private String currentQuery;
    private String sectionId;
    private SupportController supportController;

    public static SearchFragment newInstance(Bundle bundle) {
        SearchFragment searchFragment = new SearchFragment();
        searchFragment.setArguments(bundle);
        return searchFragment;
    }

    public void setFaqFragmentListener(FaqFragmentListener faqFragmentListener) {
        this.faqFragmentListener = faqFragmentListener;
    }

    public String getCurrentQuery() {
        return this.currentQuery;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getActivity(this).getIntent().getExtras();
        if (extras != null) {
            this.faqTagFilter = (FaqTagFilter)extras.getSerializable("withTagsMatching");
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__search_fragment, container, false);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.data = new HSApiData(context);
        this.data.loadIndex();
        SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
        if (supportFragment != null) {
            this.supportController = supportFragment.getSupportController();
        }
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.searchList = (RecyclerView)view.findViewById(R.id.search_list);
        this.searchList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext()));
        this.onQuestionClickedListener = new View.OnClickListener(){

            public void onClick(View v) {
                String questionPublishId = (String)v.getTag();
                ArrayList<String> searchTerms = null;
                Faq faq = ((SearchListAdapter)SearchFragment.this.searchList.getAdapter()).getFaq(questionPublishId);
                if (faq != null) {
                    searchTerms = faq.getSearchTerms();
                }
                SearchFragment.this.faqFragmentListener.onQuestionSelected(questionPublishId, searchTerms);
            }
        };
        this.onContactUsClickedListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (SearchFragment.this.supportController != null) {
                    SearchFragment.this.supportController.onContactUsClicked(SearchFragment.this.currentQuery);
                }
            }
        };
        this.onQuery(this.currentQuery, this.sectionId);
    }

    public void onStart() {
        super.onStart();
        this.addVisibleFragment();
    }

    @Override
    public void onStop() {
        super.onStop();
        this.removeVisibleFragment();
    }

    @Override
    public void onQuery(String query, String sectionId) {
        this.currentQuery = query;
        this.sectionId = sectionId;
        if (this.searchList == null) {
            return;
        }
        boolean searchWithAny = false;
        String currentLang = Locale.getDefault().getLanguage();
        if (currentLang.equals("zh") || currentLang.equals("ja") || currentLang.equals("ko")) {
            searchWithAny = true;
        }
        query = query == null ? "" : query.trim();
        ArrayList<Faq> searchResult = TextUtils.isEmpty((CharSequence)query) || query.length() < 3 && !searchWithAny ? this.data.getAllFaqs(this.faqTagFilter) : this.data.localFaqSearch(query, HSSearch.HS_SEARCH_OPTIONS.FULL_SEARCH, this.faqTagFilter);
        if (!TextUtils.isEmpty((CharSequence)sectionId)) {
            ArrayList<Faq> sectionResults = new ArrayList<Faq>();
            for (Faq question : searchResult) {
                if (!question.getSectionPublishId().equals(sectionId)) continue;
                sectionResults.add(question);
            }
            searchResult = sectionResults;
        }
        SearchListAdapter searchListAdapter = new SearchListAdapter(this.currentQuery, (List<Faq>)searchResult, this.onQuestionClickedListener, this.onContactUsClickedListener);
        searchListAdapter.setHasStableIds(true);
        if (this.searchList.getAdapter() == null) {
            this.searchList.setAdapter((RecyclerView.Adapter)searchListAdapter);
        } else {
            this.searchList.swapAdapter((RecyclerView.Adapter)new SearchListAdapter(this.currentQuery, searchResult, this.onQuestionClickedListener, this.onContactUsClickedListener), true);
        }
    }
}

