/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.support.ContactUsFilter;
import com.helpshift.support.Faq;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.controllers.ConversationFlowController;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.fragments.ConversationFlowFragment;
import com.helpshift.support.fragments.FaqFlowFragment;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.support.util.Styles;
import com.helpshift.support.webkit.CustomWebChromeClient;
import com.helpshift.support.webkit.CustomWebView;
import com.helpshift.support.webkit.CustomWebViewClient;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class SingleQuestionFragment
extends MainFragment
implements View.OnClickListener,
CustomWebViewClient.CustomWebViewClientListeners {
    private static final String TAG = SingleQuestionFragment.class.getSimpleName();
    private int singleQuestionMode = 1;
    private HSApiData data;
    private CustomWebView webView;
    private View questionFooter;
    private TextView questionFooterMessage;
    private Button yesButton;
    private Button noButton;
    private Button contactUsButton;
    private Faq question;
    private String backgroundColor;
    private String textColor;
    private String textColorLink;
    private boolean isHighlighted;
    private View progressBar;
    private SupportController supportController;
    private String fragmentName;
    private boolean decomp;
    private boolean eventSent;

    public static SingleQuestionFragment newInstance(Bundle bundle, int singleQuestionMode) {
        SingleQuestionFragment singleQuestionFragment = new SingleQuestionFragment();
        singleQuestionFragment.setArguments(bundle);
        singleQuestionFragment.singleQuestionMode = singleQuestionMode;
        singleQuestionFragment.fragmentName = singleQuestionFragment.getClass().getSimpleName() + singleQuestionMode;
        return singleQuestionFragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.data = new HSApiData(context);
        this.getColorsFromTheme(context);
        SupportFragment supportFragment = FragmentUtil.getSupportFragment(this);
        if (supportFragment != null) {
            this.supportController = supportFragment.getSupportController();
        }
    }

    private void getColorsFromTheme(Context context) {
        int textColorLinkResId = 16842907;
        if (Build.VERSION.SDK_INT >= 21) {
            textColorLinkResId = 16843829;
        }
        this.backgroundColor = Styles.getHexColor(context, 16842836);
        this.textColor = Styles.getHexColor(context, 16842806);
        this.textColorLink = Styles.getHexColor(context, textColorLinkResId);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__single_question_fragment, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        Fragment parent;
        super.onViewCreated(view, savedInstanceState);
        this.questionFooter = view.findViewById(R.id.question_footer);
        this.questionFooterMessage = (TextView)view.findViewById(R.id.question_footer_message);
        this.yesButton = (Button)view.findViewById(R.id.helpful_button);
        this.yesButton.setOnClickListener((View.OnClickListener)this);
        this.noButton = (Button)view.findViewById(R.id.unhelpful_button);
        this.noButton.setOnClickListener((View.OnClickListener)this);
        this.contactUsButton = (Button)view.findViewById(R.id.contact_us_button);
        this.contactUsButton.setOnClickListener((View.OnClickListener)this);
        if (this.singleQuestionMode == 2) {
            this.contactUsButton.setText((CharSequence)this.getResources().getString(R.string.hs__send_anyway));
        }
        this.webView = (CustomWebView)view.findViewById(R.id.web_view);
        this.webView.setBackgroundColor(Styles.getColor(this.getContext(), 16842836));
        this.webView.setWebViewClient(new CustomWebViewClient(this.getContext(), this));
        this.webView.setWebChromeClient(new CustomWebChromeClient());
        String questionPublishId = this.getArguments().getString("questionPublishId");
        this.data.getQuestion(questionPublishId, new Success(this), new Failure(this));
        this.progressBar = view.findViewById(R.id.progress_bar);
        if (this.isScreenLarge() && (parent = this.getParentFragment()) instanceof FaqFlowFragment) {
            ((FaqFlowFragment)parent).updateSelectQuestionUI(false);
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getActivity(this).getIntent().getExtras();
        if (extras != null) {
            this.decomp = extras.getBoolean("decomp", false);
        }
    }

    public void onResume() {
        String questionId;
        super.onResume();
        if (this.decomp || !this.isScreenLarge()) {
            this.setToolbarTitle(this.getString(R.string.hs__question_header));
        }
        if (this.question != null && !TextUtils.isEmpty((CharSequence)(questionId = this.question.getId())) && !this.eventSent) {
            try {
                JSONObject eventData = new JSONObject();
                eventData.put("id", (Object)questionId);
                HSFunnel.pushEvent("f", eventData);
                this.eventSent = true;
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"JSONException", (Throwable)e);
            }
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.isChangingConfigurations()) {
            this.eventSent = false;
        }
        this.addVisibleFragment(this.fragmentName);
    }

    @Override
    public void onStop() {
        super.onStop();
        this.removeVisibleFragment(this.fragmentName);
        if (this.decomp || !this.isScreenLarge()) {
            this.setToolbarTitle(this.getString(R.string.hs__help_header));
        }
    }

    private void setQuestion(Faq question) {
        this.question = question;
        this.webView.loadDataWithBaseURL(null, this.getStyledBody(question), "text/html", "utf-8", null);
    }

    private String getStyledBody(Faq question) {
        String titleFontSize = "24px";
        String titleLineHeight = "32px";
        String bodyFontSize = "16px";
        String bodyLineHeight = "1.5";
        String faqPadding = "16px";
        String faqBottomPadding = "96px";
        String bodyText = question.getBody();
        String titleText = question.getTitle();
        if (bodyText.contains("<iframe")) {
            try {
                bodyText = bodyText.replace("https", "http");
            }
            catch (NullPointerException e) {
                Log.d((String)TAG, (String)e.toString(), (Throwable)e);
            }
        }
        String styledBody = question.getIsRtl() != false ? "<html dir=\"rtl\">" : "<html>";
        styledBody = styledBody + "<head>    <style type='text/css'>        img,        object,        embed {            max-width: 100%;        }        a,        a:visited,        a:active,        a:hover {            color: " + this.textColorLink + ";" + "        }" + "        body {" + "            background-color: " + this.backgroundColor + ";" + "            margin: 0;" + "            padding: " + faqPadding + " " + faqPadding + " " + faqBottomPadding + " " + faqPadding + ";" + "            font-size: " + bodyFontSize + ";" + "            line-height: " + bodyLineHeight + ";" + "            white-space: normal;" + "            word-wrap: break-word;" + "            color: " + this.textColor + ";" + "        }" + "        .title {" + "            display: block;" + "            margin: 0;" + "            padding: 0 0 " + faqPadding + " 0;" + "            font-size: " + titleFontSize + ";" + "            line-height: " + titleLineHeight + ";" + "        }" + "        h1, h2, h3 { " + "            line-height: 1.4; " + "        }" + "    </style>" + "    <script language='javascript'>" + "        var iframe = document.getElementsByTagName('iframe')[0];" + "        if (iframe) {" + "            iframe.width = '100%';" + "            iframe.style.width = '100%';" + "        }" + "        document.addEventListener('click', function (event) {" + "            if (event.target instanceof HTMLImageElement) {" + "                event.preventDefault();" + "                event.stopPropagation();" + "            }" + "        }, false);" + "    </script>" + "</head>" + "<body>" + "    <strong class='title'> " + titleText + " </strong> " + bodyText + "</body>" + "</html>";
        return styledBody;
    }

    private void markQuestion(boolean helpful) {
        if (this.question == null) {
            return;
        }
        String questionId = this.question.getId();
        JSONObject params = new JSONObject();
        try {
            params.put("f", (Object)questionId);
            params.put("h", helpful);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"markQuestion", (Throwable)e);
        }
        Handler apiFailHandler = this.data.getApiFailHandler(new MarkQuestionFailure(this), questionId, 0, params);
        this.data.markQuestion(new Handler(), apiFailHandler, questionId, helpful);
        JSONObject eventData = new JSONObject();
        try {
            eventData.put("id", (Object)questionId);
            if (helpful) {
                HSFunnel.pushEvent("h", eventData);
            } else {
                HSFunnel.pushEvent("u", eventData);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"markQuestion", (Throwable)e);
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.helpful_button) {
            ConversationFlowFragment conversationFlowFragment;
            this.markQuestion(true);
            this.showQuestionFooter(1);
            if (this.singleQuestionMode == 2 && (conversationFlowFragment = FragmentUtil.getConversationFlowFragment(this)) != null) {
                ConversationFlowController conversationFlowController = conversationFlowFragment.getConversationFlowController();
                conversationFlowController.actionDone();
            }
        } else if (view.getId() == R.id.unhelpful_button) {
            this.markQuestion(false);
            this.showQuestionFooter(-1);
        } else if (view.getId() == R.id.contact_us_button && this.supportController != null) {
            if (this.singleQuestionMode == 1) {
                this.supportController.onContactUsClicked(null);
            } else {
                ConversationFlowFragment conversationFlowFragment = FragmentUtil.getConversationFlowFragment(this);
                if (conversationFlowFragment != null) {
                    ConversationFlowController conversationFlowController = conversationFlowFragment.getConversationFlowController();
                    conversationFlowController.sendAnyway();
                }
            }
        }
    }

    @Override
    public void onPageStarted() {
        this.showProgress(true);
    }

    @Override
    public void onPageFinished() {
        if (this.isVisible()) {
            this.showProgress(false);
            this.showQuestionFooter(this.question.getIsHelpful());
            this.highlightAndReloadQuestion();
        }
    }

    private void highlightAndReloadQuestion() {
        if (!this.isHighlighted) {
            this.isHighlighted = true;
            ArrayList searchTerms = this.getArguments().getStringArrayList("searchTerms");
            Faq highlightedQuestion = Styles.getQuestionWithHighlightedSearchTerms(this.getContext(), this.question, searchTerms);
            if (highlightedQuestion != null) {
                this.setQuestion(highlightedQuestion);
            }
        }
    }

    private void showProgress(boolean visible) {
        if (this.progressBar != null) {
            if (visible) {
                this.progressBar.setVisibility(0);
            } else {
                this.progressBar.setVisibility(8);
            }
        }
    }

    private void showQuestionFooter(int state) {
        switch (state) {
            case 0: {
                this.showQuestionFooter();
                break;
            }
            case 1: {
                this.showHelpfulFooter();
                break;
            }
            case -1: {
                this.showUnhelpfulFooter();
            }
        }
    }

    private void showQuestionFooter() {
        this.questionFooter.setVisibility(0);
        this.questionFooterMessage.setText((CharSequence)this.getResources().getString(R.string.hs__mark_yes_no_question));
        this.contactUsButton.setVisibility(8);
        this.yesButton.setVisibility(0);
        this.noButton.setVisibility(0);
    }

    private void showHelpfulFooter() {
        this.questionFooter.setVisibility(0);
        this.questionFooterMessage.setText((CharSequence)this.getResources().getString(R.string.hs__question_helpful_message));
        this.contactUsButton.setVisibility(8);
        this.yesButton.setVisibility(8);
        this.noButton.setVisibility(8);
    }

    private void showUnhelpfulFooter() {
        this.questionFooter.setVisibility(0);
        this.questionFooterMessage.setText((CharSequence)this.getResources().getString(R.string.hs__question_unhelpful_message));
        this.showQuestionFooterContactUs();
        this.yesButton.setVisibility(8);
        this.noButton.setVisibility(8);
    }

    private void showQuestionFooterContactUs() {
        if (ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.QUESTION_FOOTER)) {
            this.contactUsButton.setVisibility(0);
        } else {
            this.contactUsButton.setVisibility(8);
        }
    }

    public String getQuestionId() {
        String questionId = "";
        if (this.question != null) {
            questionId = this.question.getId();
        }
        return questionId;
    }

    private static class Failure
    extends Handler {
        private WeakReference<SingleQuestionFragment> singleQuestionFragmentWeakReference;

        public Failure(SingleQuestionFragment singleQuestionFragment) {
            this.singleQuestionFragmentWeakReference = new WeakReference<SingleQuestionFragment>(singleQuestionFragment);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            SingleQuestionFragment singleQuestionFragment = (SingleQuestionFragment)this.singleQuestionFragmentWeakReference.get();
            if (singleQuestionFragment != null && !singleQuestionFragment.isDetached()) {
                SnackbarUtil.showErrorSnackbar(404, singleQuestionFragment.getView());
            }
        }
    }

    private static class Success
    extends Handler {
        private WeakReference<SingleQuestionFragment> singleQuestionFragmentWeakReference;

        public Success(SingleQuestionFragment singleQuestionFragment) {
            this.singleQuestionFragmentWeakReference = new WeakReference<SingleQuestionFragment>(singleQuestionFragment);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            SingleQuestionFragment singleQuestionFragment = (SingleQuestionFragment)this.singleQuestionFragmentWeakReference.get();
            if (singleQuestionFragment != null) {
                Faq question = (Faq)msg.obj;
                singleQuestionFragment.setQuestion(question);
                String questionId = question.getId();
                if (!singleQuestionFragment.eventSent && !TextUtils.isEmpty((CharSequence)questionId)) {
                    try {
                        JSONObject eventData = new JSONObject();
                        eventData.put("id", (Object)questionId);
                        HSFunnel.pushEvent("f", eventData);
                        singleQuestionFragment.eventSent = true;
                    }
                    catch (JSONException e) {
                        Log.d((String)TAG, (String)"JSONException", (Throwable)e);
                    }
                }
            }
        }
    }

    private static class MarkQuestionFailure
    extends Handler {
        private WeakReference<SingleQuestionFragment> singleQuestionFragmentWeakReference;

        public MarkQuestionFailure(SingleQuestionFragment singleQuestionFragment) {
            this.singleQuestionFragmentWeakReference = new WeakReference<SingleQuestionFragment>(singleQuestionFragment);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            SingleQuestionFragment singleQuestionFragment = (SingleQuestionFragment)this.singleQuestionFragmentWeakReference.get();
            if (singleQuestionFragment != null && !singleQuestionFragment.isDetached()) {
                HashMap result = (HashMap)msg.obj;
                Integer status = (Integer)result.get("status");
                SnackbarUtil.showErrorSnackbar(status, singleQuestionFragment.getView());
            }
        }
    }

    public static class SingleQuestionModes {
        public static final int STANDARD = 1;
        public static final int DONE = 2;
    }
}

