/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.fragments;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.support.ContactUsFilter;
import com.helpshift.support.HSAddIssueFragment;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.HSMessagesFragment;
import com.helpshift.support.HSStorage;
import com.helpshift.support.SupportInternal;
import com.helpshift.support.compositions.FaqFragment;
import com.helpshift.support.compositions.SectionPagerFragment;
import com.helpshift.support.controllers.ConversationFlowController;
import com.helpshift.support.controllers.FaqFlowController;
import com.helpshift.support.controllers.SupportController;
import com.helpshift.support.fragments.ConversationFlowFragment;
import com.helpshift.support.fragments.FaqFlowFragment;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.fragments.QuestionListFragment;
import com.helpshift.support.fragments.SearchFragment;
import com.helpshift.support.fragments.SingleQuestionFragment;
import com.helpshift.support.util.FragmentUtil;
import com.helpshift.support.util.HSActivityUtil;
import com.helpshift.support.util.Styles;
import com.helpshift.util.ApplicationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SupportFragment
extends MainFragment
implements View.OnClickListener {
    public static final String SUPPORT_MODE = "support_mode";
    private static boolean isForeground;
    private final List<String> visibleFragments = Collections.synchronizedList(new ArrayList());
    private SupportController supportController;
    private View viewNoFaqs;
    private View viewFaqsLoading;
    private View viewFaqsLoadError;
    private boolean menuItemsPrepared;
    private MenuItem searchMenuItem;
    private SearchView searchView;
    private MenuItem contactUsMenuItem;
    private MenuItem attachScreenshotMenuItem;
    private MenuItem startNewConversationMenuItem;
    private MenuItem doneMenuItem;
    private boolean faqLoaded;
    private HSApiData data;
    private HSStorage storage;
    private int newMessageCount = 0;
    private int toolbarId;
    private Toolbar toolbar;

    public static SupportFragment newInstance(Bundle bundle) {
        SupportFragment supportFragment = new SupportFragment();
        supportFragment.setArguments(bundle);
        return supportFragment;
    }

    public static boolean isForeground() {
        return isForeground;
    }

    public SupportController getSupportController() {
        return this.supportController;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.setRetainInstance(true);
        this.data = new HSApiData(context);
        this.storage = this.data.storage;
        String profileId = this.data.getProfileId();
        this.newMessageCount = this.storage.getActiveNotifCnt(profileId);
        if (this.supportController == null) {
            this.supportController = new SupportController(this.getRetainedChildFragmentManager(), this.getArguments());
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.hs__support_fragment, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.viewNoFaqs = view.findViewById(R.id.view_no_faqs);
        this.viewFaqsLoading = view.findViewById(R.id.view_faqs_loading);
        this.viewFaqsLoadError = view.findViewById(R.id.view_faqs_load_error);
        Button buttonRetry = (Button)view.findViewById(R.id.button_retry);
        buttonRetry.setOnClickListener((View.OnClickListener)this);
        if (this.storage.isHelpshiftBrandingDisabled()) {
            ImageView hsLogo = (ImageView)view.findViewById(R.id.hs_logo);
            hsLogo.setVisibility(8);
        }
        if (this.toolbarId != 0) {
            this.toolbar = (Toolbar)this.getActivity(this).findViewById(this.toolbarId);
        }
    }

    @Override
    protected int getMenuResourceId() {
        return R.menu.hs__support_fragment;
    }

    @Override
    protected void attachMenuListeners(Menu menu2) {
        this.searchMenuItem = menu2.findItem(R.id.hs__search);
        this.searchView = (SearchView)MenuItemCompat.getActionView((MenuItem)this.searchMenuItem);
        this.contactUsMenuItem = menu2.findItem(R.id.hs__contact_us);
        this.contactUsMenuItem.setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this.supportController);
        MenuItemCompat.getActionView((MenuItem)this.contactUsMenuItem).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SupportFragment.this.supportController.onMenuItemClick(SupportFragment.this.contactUsMenuItem);
            }
        });
        this.attachScreenshotMenuItem = menu2.findItem(R.id.hs__attach_screenshot);
        this.startNewConversationMenuItem = menu2.findItem(R.id.hs__start_new_conversation);
        this.doneMenuItem = menu2.findItem(R.id.hs__action_done);
        this.menuItemsPrepared = true;
        this.setSearchListeners(null);
        this.setConversationListeners(null);
        this.refreshMenu();
    }

    public void setSearchListeners(FaqFlowController faqFlowController) {
        if (this.menuItemsPrepared) {
            FaqFlowFragment faqFlowFragment;
            if (faqFlowController == null && (faqFlowFragment = FragmentUtil.getFaqFlowFragment(this.getRetainedChildFragmentManager())) != null) {
                faqFlowController = faqFlowFragment.getFaqFlowController();
            }
            if (faqFlowController != null) {
                MenuItemCompat.setOnActionExpandListener((MenuItem)this.searchMenuItem, (MenuItemCompat.OnActionExpandListener)faqFlowController);
                this.searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)faqFlowController);
            }
        }
    }

    public void setConversationListeners(ConversationFlowController conversationFlowController) {
        if (this.menuItemsPrepared) {
            ConversationFlowFragment conversationFlowFragment;
            if (conversationFlowController == null && (conversationFlowFragment = FragmentUtil.getConversationFlowFragment(this.getChildFragmentManager())) != null) {
                conversationFlowController = conversationFlowFragment.getConversationFlowController();
            }
            if (conversationFlowController != null) {
                this.attachScreenshotMenuItem.setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)conversationFlowController);
                this.startNewConversationMenuItem.setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)conversationFlowController);
                this.doneMenuItem.setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)conversationFlowController);
            }
        }
    }

    private void setMenuItemColors() {
        Styles.setActionButtonIconColor(this.getContext(), this.searchMenuItem.getIcon());
        Styles.setActionButtonIconColor(this.getContext(), this.contactUsMenuItem.getIcon());
        View contactUsView = MenuItemCompat.getActionView((MenuItem)this.contactUsMenuItem);
        TextView notificationBadge = (TextView)contactUsView.findViewById(R.id.hs__notification_badge);
        Styles.setActionButtonIconColor(this.getContext(), notificationBadge.getBackground());
        Styles.setActionButtonIconColor(this.getContext(), this.attachScreenshotMenuItem.getIcon());
        Styles.setActionButtonIconColor(this.getContext(), this.startNewConversationMenuItem.getIcon());
        Styles.setActionButtonIconColor(this.getContext(), this.doneMenuItem.getIcon());
    }

    private void hideAllMenuItems() {
        this.searchMenuItem.setVisible(false);
        this.contactUsMenuItem.setVisible(false);
        this.attachScreenshotMenuItem.setVisible(false);
        this.startNewConversationMenuItem.setVisible(false);
        this.doneMenuItem.setVisible(false);
    }

    @Override
    public void addVisibleFragment(String fragment) {
        this.visibleFragments.add(fragment);
        this.refreshMenu();
    }

    @Override
    public void removeVisibleFragment(String fragment) {
        this.visibleFragments.remove(fragment);
        this.refreshMenu();
    }

    public void setFaqLoaded(boolean faqLoaded) {
        this.faqLoaded = faqLoaded;
        this.refreshMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMenu() {
        if (this.menuItemsPrepared) {
            this.hideAllMenuItems();
            this.setMenuItemColors();
            List<String> list = this.visibleFragments;
            synchronized (list) {
                for (String fragment : this.visibleFragments) {
                    if (fragment.equals(FaqFragment.class.getSimpleName())) {
                        this.showFaqFragmentMenu();
                        continue;
                    }
                    if (fragment.equals(SearchFragment.class.getSimpleName())) {
                        this.restoreSearchMenuItem();
                        continue;
                    }
                    if (fragment.equals(SingleQuestionFragment.class.getSimpleName() + 1)) {
                        this.showSingleQuestionFragmentMenu();
                        continue;
                    }
                    if (fragment.equals(SectionPagerFragment.class.getSimpleName())) {
                        this.showSectionPagerFragmentMenu();
                        continue;
                    }
                    if (fragment.equals(QuestionListFragment.class.getSimpleName())) {
                        this.showQuestionListFragmentMenu();
                        continue;
                    }
                    if (fragment.equals(HSAddIssueFragment.class.getSimpleName())) {
                        this.restoreHSAddIssueFragmentMenu();
                        continue;
                    }
                    if (fragment.equals(HSMessagesFragment.class.getSimpleName())) {
                        this.restoreHSMessagesFragmentMenu();
                        continue;
                    }
                    if (!fragment.equals(SingleQuestionFragment.class.getSimpleName() + 2)) continue;
                    this.restoreSingleQuestionDoneModeFragmentMenu();
                }
            }
        }
    }

    private void restoreSingleQuestionDoneModeFragmentMenu() {
        this.doneMenuItem.setVisible(true);
    }

    private void restoreHSMessagesFragmentMenu() {
        HSMessagesFragment hsMessagesFragment;
        this.setRetainSearchFragmentState(true);
        this.setSearchMenuVisible(false);
        this.setContactUsMenuVisible(false);
        this.startNewConversationMenuItem.setVisible(false);
        ConversationFlowFragment conversationFlowFragment = FragmentUtil.getConversationFlowFragment(this.getChildFragmentManager());
        if (conversationFlowFragment != null && (hsMessagesFragment = FragmentUtil.getHSMessagesFragment(conversationFlowFragment.getRetainedChildFragmentManager())) != null) {
            LinearLayout messageBox = hsMessagesFragment.getMessageBox();
            if (!this.storage.getEnableFullPrivacy().booleanValue() && messageBox != null && messageBox.getVisibility() == 0 && !hsMessagesFragment.isIssueRejected()) {
                this.attachScreenshotMenuItem.setVisible(this.canAttachScreenshot(hsMessagesFragment.getContext()));
            } else {
                this.attachScreenshotMenuItem.setVisible(false);
            }
            this.doneMenuItem.setVisible(false);
        }
    }

    private void restoreHSAddIssueFragmentMenu() {
        HSAddIssueFragment hsAddIssueFragment;
        this.setRetainSearchFragmentState(true);
        this.setSearchMenuVisible(false);
        this.setContactUsMenuVisible(false);
        ConversationFlowFragment conversationFlowFragment = FragmentUtil.getConversationFlowFragment(this.getChildFragmentManager());
        if (conversationFlowFragment != null && (hsAddIssueFragment = FragmentUtil.getHsAddIssueFragment(conversationFlowFragment.getRetainedChildFragmentManager())) != null) {
            this.startNewConversationMenuItem.setVisible(hsAddIssueFragment.isShowStartNewConversationMenu());
            if (this.storage.getEnableFullPrivacy().booleanValue()) {
                this.attachScreenshotMenuItem.setVisible(false);
            } else {
                this.attachScreenshotMenuItem.setVisible(this.canAttachScreenshot(hsAddIssueFragment.getContext()) && hsAddIssueFragment.isShowAttachScreenshotMenu());
            }
            this.doneMenuItem.setVisible(false);
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private boolean canAttachScreenshot(Context context) {
        int apiVersion = ApplicationUtil.getDeviceApiVersion();
        return apiVersion < 19 || apiVersion >= 23 || ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
    }

    private void showQuestionListFragmentMenu() {
        this.setSearchMenuVisible(this.faqLoaded);
        this.setContactUsMenuVisible(ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.ACTION_BAR));
    }

    private void showSectionPagerFragmentMenu() {
        this.setSearchMenuVisible(true);
        this.setContactUsMenuVisible(ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.ACTION_BAR));
    }

    private void showSingleQuestionFragmentMenu() {
        if (!this.isScreenLarge()) {
            this.setRetainSearchFragmentState(true);
            this.setSearchMenuVisible(false);
        }
        this.setContactUsMenuVisible(ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.QUESTION_ACTION_BAR));
    }

    private void setRetainSearchFragmentState(boolean retainSearchFragmentState) {
        FaqFlowFragment faqFlowFragment = FragmentUtil.getFaqFlowFragment(this.getRetainedChildFragmentManager());
        if (faqFlowFragment != null) {
            faqFlowFragment.getFaqFlowController().setRetainSearchFragmentState(retainSearchFragmentState);
        }
    }

    private void restoreSearchMenuItem() {
        SearchFragment searchFragment;
        FaqFlowFragment faqFlowFragment = FragmentUtil.getFaqFlowFragment(this.getRetainedChildFragmentManager());
        if (faqFlowFragment != null && (searchFragment = FragmentUtil.getSearchFragment(faqFlowFragment.getRetainedChildFragmentManager())) != null) {
            this.setSearchMenuQuery(searchFragment.getCurrentQuery());
        }
        this.setContactUsMenuVisible(ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.ACTION_BAR));
        this.setRetainSearchFragmentState(false);
    }

    private void showFaqFragmentMenu() {
        this.setSearchMenuVisible(this.faqLoaded);
        this.setContactUsMenuVisible(ContactUsFilter.showContactUs(ContactUsFilter.LOCATION.ACTION_BAR));
    }

    public void setContactUsMenuVisible(boolean visible) {
        if (MenuItemCompat.isActionViewExpanded((MenuItem)this.searchMenuItem)) {
            this.contactUsMenuItem.setVisible(false);
        } else {
            this.contactUsMenuItem.setVisible(visible);
        }
        this.updateBadgeIcon();
    }

    public void setSearchMenuVisible(boolean visible) {
        if (MenuItemCompat.isActionViewExpanded((MenuItem)this.searchMenuItem)) {
            MenuItemCompat.collapseActionView((MenuItem)this.searchMenuItem);
        }
        this.searchMenuItem.setVisible(visible);
    }

    public void setSearchMenuQuery(String query) {
        if (!MenuItemCompat.isActionViewExpanded((MenuItem)this.searchMenuItem)) {
            MenuItemCompat.expandActionView((MenuItem)this.searchMenuItem);
        }
        if (!TextUtils.isEmpty((CharSequence)query)) {
            this.searchView.setQuery((CharSequence)query, false);
        }
    }

    public void setNewMessagesCount(int count) {
        this.newMessageCount = count;
        this.updateBadgeIcon();
    }

    private void updateBadgeIcon() {
        View actionView;
        if (this.contactUsMenuItem != null && this.contactUsMenuItem.isVisible() && (actionView = MenuItemCompat.getActionView((MenuItem)this.contactUsMenuItem)) != null) {
            TextView badge = (TextView)actionView.findViewById(R.id.hs__notification_badge);
            View padding = actionView.findViewById(R.id.hs__notification_badge_padding);
            if (this.newMessageCount != 0) {
                badge.setText((CharSequence)String.valueOf(this.newMessageCount));
                padding.setVisibility(8);
                badge.setVisibility(0);
            } else {
                badge.setVisibility(8);
                padding.setVisibility(0);
            }
        }
    }

    public void resetNewMessageCount() {
        this.newMessageCount = 0;
    }

    public void updateFaqLoadingUI(int state) {
        this.viewNoFaqs.setVisibility(8);
        this.viewFaqsLoading.setVisibility(8);
        this.viewFaqsLoadError.setVisibility(8);
        switch (state) {
            case 0: {
                this.viewFaqsLoading.setVisibility(0);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.viewNoFaqs.setVisibility(0);
                break;
            }
            case 3: {
                this.viewFaqsLoadError.setVisibility(0);
            }
        }
    }

    public void onStart() {
        super.onStart();
        if (!this.isChangingConfigurations()) {
            HSActivityUtil.sessionBeginning();
            int supportMode = this.getArguments().getInt(SUPPORT_MODE, 0);
            if (supportMode == 0) {
                HSFunnel.pushEvent("o");
            } else {
                HSFunnel.pushEvent("d");
            }
            SupportInternal.Delegate delegate = SupportInternal.getDelegate();
            if (delegate != null) {
                delegate.sessionBegan();
            }
        }
        isForeground = true;
    }

    public void onResume() {
        super.onResume();
        this.supportController.start();
        this.setToolbarTitle(this.getString(R.string.hs__help_header));
        this.showToolbarElevation(true);
    }

    @Override
    public void onStop() {
        super.onStop();
        if (!this.isChangingConfigurations()) {
            HSActivityUtil.sessionEnding();
            HSFunnel.pushEvent("q");
            isForeground = false;
            this.data.reportActionEvents();
            SupportInternal.Delegate delegate = SupportInternal.getDelegate();
            if (delegate != null) {
                delegate.sessionEnded();
            }
        }
    }

    public boolean onBackPressed() {
        List fragments = this.getRetainedChildFragmentManager().getFragments();
        if (fragments != null) {
            for (Fragment fragment : fragments) {
                FragmentManager childFragmentManager;
                if (fragment == null || !fragment.isVisible() || !(fragment instanceof FaqFlowFragment) && !(fragment instanceof ConversationFlowFragment) || (childFragmentManager = fragment.getChildFragmentManager()).getBackStackEntryCount() <= 0) continue;
                childFragmentManager.popBackStack();
                return true;
            }
        }
        return false;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        List fragments = this.getRetainedChildFragmentManager().getFragments();
        if (fragments != null) {
            for (Fragment fragment : fragments) {
                if (fragment == null || !fragment.isVisible() || !(fragment instanceof ConversationFlowFragment)) continue;
                fragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
                return;
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        List fragments = this.getRetainedChildFragmentManager().getFragments();
        if (fragments != null) {
            for (Fragment fragment : fragments) {
                if (fragment == null || !(fragment instanceof ConversationFlowFragment)) continue;
                fragment.onActivityResult(requestCode, resultCode, data);
                return;
            }
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onClick(View v) {
        FaqFlowFragment faqFlowFragment;
        if (v.getId() == R.id.button_retry && (faqFlowFragment = FragmentUtil.getFaqFlowFragment(this.getRetainedChildFragmentManager())) != null) {
            faqFlowFragment.retryGetSections();
        }
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.toolbarId = bundle.getInt("toolbarId");
        }
    }

    public void setTitle(String title) {
        if (this.toolbar != null) {
            this.toolbar.setTitle((CharSequence)title);
        } else {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity(this)).getSupportActionBar();
            if (actionBar != null) {
                actionBar.setTitle((CharSequence)title);
            }
        }
    }

    public static class SupportModes {
        public static final int CONVERSATION = 1;
        public static final int FAQ_SECTION = 2;
        public static final int SINGLE_QUESTION = 3;
        public static final int DYNAMIC_FORM = 4;
    }
}

