/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.model;

import android.content.Context;
import android.text.TextUtils;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Log;
import com.helpshift.support.storage.IssuesDataSource;
import com.helpshift.support.util.Meta;
import com.helpshift.util.TimeUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorReport {
    public static final String KEY_REPORT_TYPE = "report_type";
    public static final String KEY_DEVICE_INFO = "device_info";
    public static final String KEY_HELPSHIFT_CONTEXT = "helpshift_context";
    public static final String KEY_CONVERSATION_CONTEXT = "conversation_context";
    public static final String KEY_ERROR_DATA = "error_data";
    public static final String KEY_FUNNEL = "funnel";
    public static final String KEY_BREAD_CRUMBS = "bread_crumbs";
    public static final String KEY_PROFILE_ID = "profile_id";
    public static final String KEY_ACTIVE_CONVERSATION_ID = "active_conversation_id";
    public static final String KEY_ACTIVE_MESSAGE_IDS = "active_message_ids";
    public static final String KEY_THREAD_INFO = "thread_info";
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String KEY_EXCEPTION_DETAIL = "exception_detail";
    public static final String KEY_CLASS_NAME = "class_name";
    public static final String KEY_METHOD_NAME = "method_name";
    public static final String KEY_LINE_NO = "line_no";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_TRACE = "trace";
    public static final String KEY_CAUSE = "cause";
    public static final long BATCH_TIME = 86400000L;
    private static String TAG = "HelpShiftDebug";
    private String reportId = "";
    private String reportType = "";
    private JSONObject deviceInfo = new JSONObject();
    private Map<String, String> helpshiftContext = new HashMap<String, String>();
    private Map<String, String> conversationContext = new HashMap<String, String>();
    private Map<String, Object> errorData = new HashMap<String, Object>();

    public ErrorReport() {
    }

    public ErrorReport(Context context, HSApiData hsApiData, String reportType, Thread thread, Throwable throwable) {
        this();
        this.reportType = reportType;
        HSStorage hsStorage = hsApiData.storage;
        String timestamp = String.valueOf(TimeUtil.getAdjustedTimeInMillis(hsStorage.getServerTimeDelta()));
        this.reportId = "hs_error_report_" + UUID.randomUUID().toString();
        try {
            this.deviceInfo = Meta.getMinimalDeviceInfo(context);
            JSONArray jsonArrayFunnel = HSFunnel.getActions();
            JSONArray jsonArrayBreadCrumbs = hsStorage.getBreadCrumbs();
            if (jsonArrayFunnel == null) {
                this.helpshiftContext.put(KEY_FUNNEL, "[]");
            } else {
                this.helpshiftContext.put(KEY_FUNNEL, jsonArrayFunnel.toString());
            }
            this.helpshiftContext.put(KEY_BREAD_CRUMBS, jsonArrayBreadCrumbs.toString());
            String profileId = hsApiData.getProfileId();
            this.conversationContext.put(KEY_PROFILE_ID, profileId);
            String activeConversationId = null;
            if (!TextUtils.isEmpty((CharSequence)profileId)) {
                activeConversationId = hsStorage.getActiveConversation(profileId);
            }
            this.conversationContext.put(KEY_ACTIVE_CONVERSATION_ID, activeConversationId);
            List<String> messageIds = IssuesDataSource.getMessageIds(activeConversationId);
            String messageIdsJson = new JSONArray(messageIds).toString();
            this.conversationContext.put(KEY_ACTIVE_MESSAGE_IDS, messageIdsJson);
            String threadInfo = "Unknown";
            if (thread != null) {
                threadInfo = thread.toString();
            }
            this.errorData.put(KEY_THREAD_INFO, threadInfo);
            this.errorData.put(KEY_TIMESTAMP, timestamp);
            this.errorData.put(KEY_EXCEPTION_DETAIL, throwable);
        }
        catch (JSONException e) {
            Log.d(TAG, "Error parsing JSON", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] throwableToBytes(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        byte[] bytes = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutput = null;
        try {
            objectOutput = new ObjectOutputStream(byteArrayOutputStream);
            objectOutput.writeObject(throwable);
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            Log.d(TAG, "Error converting throwableToBytes", e);
        }
        finally {
            if (objectOutput != null) {
                try {
                    objectOutput.close();
                    byteArrayOutputStream.close();
                }
                catch (IOException e) {
                    Log.d(TAG, "Error converting throwableToBytes", e);
                }
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable bytesToThrowable(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Throwable throwable = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        ObjectInputStream objectInput = null;
        try {
            objectInput = new ObjectInputStream(byteArrayInputStream);
            throwable = (Throwable)objectInput.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            Log.d(TAG, "Error converting bytesToThrowable", e);
        }
        finally {
            if (objectInput != null) {
                try {
                    objectInput.close();
                    byteArrayInputStream.close();
                }
                catch (IOException e) {
                    Log.d(TAG, "Error converting bytesToThrowable", e);
                }
            }
        }
        return throwable;
    }

    private JSONObject throwableToJSON(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        JSONObject jsonObjectException = new JSONObject();
        try {
            StackTraceElement[] stackTraceElements;
            jsonObjectException.put(KEY_MESSAGE, (Object)throwable.getMessage());
            JSONArray jsonArrayStackTrace = new JSONArray();
            for (StackTraceElement stackTraceElement : stackTraceElements = throwable.getStackTrace()) {
                JSONObject jsonObjectTraceElement = new JSONObject();
                jsonObjectTraceElement.put(KEY_CLASS_NAME, (Object)stackTraceElement.getClassName());
                jsonObjectTraceElement.put(KEY_METHOD_NAME, (Object)stackTraceElement.getMethodName());
                jsonObjectTraceElement.put(KEY_LINE_NO, stackTraceElement.getLineNumber());
                jsonArrayStackTrace.put((Object)jsonObjectTraceElement);
            }
            jsonObjectException.put(KEY_TRACE, (Object)jsonArrayStackTrace);
            jsonObjectException.put(KEY_CAUSE, (Object)this.throwableToJSON(throwable.getCause()));
        }
        catch (JSONException e) {
            Log.d(TAG, "Error parsing JSON in throwableToJSON", e);
        }
        return jsonObjectException;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public JSONObject getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        try {
            this.deviceInfo = new JSONObject(deviceInfo);
        }
        catch (JSONException e) {
            Log.d(TAG, "Error parsing JSON in setDeviceInfo", e);
        }
    }

    public Map<String, String> getHelpshiftContext() {
        return this.helpshiftContext;
    }

    public void setHelpshiftContext(Map<String, String> helpshiftContext) {
        this.helpshiftContext = helpshiftContext;
    }

    public Map<String, String> getConversationContext() {
        return this.conversationContext;
    }

    public void setConversationContext(Map<String, String> conversationContext) {
        this.conversationContext = conversationContext;
    }

    public Map<String, Object> getErrorData() {
        return this.errorData;
    }

    public void setErrorData(Map<String, Object> errorData) {
        this.errorData = errorData;
    }

    public JSONObject getJSONObject() {
        JSONObject errorReport = new JSONObject();
        try {
            errorReport.put(KEY_REPORT_TYPE, (Object)this.reportType);
            errorReport.put(KEY_DEVICE_INFO, (Object)this.deviceInfo);
            JSONObject jsonObjectHelpshiftContext = new JSONObject(this.helpshiftContext);
            errorReport.put(KEY_HELPSHIFT_CONTEXT, (Object)jsonObjectHelpshiftContext.toString());
            JSONObject jsonObjectConversationContext = new JSONObject(this.conversationContext);
            errorReport.put(KEY_CONVERSATION_CONTEXT, (Object)jsonObjectConversationContext.toString());
            JSONObject jsonObjectErrorData = new JSONObject();
            jsonObjectErrorData.put(KEY_THREAD_INFO, this.errorData.get(KEY_THREAD_INFO));
            jsonObjectErrorData.put(KEY_TIMESTAMP, this.errorData.get(KEY_TIMESTAMP));
            jsonObjectErrorData.put(KEY_EXCEPTION_DETAIL, (Object)this.throwableToJSON((Throwable)this.errorData.get(KEY_EXCEPTION_DETAIL)));
            errorReport.put(KEY_ERROR_DATA, (Object)jsonObjectErrorData.toString());
        }
        catch (JSONException e) {
            Log.d(TAG, "Error parsing JSON in getJSONObject", e);
        }
        return errorReport;
    }
}

