/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.model;

import com.helpshift.support.model.Message;
import com.helpshift.support.res.values.HSConfig;
import com.helpshift.support.storage.IssuesDataSource;
import java.util.List;

public class Issue {
    private final String profileId;
    private final String issueId;
    private final String body;
    private final String title;
    private final String createdAt;
    private final String updatedAt;
    private int status;
    private int newMessagesCount;
    private List<Message> messageList;
    private boolean showAgentName;

    Issue(String profileId, String issueId, String body, String title, String createdAt, String updatedAt, int status, List<Message> messageList, int newMessagesCount, boolean showAgentName) {
        this.profileId = profileId;
        this.issueId = issueId;
        this.body = body;
        this.title = title;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.status = status;
        this.messageList = messageList;
        this.newMessagesCount = newMessagesCount;
        this.showAgentName = showAgentName;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getIssueId() {
        return this.issueId;
    }

    public String getBody() {
        return this.body;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    private void setNewMessagesCount(int newMessagesCount) {
        this.newMessagesCount = newMessagesCount;
    }

    public int getNewMessagesCount() {
        return this.newMessagesCount;
    }

    public void setMessageList(List<Message> messageList) {
        this.messageList = messageList;
    }

    public List<Message> getMessageList() {
        if (this.messageList == null) {
            this.setMessageList(IssuesDataSource.getMessages(this.getIssueId()));
        }
        return this.messageList;
    }

    public boolean isShowAgentName() {
        return this.showAgentName;
    }

    public static void openIssue(String issueId) {
        Issue issue = IssuesDataSource.getIssue(issueId);
        if (issue.getStatus() != 1) {
            issue.setStatus(1);
            IssuesDataSource.storeIssue(issue);
        }
    }

    public static void resetIssueCount(String issueId) {
        Issue issue = IssuesDataSource.getIssue(issueId);
        issue.setNewMessagesCount(-1);
        IssuesDataSource.storeIssue(issue);
    }

    public static String getProfileId(String issueId) {
        String profileId = "";
        Issue issue = IssuesDataSource.getIssue(issueId);
        if (issue != null) {
            profileId = issue.getProfileId();
        }
        return profileId;
    }

    public static boolean isShowAgentNameEnabled(String issueId) {
        boolean agentNameEnabledFromConfig = (Boolean)HSConfig.configData.get("san");
        if (agentNameEnabledFromConfig) {
            Issue issue = IssuesDataSource.getIssue(issueId);
            return issue.isShowAgentName();
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof Issue) {
            Issue issue = (Issue)object;
            return this.getProfileId().equals(issue.getProfileId()) && this.getIssueId().equals(issue.getIssueId()) && this.getBody().equals(issue.getBody()) && this.getTitle().equals(issue.getTitle()) && this.getCreatedAt().equals(issue.getCreatedAt()) && this.getUpdatedAt().equals(issue.getUpdatedAt()) && this.getStatus() == issue.getStatus() && this.getNewMessagesCount() == issue.getNewMessagesCount() && this.getMessageList().equals(issue.getMessageList()) && this.isShowAgentName() == issue.isShowAgentName();
        }
        return false;
    }
}

