/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.model;

import com.helpshift.support.model.Message;

public class MessageBuilder {
    private final String issueId;
    private final String messageId;
    private final String body;
    private final String origin;
    private final String type;
    private final String createdAt;
    private final String author;
    private final String meta;
    private String screenshot = "";
    private boolean messageSeen = false;
    private boolean invisible = false;
    private boolean inProgress = false;

    public MessageBuilder(String issueId, String messageId, String body, String origin, String type, String createdAt, String author, String meta) {
        this.issueId = issueId;
        this.messageId = messageId;
        this.body = body;
        this.origin = origin;
        this.type = type;
        this.createdAt = createdAt;
        this.author = author;
        this.meta = meta;
    }

    public MessageBuilder setScreenshot(String screenshot) {
        this.screenshot = screenshot;
        return this;
    }

    public MessageBuilder setMessageSeen(boolean messageSeen) {
        this.messageSeen = messageSeen;
        return this;
    }

    public MessageBuilder setInvisible(boolean invisible) {
        this.invisible = invisible;
        return this;
    }

    public MessageBuilder setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
        return this;
    }

    public Message build() {
        return new Message(this.issueId, this.messageId, this.body, this.origin, this.type, this.createdAt, this.author, this.meta, this.screenshot, this.messageSeen, this.invisible, this.inProgress);
    }
}

