/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.res.values;

import android.util.Log;
import com.helpshift.support.HSStorage;
import com.helpshift.util.HelpshiftContext;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class HSConfig {
    public static final String TAG = "HelpShiftDebug";
    public static Map<String, String> themeData = new HashMap<String, String>();
    public static Map<String, Object> configData;

    public static void updateThemeData(JSONObject theme) throws JSONException {
        themeData.put("title", theme.getString("title"));
        themeData.put("sp", theme.getString("sp"));
        themeData.put("hc", theme.getString("hc"));
        themeData.put("tc", theme.getString("tc"));
        themeData.put("hl", theme.getString("hl"));
        HSStorage storage = new HSStorage(HelpshiftContext.getApplicationContext());
        storage.updateDisableHelpshiftBranding();
    }

    public static void updateConfig(JSONObject config) {
        configData.put("rurl", config.optString("rurl", ""));
        configData.put("bcl", config.optInt("bcl", 10));
        configData.put("dbgl", config.optInt("dbgl", 25));
        configData.put("pr", config.optJSONObject("pr"));
        configData.put("pfe", config.optBoolean("pfe", true));
        configData.put("rne", config.optBoolean("rne", false));
        configData.put("dia", config.optBoolean("dia", false));
        configData.put("csat", config.optBoolean("csat", false));
        configData.put("san", config.optBoolean("san", true));
        try {
            if (config.has("t")) {
                HSConfig.updateThemeData(config.getJSONObject("t"));
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)e.toString(), (Throwable)e);
        }
    }

    static {
        themeData.put("title", "Help");
        themeData.put("sp", "Describe your problem");
        themeData.put("hc", "516B90");
        themeData.put("tc", "535353");
        themeData.put("hl", "true");
        configData = new HashMap<String, Object>();
        configData.put("bcl", 10);
        configData.put("dbgl", 0);
        configData.put("rurl", "");
        configData.put("t", themeData);
        configData.put("pfe", true);
        configData.put("pr", null);
        configData.put("rne", false);
        configData.put("dia", false);
        configData.put("csat", false);
        configData.put("san", true);
    }
}

