/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.helpshift.support.model.ErrorReport;
import com.helpshift.support.storage.ErrorReportsDBHelper;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HelpshiftContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ErrorReportsDataSource {
    private static final ErrorReportsDBHelper helper = new ErrorReportsDBHelper(HelpshiftContext.getApplicationContext());
    private static SQLiteDatabase database;

    private ErrorReportsDataSource() {
    }

    private static void write() {
        database = helper.getWritableDatabase();
    }

    private static void read() {
        database = helper.getReadableDatabase();
    }

    private static void close() {
        database.close();
    }

    private static ContentValues reportToContentValues(ErrorReport errorReport) {
        ContentValues values = new ContentValues();
        values.put("report_id", errorReport.getReportId());
        values.put("report_type", errorReport.getReportType());
        values.put("device_info", errorReport.getDeviceInfo().toString());
        values.put("hs_funnel", errorReport.getHelpshiftContext().get("funnel"));
        values.put("bread_crumbs", errorReport.getHelpshiftContext().get("bread_crumbs"));
        values.put("profile_id", errorReport.getConversationContext().get("profile_id"));
        values.put("active_conversation_id", errorReport.getConversationContext().get("active_conversation_id"));
        values.put("active_message_ids", errorReport.getConversationContext().get("active_message_ids"));
        values.put("thread_info", errorReport.getErrorData().get("thread_info").toString());
        values.put("timestamp", errorReport.getErrorData().get("timestamp").toString());
        byte[] bytesExceptionDetail = ErrorReport.throwableToBytes((Throwable)errorReport.getErrorData().get("exception_detail"));
        values.put("exception_detail", bytesExceptionDetail);
        return values;
    }

    private static ErrorReport cursorToErrorReport(Cursor cursor) {
        ErrorReport errorReport = new ErrorReport();
        errorReport.setReportId(cursor.getString(cursor.getColumnIndex("report_id")));
        errorReport.setReportType(cursor.getString(cursor.getColumnIndex("report_type")));
        errorReport.setDeviceInfo(cursor.getString(cursor.getColumnIndex("device_info")));
        HashMap<String, String> mapHelpshiftContext = new HashMap<String, String>();
        mapHelpshiftContext.put("funnel", cursor.getString(cursor.getColumnIndex("hs_funnel")));
        mapHelpshiftContext.put("bread_crumbs", cursor.getString(cursor.getColumnIndex("bread_crumbs")));
        errorReport.setHelpshiftContext(mapHelpshiftContext);
        HashMap<String, String> mapConversationContext = new HashMap<String, String>();
        mapConversationContext.put("profile_id", cursor.getString(cursor.getColumnIndex("profile_id")));
        mapConversationContext.put("active_conversation_id", cursor.getString(cursor.getColumnIndex("active_conversation_id")));
        mapConversationContext.put("active_message_ids", cursor.getString(cursor.getColumnIndex("active_message_ids")));
        errorReport.setConversationContext(mapConversationContext);
        HashMap<String, Object> mapErrorData = new HashMap<String, Object>();
        mapErrorData.put("thread_info", cursor.getString(cursor.getColumnIndex("thread_info")));
        mapErrorData.put("timestamp", cursor.getString(cursor.getColumnIndex("timestamp")));
        Throwable throwable = ErrorReport.bytesToThrowable(cursor.getBlob(cursor.getColumnIndex("exception_detail")));
        mapErrorData.put("exception_detail", throwable);
        errorReport.setErrorData(mapErrorData);
        return errorReport;
    }

    private static void storeReportUnsafe(ErrorReport errorReport) {
        if (errorReport == null) {
            return;
        }
        String whereClause = "report_id=?";
        String[] whereArgs = new String[]{errorReport.getReportId()};
        if (DatabaseUtils.exists(database, "error_reports", whereClause, whereArgs)) {
            database.update("error_reports", ErrorReportsDataSource.reportToContentValues(errorReport), whereClause, whereArgs);
        } else {
            database.insert("error_reports", null, ErrorReportsDataSource.reportToContentValues(errorReport));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeErrorReport(ErrorReport errorReport) {
        if (errorReport == null) {
            return;
        }
        ErrorReportsDBHelper errorReportsDBHelper = helper;
        synchronized (errorReportsDBHelper) {
            ErrorReportsDataSource.write();
            ErrorReportsDataSource.storeReportUnsafe(errorReport);
            ErrorReportsDataSource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ErrorReport> getErrorReportsByType(String reportType) {
        ArrayList<ErrorReport> errorReports = new ArrayList<ErrorReport>();
        if (TextUtils.isEmpty((CharSequence)reportType)) {
            return errorReports;
        }
        String whereClause = "report_type=?";
        String[] whereArgs = new String[]{reportType};
        ErrorReportsDBHelper errorReportsDBHelper = helper;
        synchronized (errorReportsDBHelper) {
            ErrorReportsDataSource.read();
            Cursor cursor = database.query("error_reports", null, whereClause, whereArgs, null, null, null);
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    errorReports.add(ErrorReportsDataSource.cursorToErrorReport(cursor));
                    cursor.moveToNext();
                }
            }
            cursor.close();
            ErrorReportsDataSource.close();
        }
        return errorReports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasReports() {
        long rows;
        ErrorReportsDBHelper errorReportsDBHelper = helper;
        synchronized (errorReportsDBHelper) {
            ErrorReportsDataSource.read();
            rows = android.database.DatabaseUtils.queryNumEntries((SQLiteDatabase)database, (String)"error_reports");
            ErrorReportsDataSource.close();
        }
        return rows != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteErrorReports(List<String> reportIds) {
        if (reportIds == null || reportIds.isEmpty()) {
            return;
        }
        ErrorReportsDBHelper errorReportsDBHelper = helper;
        synchronized (errorReportsDBHelper) {
            ErrorReportsDataSource.write();
            database.beginTransaction();
            for (String reportId : reportIds) {
                ErrorReportsDataSource.deleteErrorReportUnsafe(reportId);
            }
            database.setTransactionSuccessful();
            database.endTransaction();
            ErrorReportsDataSource.close();
        }
    }

    private static void deleteErrorReportUnsafe(String reportId) {
        if (TextUtils.isEmpty((CharSequence)reportId)) {
            return;
        }
        String whereClause = "report_id=?";
        String[] whereArgs = new String[]{reportId};
        database.delete("error_reports", whereClause, whereArgs);
    }
}

