/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.helpshift.support.Faq;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.Log;
import com.helpshift.support.constants.FaqsColumns;
import com.helpshift.support.storage.FaqDAO;
import com.helpshift.support.storage.FaqsDBHelper;
import com.helpshift.util.HSJSONUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FaqsDataSource
implements FaqDAO {
    private static final String TAG = "HelpShiftDebug";
    private final FaqsDBHelper dbHelper = FaqsDBHelper.getInstance();
    private SQLiteDatabase database;

    public void write() {
        this.database = this.dbHelper.getWritableDatabase();
    }

    public void read() {
        this.database = this.dbHelper.getReadableDatabase();
    }

    public void close() {
        this.dbHelper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDB() {
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            this.read();
            this.dbHelper.dropTables(this.database);
            this.dbHelper.onCreate(this.database);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFaq(Faq faq) {
        ContentValues values = FaqsDataSource.faqToContentValues(faq);
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            this.write();
            this.database.insert("faqs", null, values);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFaq(Faq faq) {
        ContentValues values = FaqsDataSource.faqToContentValues(faq);
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            this.write();
            this.database.update("faqs", values, "question_id = ?", new String[]{faq.getId()});
            this.close();
        }
    }

    @Override
    public void addFaq(Faq faq) {
        if (this.getFaq(faq.getPublishId()) == null) {
            this.createFaq(faq);
        } else {
            this.updateFaq(faq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Faq getFaq(String publishId) {
        if (TextUtils.isEmpty((CharSequence)publishId)) {
            return new Faq();
        }
        Faq faq = null;
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            this.read();
            Cursor cursor = this.database.query("faqs", null, "publish_id = ?", new String[]{publishId}, null, null, null);
            if (cursor.moveToFirst()) {
                faq = FaqsDataSource.cursorToFaq(cursor);
            }
            cursor.close();
            this.close();
        }
        return faq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Faq> getFaqsDataForSection(String sectionPublishId) {
        if (TextUtils.isEmpty((CharSequence)sectionPublishId)) {
            return new ArrayList<Faq>();
        }
        ArrayList<Faq> faqs = new ArrayList<Faq>();
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            this.read();
            Cursor cursor = this.database.query("faqs", null, "section_id = ?", new String[]{sectionPublishId}, null, null, null);
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    Faq faq = FaqsDataSource.cursorToFaq(cursor);
                    faqs.add(faq);
                    cursor.moveToNext();
                }
            }
            cursor.close();
            this.close();
        }
        return faqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Faq> getFaqsForSection(String sectionPublishId) {
        if (TextUtils.isEmpty((CharSequence)sectionPublishId)) {
            return new ArrayList<Faq>();
        }
        ArrayList<Faq> faqs = new ArrayList<Faq>();
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            this.read();
            Cursor cursor = this.database.query("faqs", FaqsColumns.UI_COLUMNS, "section_id = ?", new String[]{sectionPublishId}, null, null, null);
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    Faq faq = FaqsDataSource.cursorToFaqForUI(cursor);
                    faqs.add(faq);
                    cursor.moveToNext();
                }
            }
            cursor.close();
            this.close();
        }
        return faqs;
    }

    @Override
    public List<Faq> getFilteredFaqs(List<Faq> faqs, FaqTagFilter faqTagFilter) {
        if (faqTagFilter == null) {
            return faqs;
        }
        switch (faqTagFilter.getOperator()) {
            case AND: {
                return this.getANDFilteredFaqs(faqs, faqTagFilter);
            }
            case OR: {
                return this.getORFilteredFaqs(faqs, faqTagFilter);
            }
            case NOT: {
                return this.getNOTFilteredFaqs(faqs, faqTagFilter);
            }
            case UNDEFINED: {
                return faqs;
            }
        }
        return faqs;
    }

    @Override
    public List<Faq> getFaqsForSection(String sectionPublishId, FaqTagFilter faqTagFilter) {
        List<Faq> faqsForSection = this.getFaqsDataForSection(sectionPublishId);
        return this.getFilteredFaqs(faqsForSection, faqTagFilter);
    }

    private List<Faq> getANDFilteredFaqs(List<Faq> faqs, FaqTagFilter faqTagFilter) {
        ArrayList<Faq> filteredFaqs = new ArrayList<Faq>();
        for (Faq faq : faqs) {
            ArrayList<String> filterTags = new ArrayList<String>(Arrays.asList(faqTagFilter.getTags()));
            List<String> categoryTags = faq.getCategoryTags();
            filterTags.removeAll(categoryTags);
            if (!filterTags.isEmpty()) continue;
            filteredFaqs.add(faq);
        }
        return filteredFaqs;
    }

    private List<Faq> getORFilteredFaqs(List<Faq> faqs, FaqTagFilter faqTagFilter) {
        ArrayList<Faq> filteredFaqs = new ArrayList<Faq>();
        for (Faq faq : faqs) {
            List<String> categoryTags;
            ArrayList<String> filterTags = new ArrayList<String>(Arrays.asList(faqTagFilter.getTags()));
            if (!filterTags.removeAll(categoryTags = faq.getCategoryTags())) continue;
            filteredFaqs.add(faq);
        }
        return filteredFaqs;
    }

    private List<Faq> getNOTFilteredFaqs(List<Faq> faqs, FaqTagFilter faqTagFilter) {
        ArrayList<Faq> filteredFaqs = new ArrayList<Faq>();
        for (Faq faq : faqs) {
            List<String> categoryTags;
            ArrayList<String> filterTags = new ArrayList<String>(Arrays.asList(faqTagFilter.getTags()));
            if (filterTags.removeAll(categoryTags = faq.getCategoryTags())) continue;
            filteredFaqs.add(faq);
        }
        return filteredFaqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setIsHelpful(String questionId, Boolean state) {
        int returnVal = 0;
        if (TextUtils.isEmpty((CharSequence)questionId)) {
            return returnVal;
        }
        ContentValues values = new ContentValues();
        values.put("helpful", Integer.valueOf(state != false ? 1 : -1));
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            this.write();
            returnVal = this.database.update("faqs", values, "question_id = ?", new String[]{questionId});
            this.close();
        }
        return returnVal;
    }

    public static void addFaqsUnsafe(SQLiteDatabase database, String sectionPublishId, JSONArray faqs) {
        try {
            for (int j = 0; j < faqs.length(); ++j) {
                JSONObject faq = faqs.getJSONObject(j);
                database.insert("faqs", null, FaqsDataSource.faqToContentValues(sectionPublishId, faq));
            }
        }
        catch (JSONException e) {
            Log.d(TAG, "JSONException", e);
        }
    }

    private static Faq cursorToFaq(Cursor cursor) {
        return new Faq(cursor.getLong(0), cursor.getString(1), cursor.getString(2), cursor.getString(3), cursor.getString(4), cursor.getString(5), cursor.getInt(6), cursor.getInt(7) == 1, HSJSONUtils.jsonToStringArrayList(cursor.getString(8)), HSJSONUtils.jsonToStringArrayList(cursor.getString(9)));
    }

    private static Faq cursorToFaqForUI(Cursor cursor) {
        return new Faq(0L, cursor.getString(0), cursor.getString(1), cursor.getString(2), cursor.getString(3), "", 0, false, new ArrayList<String>(), new ArrayList<String>());
    }

    private static ContentValues faqToContentValues(Faq faq) {
        ContentValues values = new ContentValues();
        values.put("question_id", faq.getId());
        values.put("publish_id", faq.getPublishId());
        values.put("section_id", faq.getSectionPublishId());
        values.put("title", faq.getTitle());
        values.put("body", faq.getBody());
        values.put("helpful", Integer.valueOf(faq.getIsHelpful()));
        values.put("rtl", faq.getIsRtl());
        values.put("tags", String.valueOf(new JSONArray(faq.getTags())));
        values.put("c_tags", String.valueOf(new JSONArray(faq.getCategoryTags())));
        return values;
    }

    private static ContentValues faqToContentValues(String sectionPublishId, JSONObject faq) throws JSONException {
        ContentValues values = new ContentValues();
        values.put("question_id", faq.getString("id"));
        values.put("publish_id", faq.getString("publish_id"));
        values.put("section_id", sectionPublishId);
        values.put("title", faq.getString("title"));
        values.put("body", faq.getString("body"));
        values.put("helpful", Integer.valueOf(0));
        values.put("rtl", Boolean.valueOf(faq.getString("is_rtl").equals("true")));
        values.put("tags", faq.has("stags") ? faq.optJSONArray("stags").toString() : new JSONArray().toString());
        values.put("c_tags", faq.has("issue_tags") ? faq.optJSONArray("issue_tags").toString() : new JSONArray().toString());
        return values;
    }
}

