/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.helpshift.support.model.Issue;
import com.helpshift.support.model.IssueBuilder;
import com.helpshift.support.model.Message;
import com.helpshift.support.model.MessageBuilder;
import com.helpshift.support.storage.IssuesDBHelper;
import com.helpshift.support.util.ListUtils;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HelpshiftContext;
import java.util.ArrayList;
import java.util.List;

public class IssuesDataSource {
    private static final IssuesDBHelper helper = new IssuesDBHelper(HelpshiftContext.getApplicationContext());
    private static SQLiteDatabase database;

    private static void write() {
        database = helper.getWritableDatabase();
    }

    private static void read() {
        database = helper.getReadableDatabase();
    }

    private static void close() {
        database.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDB() {
        IssuesDBHelper issuesDBHelper = helper;
        synchronized (issuesDBHelper) {
            IssuesDataSource.read();
            IssuesDataSource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDB() {
        IssuesDBHelper issuesDBHelper = helper;
        synchronized (issuesDBHelper) {
            IssuesDataSource.read();
            helper.dropTables(database);
            helper.onCreate(database);
            IssuesDataSource.close();
        }
    }

    public static int storeIssue(Issue issue) {
        ArrayList<Issue> issueList = new ArrayList<Issue>();
        issueList.add(issue);
        return IssuesDataSource.storeIssues(issueList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int storeIssues(List<Issue> issueList) {
        int newIssuesCount = 0;
        if (ListUtils.isEmpty(issueList)) {
            return newIssuesCount;
        }
        IssuesDBHelper issuesDBHelper = helper;
        synchronized (issuesDBHelper) {
            IssuesDataSource.write();
            database.beginTransaction();
            String whereClause = "issue_id=?";
            for (Issue issue : issueList) {
                int newMessagesCount = IssuesDataSource.insertMessagesUnsafe(issue.getMessageList());
                String[] whereArgs = new String[]{issue.getIssueId()};
                if (DatabaseUtils.exists(database, "issues", whereClause, whereArgs)) {
                    if (issue.getNewMessagesCount() != -1) {
                        newMessagesCount += IssuesDataSource.getCurrentNewMessagesCount(whereClause, whereArgs);
                    }
                    database.update("issues", IssuesDataSource.issueToContentValue(issue, newMessagesCount), whereClause, whereArgs);
                    continue;
                }
                database.insert("issues", null, IssuesDataSource.issueToContentValue(issue, 0));
                ++newIssuesCount;
            }
            database.setTransactionSuccessful();
            database.endTransaction();
            IssuesDataSource.close();
        }
        return newIssuesCount;
    }

    private static int getCurrentNewMessagesCount(String whereClause, String[] whereArgs) {
        int currentNewMessagesCount = 0;
        Cursor cursor = database.query("issues", new String[]{"new_message_count"}, whereClause, whereArgs, null, null, null);
        if (cursor.moveToFirst()) {
            currentNewMessagesCount = cursor.getInt(cursor.getColumnIndex("new_message_count"));
        }
        cursor.close();
        return currentNewMessagesCount;
    }

    private static ContentValues issueToContentValue(Issue issue, int newMessagesCount) {
        ContentValues values = new ContentValues();
        values.put("profile_id", issue.getProfileId());
        values.put("issue_id", issue.getIssueId());
        values.put("body", issue.getBody());
        values.put("title", issue.getTitle());
        values.put("created_at", issue.getCreatedAt());
        values.put("updated_at", issue.getUpdatedAt());
        values.put("status", Integer.valueOf(issue.getStatus()));
        values.put("new_message_count", Integer.valueOf(newMessagesCount));
        values.put("show_agent_name", Integer.valueOf(issue.isShowAgentName() ? 1 : 0));
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Issue getIssue(String issueId) {
        Issue issue = null;
        IssuesDBHelper issuesDBHelper = helper;
        synchronized (issuesDBHelper) {
            IssuesDataSource.read();
            Cursor cursor = database.query("issues", null, "issue_id=?", new String[]{issueId}, null, null, null);
            if (cursor.moveToFirst()) {
                issue = IssuesDataSource.cursorToIssue(cursor);
            }
            cursor.close();
            IssuesDataSource.close();
        }
        if (issue != null) {
            issue.getMessageList();
        }
        return issue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Issue> getIssues(String profileId) {
        ArrayList<Issue> issueList = new ArrayList<Issue>();
        if (TextUtils.isEmpty((CharSequence)profileId)) {
            return issueList;
        }
        IssuesDBHelper issuesDBHelper = helper;
        synchronized (issuesDBHelper) {
            IssuesDataSource.read();
            Cursor cursor = database.query("issues", null, "profile_id=?", new String[]{profileId}, null, null, null);
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    issueList.add(IssuesDataSource.cursorToIssue(cursor));
                    cursor.moveToNext();
                }
            }
            cursor.close();
            IssuesDataSource.close();
        }
        return issueList;
    }

    private static Issue cursorToIssue(Cursor cursor) {
        String profileId = cursor.getString(cursor.getColumnIndex("profile_id"));
        String issueId = cursor.getString(cursor.getColumnIndex("issue_id"));
        String body = cursor.getString(cursor.getColumnIndex("body"));
        String title = cursor.getString(cursor.getColumnIndex("title"));
        String createdAt = cursor.getString(cursor.getColumnIndex("created_at"));
        String updatedAt = cursor.getString(cursor.getColumnIndex("updated_at"));
        int status = cursor.getInt(cursor.getColumnIndex("status"));
        int newMessageCount = cursor.getInt(cursor.getColumnIndex("new_message_count"));
        int showAgentName = cursor.getInt(cursor.getColumnIndex("show_agent_name"));
        IssueBuilder issueBuilder = new IssueBuilder(profileId, issueId, body, title, createdAt, updatedAt, status, showAgentName == 1);
        return issueBuilder.setNewMessagesCount(newMessageCount).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int storeMessages(List<Message> messageList) {
        int newMessagesCount = 0;
        if (ListUtils.isEmpty(messageList)) {
            return newMessagesCount;
        }
        IssuesDBHelper issuesDBHelper = helper;
        synchronized (issuesDBHelper) {
            IssuesDataSource.write();
            database.beginTransaction();
            newMessagesCount = IssuesDataSource.insertMessagesUnsafe(messageList);
            database.setTransactionSuccessful();
            database.endTransaction();
            IssuesDataSource.close();
        }
        return newMessagesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int storeMessage(Message message) {
        int newMessageCount = 0;
        IssuesDBHelper issuesDBHelper = helper;
        synchronized (issuesDBHelper) {
            IssuesDataSource.write();
            IssuesDataSource.close();
        }
        return newMessageCount += IssuesDataSource.insertMessageUnsafe(message);
    }

    private static int insertMessagesUnsafe(List<Message> messageList) {
        int newMessagesCount = 0;
        for (Message message : messageList) {
            newMessagesCount += IssuesDataSource.insertMessageUnsafe(message);
        }
        return newMessagesCount;
    }

    private static int insertMessageUnsafe(Message message) {
        String whereClause = "message_id=?";
        String[] whereArgs = new String[]{message.getMessageId()};
        if (DatabaseUtils.exists(database, "messages", whereClause, whereArgs)) {
            database.update("messages", IssuesDataSource.messageToContentValues(message), whereClause, whereArgs);
        } else {
            database.insert("messages", null, IssuesDataSource.messageToContentValues(message));
            if (message.getOrigin().equals("admin")) {
                return 1;
            }
        }
        return 0;
    }

    private static ContentValues messageToContentValues(Message message) {
        ContentValues values = new ContentValues();
        values.put("issue_id", message.getIssueId());
        values.put("message_id", message.getMessageId());
        values.put("body", message.getBody());
        values.put("origin", message.getOrigin());
        values.put("type", message.getType());
        values.put("created_at", message.getCreatedAt());
        values.put("author", message.getAuthor());
        values.put("meta", message.getMeta());
        values.put("screenshot", message.getScreenshot());
        values.put("message_seen", Integer.valueOf(message.isMessageSeen() ? 1 : 0));
        values.put("invisible", Integer.valueOf(message.isInvisible() ? 1 : 0));
        values.put("in_progress", Integer.valueOf(message.isInProgress() ? 1 : 0));
        return values;
    }

    public static List<Message> getMessages(String issueId) {
        if (TextUtils.isEmpty((CharSequence)issueId)) {
            return new ArrayList<Message>();
        }
        return IssuesDataSource.getMessages("issue_id=?", new String[]{issueId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getMessageIds(String issueId) {
        if (TextUtils.isEmpty((CharSequence)issueId)) {
            return new ArrayList<String>();
        }
        ArrayList<String> messageIds = new ArrayList<String>();
        String whereClause = "issue_id=?";
        String[] whereArgs = new String[]{issueId};
        IssuesDBHelper issuesDBHelper = helper;
        synchronized (issuesDBHelper) {
            IssuesDataSource.read();
            Cursor cursor = database.query("messages", new String[]{"message_id"}, whereClause, whereArgs, null, null, null);
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    String messageId = cursor.getString(cursor.getColumnIndex("message_id"));
                    messageIds.add(messageId);
                    cursor.moveToNext();
                }
            }
            cursor.close();
            IssuesDataSource.close();
        }
        return messageIds;
    }

    public static List<Message> getUnseenMessages(String issueId) {
        if (TextUtils.isEmpty((CharSequence)issueId)) {
            return new ArrayList<Message>();
        }
        String whereClause = "issue_id=? AND message_seen=? AND origin=?";
        String[] whereArgs = new String[]{issueId, Integer.toString(0), "admin"};
        return IssuesDataSource.getMessages(whereClause, whereArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Message> getMessages(String whereClause, String[] whereArgs) {
        ArrayList<Message> messageList = new ArrayList<Message>();
        IssuesDBHelper issuesDBHelper = helper;
        synchronized (issuesDBHelper) {
            IssuesDataSource.read();
            Cursor cursor = database.query("messages", null, whereClause, whereArgs, null, null, null);
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    messageList.add(IssuesDataSource.cursorToMessage(cursor));
                    cursor.moveToNext();
                }
            }
            cursor.close();
            IssuesDataSource.close();
        }
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message getMessage(String messageId) {
        Message message = null;
        IssuesDBHelper issuesDBHelper = helper;
        synchronized (issuesDBHelper) {
            IssuesDataSource.read();
            Cursor cursor = database.query("messages", null, "message_id=?", new String[]{messageId}, null, null, null);
            if (cursor.moveToFirst()) {
                message = IssuesDataSource.cursorToMessage(cursor);
            }
            cursor.close();
            IssuesDataSource.close();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMessage(String messageId) {
        IssuesDBHelper issuesDBHelper = helper;
        synchronized (issuesDBHelper) {
            IssuesDataSource.write();
            database.delete("messages", "message_id=?", new String[]{messageId});
            IssuesDataSource.close();
        }
    }

    private static Message cursorToMessage(Cursor cursor) {
        String issueId = cursor.getString(cursor.getColumnIndex("issue_id"));
        String messageId = cursor.getString(cursor.getColumnIndex("message_id"));
        String body = cursor.getString(cursor.getColumnIndex("body"));
        String origin = cursor.getString(cursor.getColumnIndex("origin"));
        String type = cursor.getString(cursor.getColumnIndex("type"));
        String createdAt = cursor.getString(cursor.getColumnIndex("created_at"));
        String author = cursor.getString(cursor.getColumnIndex("author"));
        String meta = cursor.getString(cursor.getColumnIndex("meta"));
        String screenshot = cursor.getString(cursor.getColumnIndex("screenshot"));
        int messageSeen = cursor.getInt(cursor.getColumnIndex("message_seen"));
        int invisible = cursor.getInt(cursor.getColumnIndex("invisible"));
        int inProgress = cursor.getInt(cursor.getColumnIndex("in_progress"));
        MessageBuilder messageBuilder = new MessageBuilder(issueId, messageId, body, origin, type, createdAt, author, meta);
        return messageBuilder.setScreenshot(screenshot).setMessageSeen(messageSeen == 1).setInvisible(invisible == 1).setInProgress(inProgress == 1).build();
    }
}

