/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.helpshift.support.model.Profile;
import com.helpshift.support.storage.ProfilesDBHelper;
import com.helpshift.util.DBUtil;

public class ProfilesDataSource {
    private static final String TAG = "HelpShiftDebug";
    private SQLiteDatabase database;
    private ProfilesDBHelper dbHelper;
    private String[] allColumns = new String[]{"_id", "IDENTIFIER", "profile_id", "name", "email", "salt"};

    public ProfilesDataSource(Context context) {
        this.dbHelper = new ProfilesDBHelper(context);
    }

    public void write() {
        this.database = this.dbHelper.getWritableDatabase();
    }

    public void read() {
        this.database = this.dbHelper.getReadableDatabase();
    }

    public void close() {
        this.dbHelper.close();
    }

    public synchronized void addProfile(Profile profile) {
        if (this.getProfile(profile.getIdentifier()) == null) {
            this.createProfile(profile);
        } else {
            this.updateProfile(profile);
        }
        DBUtil.backupDatabase("__hs__db_profiles");
    }

    public synchronized void createProfile(Profile profile) {
        this.write();
        ContentValues values = this.profileToContentValues(profile);
        this.database.insert("profiles", null, values);
        this.close();
    }

    public synchronized void updateProfile(Profile profile) {
        this.write();
        ContentValues values = this.profileToContentValues(profile);
        this.database.update("profiles", values, "IDENTIFIER = '" + profile.getIdentifier() + "'", null);
        this.close();
    }

    public synchronized Profile getProfile(String identifier) {
        this.read();
        Cursor cursor = this.database.query("profiles", this.allColumns, "IDENTIFIER = '" + identifier + "'", null, null, null, null);
        Profile profile = null;
        if (cursor.moveToFirst()) {
            profile = this.cursorToProfile(cursor);
        }
        cursor.close();
        this.close();
        return profile;
    }

    private Profile cursorToProfile(Cursor cursor) {
        Profile profile = new Profile(cursor.getString(1));
        profile.setId(cursor.getLong(0));
        profile.setProfileId(cursor.getString(2));
        profile.setName(cursor.getString(3));
        profile.setEmail(cursor.getString(4));
        profile.setSalt(cursor.getString(5));
        return profile;
    }

    private ContentValues profileToContentValues(Profile profile) {
        ContentValues values = new ContentValues();
        values.put("IDENTIFIER", profile.getIdentifier());
        values.put("profile_id", profile.getProfileId());
        values.put("name", profile.getName());
        values.put("email", profile.getEmail());
        values.put("salt", profile.getSalt());
        return values;
    }
}

