/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.helpshift.support.Faq;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.Log;
import com.helpshift.support.Section;
import com.helpshift.support.storage.FaqDAO;
import com.helpshift.support.storage.FaqsDBHelper;
import com.helpshift.support.storage.FaqsDataSource;
import com.helpshift.support.storage.SectionDAO;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SectionsDataSource
implements SectionDAO {
    private static final String TAG = "HelpShiftDebug";
    private final FaqsDBHelper dbHelper = FaqsDBHelper.getInstance();
    private SQLiteDatabase database;
    private FaqDAO faqDAO = new FaqsDataSource();

    private static Section cursorToSection(Cursor cursor) {
        return new Section(cursor.getLong(0), cursor.getString(1), cursor.getString(3), cursor.getString(2));
    }

    private static ContentValues sectionToContentValues(JSONObject section) throws JSONException {
        ContentValues values = new ContentValues();
        values.put("title", section.getString("title"));
        values.put("publish_id", section.getString("publish_id"));
        values.put("section_id", section.getString("id"));
        return values;
    }

    public void write() {
        this.database = this.dbHelper.getWritableDatabase();
    }

    public void read() {
        this.database = this.dbHelper.getReadableDatabase();
    }

    public void close() {
        this.dbHelper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSections(JSONArray sections) {
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            this.write();
            try {
                this.database.beginTransaction();
                for (int i = 0; i < sections.length(); ++i) {
                    JSONObject section = sections.getJSONObject(i);
                    this.database.insert("sections", null, SectionsDataSource.sectionToContentValues(section));
                    JSONArray faqs = section.optJSONArray("faqs");
                    if (faqs == null) continue;
                    String sectionPublishId = section.getString("publish_id");
                    FaqsDataSource.addFaqsUnsafe(this.database, sectionPublishId, faqs);
                }
                this.database.setTransactionSuccessful();
            }
            catch (JSONException e) {
                Log.d(TAG, "JSONException", e);
            }
            finally {
                this.database.endTransaction();
            }
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Section getSection(String publishId) {
        if (publishId == null || publishId.equals("")) {
            return new Section();
        }
        Section section = null;
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            this.read();
            Cursor cursor = this.database.query("sections", null, "publish_id = ?", new String[]{publishId}, null, null, null);
            cursor.moveToFirst();
            if (!cursor.isAfterLast()) {
                section = SectionsDataSource.cursorToSection(cursor);
            }
            cursor.close();
            this.close();
        }
        return section;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Section> getAllSections() {
        ArrayList<Section> sections = new ArrayList<Section>();
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            this.read();
            Cursor cursor = this.database.query("sections", null, null, null, null, null, null);
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                Section section = SectionsDataSource.cursorToSection(cursor);
                sections.add(section);
                cursor.moveToNext();
            }
            cursor.close();
            this.close();
        }
        return sections;
    }

    @Override
    public List<Section> getAllSections(FaqTagFilter faqTagFilter) {
        List<Section> allSections = this.getAllSections();
        if (faqTagFilter == null) {
            return allSections;
        }
        ArrayList<Section> filteredSections = new ArrayList<Section>();
        for (Section section : allSections) {
            List<Faq> faqsForSection = this.faqDAO.getFaqsForSection(section.getPublishId(), faqTagFilter);
            if (faqsForSection.isEmpty()) continue;
            filteredSections.add(section);
        }
        return filteredSections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSectionsData() {
        FaqsDBHelper faqsDBHelper = this.dbHelper;
        synchronized (faqsDBHelper) {
            this.write();
            this.dbHelper.dropTables(this.database);
            this.dbHelper.onCreate(this.database);
            this.close();
        }
    }
}

