/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.helpshift.R;
import com.helpshift.support.D;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSStorage;
import com.helpshift.support.model.Issue;
import com.helpshift.support.model.Message;
import com.helpshift.support.storage.IssuesDataSource;
import com.helpshift.support.util.IssuesUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.support.viewstructs.HSMsg;
import com.helpshift.util.HSFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class AttachmentUtil {
    public static final String LOCAL_RSC_MSG_ID_PREFIX = "localRscMessage_";
    public static final int SCREENSHOT_ATTACH_REQ_CODE = 0;
    public static final int ATTACH_SCR_ASK_PERMISSION_REQ_CODE = 89;
    public static final int DOWNLOAD_ATTACHMENT_ASK_PERMSSION_REQ_CODE = 90;
    private static final String TAG = "HelpShiftDebug";
    private static final String FILE_TYPE_AUDIO = "audio/";
    private static final String FILE_TYPE_VIDEO = "video/";
    private static final String FILE_TYPE_PDF = "application/pdf";
    private static final String FILE_TYPE_RTF = "text/rtf";
    private static final String FILE_TYPE_CSV = "text/csv";
    private static final String FILE_TYPE_TEXT = "text/";
    private static final String FILE_TYPE_MS_OFFICE_SUBSCRIPT = "vnd.openxmlformats-officedocument";

    private static void showScreenshotErrorToast(Activity activity) {
        SnackbarUtil.showSnackbar(activity.getWindow().getDecorView(), R.string.hs__screenshot_cloud_attach_error, -1);
    }

    private static void showScreenshotNotOfImageTypeErrorToast(Activity activity) {
        SnackbarUtil.showSnackbar(activity.getWindow().getDecorView(), R.string.hs__screenshot_upload_error_msg, -1);
    }

    private static String getPath(Activity activity, Uri selectedImageUri) {
        String[] projection = new String[]{"_data"};
        Cursor cursor = activity.managedQuery(selectedImageUri, projection, null, null, null);
        int column_index = cursor.getColumnIndexOrThrow("_data");
        cursor.moveToFirst();
        return cursor.getString(column_index);
    }

    public static String getPath(Activity activity, Intent dataIntent) {
        File screenshotFile;
        String screenshot;
        Uri ssUri = dataIntent.getData();
        try {
            screenshot = AttachmentUtil.getPath(activity, ssUri);
            screenshotFile = new File(screenshot);
        }
        catch (NullPointerException e) {
            AttachmentUtil.showScreenshotErrorToast(activity);
            return null;
        }
        if (!screenshotFile.exists()) {
            AttachmentUtil.showScreenshotErrorToast(activity);
            return null;
        }
        Long screenshotLimit = 0x500000L;
        if (screenshotFile.length() > screenshotLimit) {
            String errorString = String.format(activity.getResources().getString(D.string.hs__screenshot_limit_error), Float.valueOf((float)screenshotLimit.longValue() / 1048576.0f));
            SnackbarUtil.showSnackbar(activity.getWindow().getDecorView(), errorString, -1);
            return null;
        }
        return screenshot;
    }

    public static Bitmap getBitmap(String path, int scale) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = 4;
        Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        if (scale > 0 && bitmap != null) {
            float ratio = (float)options.outHeight / (float)options.outWidth;
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)scale, (int)((int)(ratio * (float)scale)), (boolean)false);
        }
        return bitmap;
    }

    public static Bitmap getUnscaledBitmap(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }

    public static Bitmap getBitmapFromDrawable(Context context, int resourceId) {
        return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyAttachment(Context context, HSApiData hsApiData, String filename, String messageId, int attachId) throws IOException {
        InputStream input = null;
        FileOutputStream output = null;
        try {
            String outputName = messageId + attachId + "-thumbnail";
            File outputFile = new File(context.getFilesDir(), outputName);
            String fname = outputFile.getAbsolutePath();
            if (!outputFile.exists()) {
                int read;
                hsApiData.storeFile(outputName);
                input = new FileInputStream(new File(filename));
                output = context.openFileOutput(outputName, 0);
                byte[] data = new byte[1024];
                while ((read = input.read(data)) != -1) {
                    output.write(data, 0, read);
                }
            }
            String string2 = fname;
            return string2;
        }
        catch (NullPointerException e) {
            Log.d((String)TAG, (String)"NPE", (Throwable)e);
            String string3 = null;
            return string3;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }

    public static HSMsg addAndGetLocalRscMsg(HSStorage storage, String issueId, String screenshot) {
        return AttachmentUtil.addAndGetLocalRscMsg(storage, issueId, screenshot, false);
    }

    public static HSMsg addAndGetLocalRscMsg(HSStorage storage, String issueId, String screenshot, boolean inProgress) {
        HSMsg msg = null;
        try {
            String messageId = LOCAL_RSC_MSG_ID_PREFIX + UUID.randomUUID().toString();
            String date = AttachmentUtil.resolveTimestamp(IssuesDataSource.getIssue(issueId));
            String body = "Attaching Screenshot...";
            JSONObject message = new JSONObject();
            message.put("id", (Object)messageId);
            message.put("issue_id", (Object)issueId);
            message.put("type", (Object)"rsc");
            message.put("origin", (Object)"admin");
            message.put("body", (Object)body);
            message.put("invisible", false);
            message.put("screenshot", (Object)screenshot);
            message.put("state", 0);
            message.put("inProgress", inProgress);
            message.put("created_at", (Object)date);
            message.put("seen", true);
            message.put("author", (Object)new JSONObject());
            message.put("meta", (Object)new JSONObject());
            JSONArray messages = new JSONArray();
            messages.put((Object)message);
            IssuesDataSource.storeMessages(IssuesUtil.jsonArrayToMessageList(messages));
            msg = new HSMsg(messageId, "rsc", "admin", body, date, false, screenshot, 0, false, "");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"addAndGetLocalRscMessage", (Throwable)e);
        }
        return msg;
    }

    private static String resolveTimestamp(Issue issue) {
        Date localTs = new Date();
        try {
            List<Message> messageList = issue.getMessageList();
            Message lastMessage = messageList.get(messageList.size() - 1);
            Date lastMessageTs = HSFormat.issueTsFormat.parse(lastMessage.getCreatedAt());
            if (localTs.before(lastMessageTs)) {
                localTs.setTime(lastMessageTs.getTime() + 3000L);
            }
        }
        catch (ParseException e) {
            Log.d((String)TAG, (String)"resolveDate", (Throwable)e);
        }
        return HSFormat.issueTsFormat.format(localTs);
    }

    public static boolean isImageUri(Activity activity, Intent dataIntent) {
        Uri ssUri = dataIntent.getData();
        ContentResolver contentResolver = activity.getContentResolver();
        String mimeType = contentResolver.getType(ssUri);
        String[] includeExts = new String[]{"image/jpeg", "image/png", "image/gif", "image/x-png", "image/x-citrix-pjpeg", "image/x-citrix-gif", "image/pjpeg"};
        HashSet<String> allowedMimeTypes = new HashSet<String>(Arrays.asList(includeExts));
        if (allowedMimeTypes.contains(mimeType)) {
            return true;
        }
        AttachmentUtil.showScreenshotNotOfImageTypeErrorToast(activity);
        return false;
    }

    public static String getFileType(Context context, String contentType, String fileName) {
        if (contentType.contains(FILE_TYPE_AUDIO)) {
            return context.getResources().getString(D.string.hs__file_type_audio);
        }
        if (contentType.contains(FILE_TYPE_VIDEO)) {
            return context.getResources().getString(D.string.hs__file_type_video);
        }
        if (contentType.contains(FILE_TYPE_PDF)) {
            return context.getResources().getString(D.string.hs__file_type_pdf);
        }
        if (contentType.contains(FILE_TYPE_MS_OFFICE_SUBSCRIPT)) {
            return context.getResources().getString(D.string.hs__file_type_ms_office);
        }
        if (contentType.equals(FILE_TYPE_RTF)) {
            return context.getResources().getString(D.string.hs__file_type_rtf);
        }
        if (contentType.equals(FILE_TYPE_CSV)) {
            return context.getResources().getString(D.string.hs__file_type_csv);
        }
        if (contentType.equals(FILE_TYPE_TEXT)) {
            return context.getResources().getString(D.string.hs__file_type_text);
        }
        String[] split = fileName.split("\\.");
        if (split.length > 0) {
            return split[split.length - 1];
        }
        split = contentType.split("/");
        if (split.length > 0) {
            return split[split.length - 1];
        }
        return context.getResources().getString(D.string.hs__file_type_unknown);
    }

    public static String getFileName(String filePath) {
        String fileName = "";
        if (filePath != null) {
            File file = new File(filePath);
            fileName = file.getName();
        }
        return fileName;
    }

    public static String getFileSizeString(String filePath) {
        String fileSize = "";
        if (filePath != null) {
            File file = new File(filePath);
            long size = file.length();
            fileSize = size < 1024L ? size + " B" : (size < 0x100000L ? size / 1024L + " KB" : String.format("%.1f", Float.valueOf((float)size / 1048576.0f)) + " MB");
        }
        return fileSize;
    }
}

