/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.os.Handler;
import android.os.HandlerThread;
import com.helpshift.support.HSApiData;
import org.json.JSONException;

public class ConversationsPoller {
    private final Runnable runnableTask;
    private final Handler conversationsPollerThreadHandler;
    private boolean pollerStarted = false;

    public ConversationsPoller(final int interval, final Handler success, final Handler failure, final HSApiData data) {
        HandlerThread conversationsPollerThread = new HandlerThread("ConversationsPoller");
        conversationsPollerThread.start();
        this.conversationsPollerThreadHandler = new Handler(conversationsPollerThread.getLooper());
        this.runnableTask = new Runnable(){

            @Override
            public void run() {
                try {
                    data.getLatestIssues(success, failure);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                ConversationsPoller.this.conversationsPollerThreadHandler.postDelayed(ConversationsPoller.this.runnableTask, (long)(interval * 1000));
            }
        };
    }

    public void start() {
        if (!this.pollerStarted) {
            this.conversationsPollerThreadHandler.post(this.runnableTask);
            this.pollerStarted = true;
        }
    }

    public void stop() {
        if (this.pollerStarted) {
            this.conversationsPollerThreadHandler.removeCallbacks(this.runnableTask);
            this.pollerStarted = false;
        }
    }

    public void quit() {
        this.conversationsPollerThreadHandler.getLooper().quit();
    }
}

