/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import java.lang.ref.SoftReference;
import java.util.Hashtable;

public final class HSCustomFont {
    public static final String TAG = "HelpshiftDebug";
    private static final Hashtable<String, SoftReference<Typeface>> fontCache = new Hashtable();

    public static void setCustomFont(View textViewOrButton, Context context, AttributeSet attrs, int[] attributeSet, int fontId) {
        TypedArray a = context.obtainStyledAttributes(attrs, attributeSet);
        String customFont = a.getString(fontId);
        HSCustomFont.setCustomFont(textViewOrButton, context, customFont);
        a.recycle();
    }

    private static boolean setCustomFont(View textViewOrButton, Context context, String asset) {
        if (TextUtils.isEmpty((CharSequence)asset)) {
            return false;
        }
        Typeface tf = null;
        try {
            tf = HSCustomFont.getFont(context, asset);
            if (textViewOrButton instanceof TextView) {
                ((TextView)textViewOrButton).setTypeface(tf);
            } else {
                ((Button)textViewOrButton).setTypeface(tf);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Could not get typeface: " + asset), (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Typeface getFont(Context c, String name) {
        Hashtable<String, SoftReference<Typeface>> hashtable = fontCache;
        synchronized (hashtable) {
            SoftReference<Typeface> ref;
            if (fontCache.get(name) != null && (ref = fontCache.get(name)).get() != null) {
                return ref.get();
            }
            Typeface typeface = Typeface.createFromAsset((AssetManager)c.getAssets(), (String)name);
            fontCache.put(name, new SoftReference<Typeface>(typeface));
            return typeface;
        }
    }
}

