/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.helpshift.support.D;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSStorage;
import com.helpshift.support.SupportInternal;
import com.helpshift.support.activities.ParentActivity;
import com.helpshift.support.model.Issue;
import com.helpshift.support.storage.IssuesDataSource;
import com.helpshift.support.util.HSPolling;
import com.helpshift.support.util.MessagesUtil;
import com.helpshift.support.util.Xml;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSFormat;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HSNotification {
    private static final String APP_NAME = "app_name";
    private static String TAG = "HelpShiftDebug";
    private static HSApiData data;

    public static void showNotif(Context c, Issue issue, int messCnt, String chatLaunchSource, Intent intent) {
        Bundle extras = intent.getExtras();
        String appName = extras != null && extras.containsKey(APP_NAME) ? extras.getString(APP_NAME) : HSNotification.getApplicationName(c);
        try {
            int ts = (int)HSFormat.issueTsFormat.parse(issue.getCreatedAt()).getTime();
            HSNotification.showNotif(c, issue.getIssueId(), ts, messCnt, chatLaunchSource, appName);
        }
        catch (ParseException e) {
            Log.d((String)TAG, (String)"showNotif ParseException", (Throwable)e);
        }
    }

    public static String getApplicationName(Context context) {
        String appName = null;
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = context.getApplicationInfo();
            appName = pm.getApplicationLabel(ai).toString();
        }
        catch (NullPointerException e) {
            Log.d((String)TAG, (String)"getApplicationName", (Throwable)e);
        }
        if (appName == null) {
            appName = context.getResources().getString(D.string.hs__default_notification_content_title);
        }
        return appName;
    }

    public static void showNotif(Context c, String issueId, int ts, int newMessCnt, String chatLaunchSource, String contentTitle) {
        if (data == null) {
            data = new HSApiData(c);
        }
        HSNotification.data.storage.saveNotification(issueId, ts, newMessCnt, chatLaunchSource, contentTitle);
        String issueProfileId = Issue.getProfileId(issueId);
        if (!issueProfileId.equals(data.getProfileId())) {
            return;
        }
        SupportInternal.Delegate delegate = SupportInternal.getDelegate();
        if (delegate != null) {
            delegate.didReceiveNotification(newMessCnt);
        }
        NotificationManager notificationManager = (NotificationManager)c.getSystemService("notification");
        String notifText = c.getResources().getQuantityString(D.plurals.hs__notification_content_title, newMessCnt, new Object[]{newMessCnt});
        int notificationIcon = Xml.getLogoResourceValue(c);
        Uri soundUri = null;
        HSStorage storage = new HSStorage(c);
        try {
            JSONObject config = storage.getAppConfig();
            if (config.has("notificationSound")) {
                int sound = config.getInt("notificationSound");
                String soundUriString = "android.resource://" + c.getPackageName() + "/" + sound;
                soundUri = Uri.parse((String)soundUriString);
            }
            if (config.has("notificationIcon")) {
                notificationIcon = config.getInt("notificationIcon");
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getAppConfig", (Throwable)e);
        }
        Intent notificationIntent = new Intent(c, ParentActivity.class);
        notificationIntent.setFlags(0x10000000);
        notificationIntent.putExtra("support_mode", 1);
        notificationIntent.putExtra("issueId", issueId);
        notificationIntent.putExtra("chatLaunchSource", chatLaunchSource);
        notificationIntent.putExtra("isRoot", true);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)c, (int)ts, (Intent)notificationIntent, (int)0);
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(c);
        notificationBuilder.setSmallIcon(notificationIcon);
        notificationBuilder.setContentTitle((CharSequence)contentTitle);
        notificationBuilder.setContentText((CharSequence)notifText);
        notificationBuilder.setContentIntent(contentIntent);
        notificationBuilder.setAutoCancel(true);
        if (soundUri == null) {
            if (ApplicationUtil.hasVibratePermission(c)) {
                notificationBuilder.setDefaults(-1);
            } else {
                notificationBuilder.setDefaults(5);
            }
        } else {
            notificationBuilder.setSound(soundUri);
            if (ApplicationUtil.hasVibratePermission(c)) {
                notificationBuilder.setDefaults(6);
            } else {
                notificationBuilder.setDefaults(4);
            }
        }
        notificationManager.notify(issueId, 1, notificationBuilder.build());
    }

    public static Handler getNotifHandler(final Context c, final HSPolling notifCountPoller) {
        final HSApiData data = new HSApiData(c);
        Handler notifHandler = new Handler(){

            public void handleMessage(Message msg) {
                JSONArray issues = (JSONArray)msg.obj;
                try {
                    if (notifCountPoller != null) {
                        notifCountPoller.resetInterval();
                    }
                    for (int i = 0; i < issues.length(); ++i) {
                        int messCnt;
                        String type;
                        JSONObject lastMessage;
                        String origin;
                        JSONObject issue = issues.getJSONObject(i);
                        String issueId = issue.getString("id");
                        if (data.storage.getForegroundIssue().equals(issueId)) continue;
                        Issue storedIssue = IssuesDataSource.getIssue(issueId);
                        JSONArray messages = issue.getJSONArray("messages");
                        if (messages.length() == 1 && MessagesUtil.notificationsTurnedOff(origin = (lastMessage = messages.getJSONObject(messages.length() - 1)).getString("origin"), type = lastMessage.getString("type")) || (messCnt = storedIssue.getNewMessagesCount()) == 0) continue;
                        try {
                            int ts = (int)HSFormat.issueTsFormat.parse(issue.getString("created_at")).getTime();
                            HSNotification.showNotif(c, issue.getString("id"), ts, messCnt, "inapp", HSNotification.getApplicationName(c));
                            continue;
                        }
                        catch (ParseException e) {
                            Log.d((String)TAG, (String)e.toString());
                        }
                    }
                }
                catch (JSONException e) {
                    Log.d((String)TAG, (String)e.getMessage());
                }
            }
        };
        return notifHandler;
    }
}

