/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.util.Log;
import com.helpshift.support.model.Issue;
import com.helpshift.support.model.IssueBuilder;
import com.helpshift.support.model.Message;
import com.helpshift.support.model.MessageBuilder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IssuesUtil {
    private static final String TAG = "HelpShiftDebug";

    public static List<Issue> jsonArrayToIssueList(String profileId, JSONArray issues) {
        ArrayList<Issue> issueList = new ArrayList<Issue>();
        try {
            for (int i = 0; i < issues.length(); ++i) {
                JSONObject issue = issues.getJSONObject(i);
                issueList.add(IssuesUtil.jsonObjectToIssue(profileId, issue));
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"storeMessages", (Throwable)e);
        }
        return issueList;
    }

    private static Issue jsonObjectToIssue(String profileId, JSONObject object) throws JSONException {
        IssueBuilder issueBuilder = new IssueBuilder(profileId, object.getString("id"), object.getString("body"), object.getString("title"), object.getString("created_at"), object.getString("updated_at"), object.getInt("status"), object.optBoolean("show-agent-name", true));
        return issueBuilder.setMessageList(IssuesUtil.jsonArrayToMessageList(object.getJSONArray("messages"))).build();
    }

    public static List<Message> jsonArrayToMessageList(JSONArray messages) {
        ArrayList<Message> messageList = new ArrayList<Message>();
        try {
            for (int i = 0; i < messages.length(); ++i) {
                JSONObject message = messages.getJSONObject(i);
                messageList.add(IssuesUtil.jsonObjectToMessage(message));
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"storeMessages", (Throwable)e);
        }
        return messageList;
    }

    private static Message jsonObjectToMessage(JSONObject object) throws JSONException {
        MessageBuilder messageBuilder = new MessageBuilder(object.getString("issue_id"), object.getString("id"), object.getString("body"), object.getString("origin"), object.getString("type"), object.getString("created_at"), object.getJSONObject("author").toString(), object.getJSONObject("meta").toString());
        return messageBuilder.setScreenshot(object.optString("screenshot")).setMessageSeen(object.optBoolean("seen")).setInvisible(object.optBoolean("invisible")).setInProgress(object.optBoolean("inProgress")).build();
    }

    public static JSONArray messageListToJSONArray(List<Message> messageList) {
        JSONArray messages = new JSONArray();
        for (Message message : messageList) {
            JSONObject messageObject = new JSONObject();
            try {
                messageObject.put("issue_id", (Object)message.getIssueId());
                messageObject.put("id", (Object)message.getMessageId());
                messageObject.put("body", (Object)message.getBody());
                messageObject.put("origin", (Object)message.getOrigin());
                messageObject.put("type", (Object)message.getType());
                messageObject.put("created_at", (Object)message.getCreatedAt());
                messageObject.put("author", (Object)new JSONObject(message.getAuthor()));
                messageObject.put("meta", (Object)new JSONObject(message.getMeta()));
                messageObject.put("screenshot", (Object)message.getScreenshot());
                messageObject.put("seen", message.isMessageSeen());
                messageObject.put("invisible", message.isInvisible());
                messageObject.put("inProgress", message.isInProgress());
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"messageListToJSONArray", (Throwable)e);
            }
            messages.put((Object)messageObject);
        }
        return messages;
    }
}

