/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Log;
import com.helpshift.util.HelpshiftContext;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class LocaleUtil {
    private static final String TAG = LocaleUtil.class.getSimpleName();
    private static final HSStorage storage = new HSStorage(HelpshiftContext.getApplicationContext());

    public static void changeLanguage(Context context) {
        String language = storage.getSdkLanguage();
        if (!TextUtils.isEmpty((CharSequence)language)) {
            Resources resources = context.getResources();
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            Configuration configuration = resources.getConfiguration();
            configuration.locale = LocaleUtil.getLocale(language);
            resources.updateConfiguration(configuration, displayMetrics);
        }
    }

    private static Locale getLocale(String language) {
        if (language.contains("_")) {
            String[] languageArray = language.split("_");
            return new Locale(languageArray[0], languageArray[1]);
        }
        return new Locale(language);
    }

    public static String getAcceptLanguageHeader() {
        String sdkLanguage = storage.getSdkLanguage();
        if (TextUtils.isEmpty((CharSequence)sdkLanguage)) {
            return Locale.getDefault().toString();
        }
        return sdkLanguage;
    }

    public static boolean isDefaultFallbackLanguageEnabled() {
        boolean defaultFallbackLanguageEnabled = true;
        try {
            JSONObject config = storage.getAppConfig();
            if (config.has("enableDefaultFallbackLanguage")) {
                defaultFallbackLanguageEnabled = config.getBoolean("enableDefaultFallbackLanguage");
            }
        }
        catch (JSONException e) {
            Log.d(TAG, "isDefaultFallbackLanguageEnabled", e);
        }
        return defaultFallbackLanguageEnabled;
    }
}

