/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.util.Log;
import android.util.Pair;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessagesUtil {
    private static final String TAG = "HelpShiftDebug";
    private static final List<Pair<String, String>> supportedMessages = Arrays.asList(new Pair((Object)"admin", (Object)"txt"), new Pair((Object)"admin", (Object)"rsc"), new Pair((Object)"admin", (Object)"rar"), new Pair((Object)"admin", (Object)"rfr"), new Pair((Object)"admin", (Object)"admin_attachment_image"), new Pair((Object)"admin", (Object)"admin_attachment_generic"), new Pair((Object)"mobile", (Object)"txt"), new Pair((Object)"mobile", (Object)"ncr"), new Pair((Object)"mobile", (Object)"sc"), new Pair((Object)"mobile", (Object)"ar"));
    private static final List<Pair<String, String>> notificationsOffMessages = Arrays.asList(new Pair((Object)"admin", (Object)"rfr"), new Pair((Object)"mobile", (Object)"ra"), new Pair((Object)"mobile", (Object)"rj"));

    public static boolean isMessageSupported(String origin, String type) {
        return supportedMessages.contains(new Pair((Object)origin, (Object)type));
    }

    public static boolean notificationsTurnedOff(String origin, String type) {
        return notificationsOffMessages.contains(new Pair((Object)origin, (Object)type));
    }

    public static boolean isRfrAccepted(JSONArray messages, int startIndex, String rfrMessageId) {
        boolean rfrAccepted = false;
        for (int i = startIndex; i < messages.length(); ++i) {
            try {
                String refers;
                JSONObject message = messages.getJSONObject(i);
                String origin = message.getString("origin");
                String type = message.getString("type");
                if (!origin.equals("mobile") || !type.equals("ra") || !(refers = message.getJSONObject("meta").getString("refers")).equals(rfrMessageId)) continue;
                rfrAccepted = true;
                break;
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"isRfrAccepted", (Throwable)e);
            }
        }
        return rfrAccepted;
    }
}

