/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.helpshift.support.Callable;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Log;
import com.helpshift.support.res.values.HSConfig;
import com.helpshift.support.util.ArraysCompat;
import com.helpshift.support.util.LocaleUtil;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class Meta {
    public static final String TAG = "HelpShiftDebug";
    private static Callable metaFn;

    public static JSONObject getMetaInfo(Context c, Boolean attachDeviceInfo, String customIdentifier) {
        HSStorage storage;
        JSONObject meta = new JSONObject();
        try {
            meta.put("breadcrumbs", (Object)Meta.getBreadCrumbs(c));
        }
        catch (JSONException e) {
            android.util.Log.d((String)TAG, (String)"Error while getting device info", (Throwable)e);
        }
        try {
            if (attachDeviceInfo.booleanValue()) {
                meta.put("device_info", (Object)Meta.getDeviceInfo(c));
            } else {
                meta.put("device_info", (Object)new JSONObject());
            }
        }
        catch (JSONException e) {
            android.util.Log.d((String)TAG, (String)"Error while getting device info", (Throwable)e);
        }
        try {
            meta.put("extra", (Object)Meta.getExtra(customIdentifier));
        }
        catch (JSONException e) {
            android.util.Log.d((String)TAG, (String)"Error while getting extra info", (Throwable)e);
        }
        try {
            Integer logLimit = (Integer)HSConfig.configData.get("dbgl");
            meta.put("logs", (Object)Meta.formatLogList(Log.getLogs(logLimit)));
        }
        catch (JSONException e) {
            android.util.Log.d((String)TAG, (String)"Error while getting debug logs", (Throwable)e);
        }
        try {
            storage = new HSStorage(c);
            meta.put("device_token", (Object)storage.getDeviceToken());
        }
        catch (JSONException e) {
            android.util.Log.d((String)TAG, (String)"Error while getting device token", (Throwable)e);
        }
        storage = new HSStorage(c);
        if (metaFn != null) {
            try {
                JSONObject customMeta = Meta.getCustomMeta();
                if (customMeta != null) {
                    meta.put("custom_meta", (Object)customMeta);
                }
                storage.setCustomMetaData(customMeta);
            }
            catch (JSONException e) {
                android.util.Log.d((String)TAG, (String)"Error while getting extra meta", (Throwable)e);
            }
        } else {
            try {
                JSONObject storageMeta = storage.getCustomMetaData();
                if (storageMeta != null) {
                    meta.put("custom_meta", (Object)storageMeta);
                }
            }
            catch (JSONException e) {
                android.util.Log.d((String)TAG, (String)"Exception in getting meta from storage ", (Throwable)e);
            }
        }
        return meta;
    }

    private static JSONArray getBreadCrumbs(Context c) throws JSONException {
        HSStorage storage = new HSStorage(c);
        return storage.getBreadCrumbs();
    }

    private static JSONObject getDeviceInfo(Context c) throws JSONException {
        JSONObject deviceInfo = new JSONObject();
        deviceInfo.put("platform", (Object)"android");
        deviceInfo.put("library-version", (Object)"4.2.0");
        deviceInfo.put("device-model", (Object)Build.MODEL);
        deviceInfo.put("os-version", (Object)Build.VERSION.RELEASE);
        try {
            deviceInfo.put("language-code", (Object)LocaleUtil.getAcceptLanguageHeader());
        }
        catch (MissingResourceException e) {
            android.util.Log.d((String)TAG, (String)"Device Info - MissingResourceException", (Throwable)e);
        }
        String ts = HSFormat.deviceInfoTsFormat.format(new Date());
        deviceInfo.put("timestamp", (Object)ts);
        String packageName = c.getPackageName();
        deviceInfo.put("application-identifier", (Object)packageName);
        deviceInfo.put("application-name", (Object)Meta.getAppName(c));
        deviceInfo.put("application-version", (Object)ApplicationUtil.getApplicationVersion(c));
        deviceInfo.put("disk-space", (Object)Meta.getDiskSpace(c));
        TelephonyManager tm = (TelephonyManager)c.getSystemService("phone");
        deviceInfo.put("country-code", (Object)tm.getSimCountryIso());
        deviceInfo.put("carrier-name", (Object)tm.getNetworkOperatorName());
        try {
            deviceInfo.put("network-type", (Object)Meta.getNetworkType(c));
        }
        catch (SecurityException e) {
            android.util.Log.d((String)TAG, (String)"No permission for Network Access", (Throwable)e);
        }
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = c.registerReceiver(null, ifilter);
        deviceInfo.put("battery-level", (Object)Meta.getBatteryLevel(batteryStatus));
        deviceInfo.put("battery-status", (Object)Meta.getBatteryStatus(batteryStatus));
        return deviceInfo;
    }

    private static JSONObject getExtra(String customIdentifier) throws JSONException {
        JSONObject extra = new JSONObject();
        extra.put("api-version", (Object)"2");
        extra.put("library-version", (Object)"4.2.0");
        if (customIdentifier != null) {
            extra.put("user-id", (Object)customIdentifier);
        }
        return extra;
    }

    private static String getAppName(Context c) {
        ApplicationInfo ai;
        PackageManager pm = c.getPackageManager();
        try {
            ai = pm.getApplicationInfo(c.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = null;
        }
        String applicationName = ai != null ? pm.getApplicationLabel(ai) : "(unknown)";
        return applicationName;
    }

    private static JSONObject getDiskSpace(Context c) {
        JSONObject diskSpace = new JSONObject();
        StatFs phoneStat = new StatFs(Environment.getDataDirectory().getPath());
        double free_phone_memory = (double)phoneStat.getAvailableBlocks() * (double)phoneStat.getBlockSize() / 1.073741824E9;
        free_phone_memory = (double)Math.round(free_phone_memory * 100.0) / 100.0;
        double total_phone_memory = (double)phoneStat.getBlockCount() * (double)phoneStat.getBlockSize() / 1.073741824E9;
        total_phone_memory = (double)Math.round(total_phone_memory * 100.0) / 100.0;
        try {
            diskSpace.put("free-space-phone", (Object)(free_phone_memory + " GB"));
            diskSpace.put("total-space-phone", (Object)(total_phone_memory + " GB"));
        }
        catch (JSONException e) {
            android.util.Log.d((String)TAG, (String)e.toString(), (Throwable)e);
        }
        int hasWriteStoragePermission = 0;
        if (Build.VERSION.SDK_INT >= 23) {
            hasWriteStoragePermission = ContextCompat.checkSelfPermission((Context)c, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        }
        if (hasWriteStoragePermission == 0) {
            String externalStoragePath = Environment.getExternalStorageDirectory().getPath();
            StatFs sdStat = new StatFs(externalStoragePath);
            double free_sd_memory = (double)sdStat.getAvailableBlocks() * (double)sdStat.getBlockSize() / 1.073741824E9;
            free_sd_memory = (double)Math.round(free_sd_memory * 100.0) / 100.0;
            double total_sd_memory = (double)sdStat.getBlockCount() * (double)sdStat.getBlockSize() / 1.073741824E9;
            total_sd_memory = (double)Math.round(total_sd_memory * 100.0) / 100.0;
            try {
                diskSpace.put("free-space-sd", (Object)(free_sd_memory + " GB"));
                diskSpace.put("total-space-sd", (Object)(total_sd_memory + " GB"));
            }
            catch (JSONException e) {
                android.util.Log.d((String)TAG, (String)"getDiskSpace - SDCard : ", (Throwable)e);
            }
        }
        return diskSpace;
    }

    private static String getNetworkType(Context c) {
        ConnectivityManager cm = (ConnectivityManager)c.getSystemService("connectivity");
        NetworkInfo ani = cm.getActiveNetworkInfo();
        String type = "Unknown";
        if (ani != null) {
            type = ani.getTypeName();
        }
        return type;
    }

    private static String getBatteryLevel(Intent batteryStatus) {
        int level = batteryStatus.getIntExtra("level", -1);
        int scale = batteryStatus.getIntExtra("scale", -1);
        int batteryPct = (int)((float)level / (float)scale * 100.0f);
        return batteryPct + "%";
    }

    private static String getBatteryStatus(Intent batteryStatus) {
        int status = batteryStatus.getIntExtra("status", -1);
        boolean isCharging = status == 2 || status == 5;
        return isCharging ? "Charging" : "Not charging";
    }

    public static String getApplicationVersion(Context c) {
        String appVersion = null;
        try {
            String packageName = c.getPackageName();
            PackageInfo p = c.getPackageManager().getPackageInfo(packageName, 0);
            appVersion = p.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            android.util.Log.d((String)TAG, (String)"Package not found exception", (Throwable)e);
        }
        return appVersion;
    }

    private static JSONObject formatLog(HashMap log) {
        JSONObject outputLog = new JSONObject();
        try {
            outputLog.put("message", log.get("message"));
            outputLog.put("level", log.get("level"));
            outputLog.put("tag", log.get("tag"));
            outputLog.put("exception", log.get("exception"));
        }
        catch (JSONException e) {
            android.util.Log.d((String)TAG, (String)"Format debug lgos", (Throwable)e);
        }
        return outputLog;
    }

    private static JSONArray formatLogList(ArrayList<HashMap> logs) {
        JSONArray outputList = new JSONArray();
        for (int i = 0; i < logs.size(); ++i) {
            outputList.put((Object)Meta.formatLog(logs.get(i)));
        }
        return outputList;
    }

    public static void setMetadataCallback(Callable f) {
        metaFn = f;
    }

    public static JSONObject getCustomMeta() throws JSONException {
        HashMap meta;
        if (metaFn != null && (meta = metaFn.call()) != null) {
            meta = Meta.removeEmptyKeyOrValue(meta);
            return new JSONObject((Map)Meta.cleanMetaForTags(meta));
        }
        return null;
    }

    private static HashMap removeEmptyKeyOrValue(HashMap metadata) {
        HashMap newMetaData = (HashMap)metadata.clone();
        for (Object key : metadata.keySet()) {
            Object value = metadata.get(key);
            if (key instanceof String && ((String)key).trim().equalsIgnoreCase("")) {
                newMetaData.remove(key);
            }
            if (!(value instanceof String) || !((String)value).trim().equalsIgnoreCase("")) continue;
            newMetaData.remove(key);
        }
        return newMetaData;
    }

    private static String[] cleanTags(String[] input) {
        int w;
        String[] v = input;
        int r = w = v.length;
        int n = w;
        while (r > 0) {
            String s;
            if ((s = v[--r]) == null || TextUtils.isEmpty((CharSequence)s.trim())) continue;
            v[--w] = s.trim();
        }
        v = ArraysCompat.copyOfRange(v, w, n);
        v = new HashSet<String>(Arrays.asList(v)).toArray(new String[0]);
        return v;
    }

    private static HashMap cleanMetaForTags(HashMap meta) {
        Object tags = meta.get("hs-tags");
        meta.remove("hs-tags");
        if (tags instanceof String[]) {
            JSONArray tagsJSON = new JSONArray(Arrays.asList(Meta.cleanTags((String[])tags)));
            meta.put("hs-tags", tagsJSON);
        }
        return meta;
    }

    public static JSONObject getMinimalDeviceInfo(Context context) {
        JSONObject deviceInfo = new JSONObject();
        try {
            deviceInfo.put("device-model", (Object)Build.MODEL);
            deviceInfo.put("platform", (Object)"android");
            deviceInfo.put("os-version", (Object)Build.VERSION.RELEASE);
            String packageName = context.getPackageName();
            deviceInfo.put("application-identifier", (Object)packageName);
            deviceInfo.put("application-name", (Object)Meta.getAppName(context));
            deviceInfo.put("application-version", (Object)Meta.getApplicationVersion(context));
            deviceInfo.put("library-version", (Object)"4.2.0");
            deviceInfo.put("network-type", (Object)Meta.getNetworkType(context));
            String timeStamp = HSFormat.deviceInfoTsFormat.format(new Date());
            deviceInfo.put("timestamp", (Object)timeStamp);
        }
        catch (JSONException e) {
            android.util.Log.d((String)TAG, (String)"Error parsing JSON while calling getMinimalDeviceInfo", (Throwable)e);
        }
        catch (SecurityException e) {
            android.util.Log.d((String)TAG, (String)"No permission for Network Access", (Throwable)e);
        }
        return deviceInfo;
    }
}

