/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.annotation.TargetApi;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.view.View;
import com.helpshift.R;

public class PermissionUtil {
    @TargetApi(value=9)
    public static void showSettingsPage(Context context) {
        try {
            Intent settingsIntent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            settingsIntent.addCategory("android.intent.category.DEFAULT");
            String packageName = context.getPackageName();
            settingsIntent.setData(Uri.parse((String)("package:" + packageName)));
            context.startActivity(settingsIntent);
        }
        catch (ActivityNotFoundException ex) {
            Intent i = new Intent("android.settings.MANAGE_APPLICATIONS_SETTINGS");
            i.addCategory("android.intent.category.DEFAULT");
            context.startActivity(i);
        }
    }

    public static Snackbar requestPermissions(final Fragment fragment, final String[] permissions, final int requestCode, View view) {
        Snackbar showRationaleSnackbar = null;
        if (fragment.shouldShowRequestPermissionRationale(permissions[0])) {
            showRationaleSnackbar = Snackbar.make((View)view, (int)R.string.hs__permission_denied_message, (int)-2).setAction(R.string.hs__permission_rationale_snackbar_action_label, new View.OnClickListener(){

                public void onClick(View view) {
                    fragment.requestPermissions(permissions, requestCode);
                }
            });
            showRationaleSnackbar.show();
        } else {
            fragment.requestPermissions(permissions, requestCode);
        }
        return showRationaleSnackbar;
    }
}

