/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import com.helpshift.R;
import com.helpshift.support.D;
import com.helpshift.support.Faq;
import com.helpshift.support.util.HSTransliterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Styles {
    public static int getColor(Context context, int attribute) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{attribute});
        int color = typedArray.getColor(0, -1);
        typedArray.recycle();
        return color;
    }

    public static String getHexColor(Context context, int attribute) {
        return String.format("#%06X", 0xFFFFFF & Styles.getColor(context, attribute));
    }

    public static void setActionButtonIconColor(Context context, Drawable actionButtonIcon) {
        Styles.setColorFilter(context, actionButtonIcon, D.attr.hs__actionButtonIconColor);
    }

    public static void setActionButtonNotificationIconColor(Context context, Drawable actionButtonNotificationIcon) {
        Styles.setColorFilter(context, actionButtonNotificationIcon, D.attr.hs__actionButtonNotificationIconColor);
    }

    public static void setButtonCompoundDrawableIconColor(Context context, Drawable buttonCompoundDrawableIcon) {
        Styles.setColorFilter(context, buttonCompoundDrawableIcon, D.attr.hs__buttonCompoundDrawableIconColor);
    }

    public static void setSendMessageButtonIconColor(Context context, Drawable sendMessageButtonIcon) {
        Styles.setColorFilter(context, sendMessageButtonIcon, 16842906);
    }

    public static void setSendMessageButtonActiveIconColor(Context context, Drawable sendMessageButtonActiveIcon) {
        Styles.setColorFilter(context, sendMessageButtonActiveIcon, R.attr.hs__accentColor);
    }

    public static void setAcceptButtonIconColor(Context context, Drawable acceptButtonIcon) {
        Styles.setColorFilter(context, acceptButtonIcon, D.attr.hs__acceptButtonIconColor);
    }

    public static void setRejectButtonIconColor(Context context, Drawable rejectButtonIcon) {
        Styles.setColorFilter(context, rejectButtonIcon, D.attr.hs__rejectButtonIconColor);
    }

    public static void setAttachScreenshotButtonIconColor(Context context, Drawable attachScreenshotButtonIcon) {
        Styles.setColorFilter(context, attachScreenshotButtonIcon, D.attr.hs__attachScreenshotButtonIconColor);
    }

    public static void setReviewButtonIconColor(Context context, Drawable reviewButtonIcon) {
        Styles.setColorFilter(context, reviewButtonIcon, D.attr.hs__reviewButtonIconColor);
    }

    public static void setAdminChatBubbleColor(Context context, Drawable adminChatBubbleNinePatch) {
        Styles.setColorFilter(context, adminChatBubbleNinePatch, R.attr.hs__chatBubbleAdminBackgroundColor);
    }

    public static void setUserChatBubbleColor(Context context, Drawable userChatBubbleNinePatch) {
        Styles.setColorFilter(context, userChatBubbleNinePatch, R.attr.hs__chatBubbleUserBackgroundColor);
    }

    public static void setDownloadAttachmentButtonIconColor(Context context, Drawable downloadAttachmentButtonIcon) {
        Styles.setColorFilter(context, downloadAttachmentButtonIcon, D.attr.hs__downloadAttachmentButtonIconColor);
    }

    public static void setLaunchAttachmentButtonIconColor(Context context, Drawable launchAttachmentButtonIcon) {
        Styles.setColorFilter(context, launchAttachmentButtonIcon, D.attr.hs__launchAttachmentButtonIconColor);
    }

    public static void setAccentColor(Context context, Drawable ratingBar) {
        Styles.setColorFilter(context, ratingBar, R.attr.hs__accentColor);
    }

    private static void setColorFilter(Context context, Drawable drawable2, int attr2) {
        if (drawable2 != null) {
            drawable2.setColorFilter(Styles.getColor(context, attr2), PorterDuff.Mode.SRC_ATOP);
        }
    }

    public static Faq getQuestionWithHighlightedSearchTerms(Context context, Faq question, ArrayList<String> searchTerms) {
        Faq newQuestion = null;
        if (searchTerms != null && searchTerms.size() > 0) {
            boolean isEnglish;
            Collections.sort(searchTerms);
            Collections.reverse(searchTerms);
            String titleText = question.getTitle();
            String bodyText = question.getBody();
            LinkedHashSet<String> reverseTransKeywords = new LinkedHashSet<String>();
            String hexColor = Styles.getHexColor(context, R.attr.hs__searchHighlightColor);
            boolean bl = isEnglish = HSTransliterator.unidecode(titleText).equals(titleText) && HSTransliterator.unidecode(bodyText).equals(bodyText);
            if (!isEnglish) {
                int titleLength = titleText.length();
                String titleTrans = "";
                ArrayList<Integer> titleIndex = new ArrayList<Integer>();
                for (int i = 0; i < titleLength; ++i) {
                    char character = titleText.charAt(i);
                    String charTransliteration = HSTransliterator.unidecode(character + "");
                    for (int j = 0; j < charTransliteration.length(); ++j) {
                        titleTrans = titleTrans + charTransliteration.charAt(j);
                        titleIndex.add(i);
                    }
                }
                titleTrans = titleTrans.toLowerCase();
                int bodyLength = bodyText.length();
                HSTransliterator.unidecode(bodyText);
                String bodyTrans = "";
                ArrayList<Integer> bodyIndex = new ArrayList<Integer>();
                for (int i = 0; i < bodyLength; ++i) {
                    char character = bodyText.charAt(i);
                    String charTransliteration = HSTransliterator.unidecode(character + "");
                    for (int j = 0; j < charTransliteration.length(); ++j) {
                        bodyTrans = bodyTrans + charTransliteration.charAt(j);
                        bodyIndex.add(i);
                    }
                }
                bodyTrans = bodyTrans.toLowerCase();
                for (String word : searchTerms) {
                    String reverseTransKeyword;
                    int endIndex;
                    int startIndex;
                    if (word.length() < 3) continue;
                    word = word.toLowerCase();
                    int index = TextUtils.indexOf((CharSequence)titleTrans, (CharSequence)word, (int)0);
                    while (index >= 0) {
                        startIndex = (Integer)titleIndex.get(index);
                        endIndex = (Integer)titleIndex.get(index + word.length() - 1);
                        reverseTransKeyword = titleText.substring(startIndex, endIndex + 1);
                        reverseTransKeywords.add(reverseTransKeyword);
                        index = TextUtils.indexOf((CharSequence)titleTrans, (CharSequence)word, (int)(index + word.length()));
                    }
                    index = TextUtils.indexOf((CharSequence)bodyTrans, (CharSequence)word, (int)0);
                    while (index >= 0) {
                        startIndex = (Integer)bodyIndex.get(index);
                        endIndex = (Integer)bodyIndex.get(index + word.length() - 1);
                        reverseTransKeyword = bodyText.substring(startIndex, endIndex + 1);
                        reverseTransKeywords.add(reverseTransKeyword);
                        index = TextUtils.indexOf((CharSequence)bodyTrans, (CharSequence)word, (int)(index + word.length()));
                    }
                }
            } else {
                for (String word : searchTerms) {
                    if (word.length() < 3) continue;
                    reverseTransKeywords.add(word);
                }
            }
            bodyText = ">" + bodyText + "<";
            titleText = ">" + titleText + "<";
            Pattern pattern = Pattern.compile(">[^<]+<");
            for (String reverseTransWord : reverseTransKeywords) {
                String titleTextCopy = titleText;
                Matcher matcher = pattern.matcher(titleTextCopy);
                while (matcher.find()) {
                    String content = titleTextCopy.substring(matcher.start(), matcher.end());
                    String formattedContent = content.replaceAll("(?i)(" + reverseTransWord + ")", "<span style=\"background-color: " + hexColor + "\">$1</span>");
                    titleText = titleText.replace(content, formattedContent);
                }
                String bodyTextCopy = bodyText;
                matcher = pattern.matcher(bodyTextCopy);
                while (matcher.find()) {
                    String content = bodyTextCopy.substring(matcher.start(), matcher.end());
                    String formattedContent = content.replaceAll("(?i)(" + reverseTransWord + ")", "<span style=\"background-color: " + hexColor + "\">$1</span>");
                    bodyText = bodyText.replace(content, formattedContent);
                }
            }
            titleText = titleText.substring(1, titleText.length() - 1);
            bodyText = bodyText.substring(1, bodyText.length() - 1);
            newQuestion = new Faq(1L, question.getId(), question.getPublishId(), question.getSectionPublishId(), titleText, bodyText, question.getIsHelpful(), question.getIsRtl(), question.getTags(), question.getCategoryTags());
        }
        return newQuestion;
    }

    public static float dpToPx(Context context, float dp) {
        return dp * context.getResources().getDisplayMetrics().density;
    }
}

