/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.XmlResourceParser;

public class Xml {
    public static int getLogoResourceValue(Context context) {
        int resId = Xml.getAttributeResourceValue(context, "AndroidManifest.xml", "application", "logo");
        if (resId == 0) {
            resId = context.getApplicationInfo().icon;
        }
        return resId;
    }

    private static int getAttributeResourceValue(Context context, String xmlFileName, String element, String attribute) {
        int logo = 0;
        try {
            String packageName = context.getApplicationInfo().packageName;
            AssetManager am = context.createPackageContext(packageName, 0).getAssets();
            XmlResourceParser xml = am.openXmlResourceParser(xmlFileName);
            int eventType = xml.getEventType();
            while (eventType != 1) {
                if (eventType == 2 && element.equals(xml.getName())) {
                    for (int i = xml.getAttributeCount() - 1; i >= 0; --i) {
                        if (!attribute.equals(xml.getAttributeName(i))) continue;
                        logo = xml.getAttributeResourceValue(i, 0);
                        break;
                    }
                }
                eventType = xml.nextToken();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logo;
    }
}

