/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.widget;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RatingBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.support.D;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.support.util.Styles;
import com.helpshift.support.widget.CSATView;

public class CSATDialog
extends Dialog
implements DialogInterface.OnShowListener,
DialogInterface.OnDismissListener,
View.OnClickListener,
View.OnTouchListener {
    private Context context;
    private CSATView csatView;
    private RatingBar dialogRatingBar;
    private TextView likeStatus;
    private EditText addtionalFeedback;
    private float rating;
    private boolean submitted = false;

    public CSATDialog(Context context) {
        super(context);
        this.context = context;
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.requestWindowFeature(1);
        super.onCreate(savedInstanceState);
        this.setContentView(D.layout.hs__csat_dialog);
        this.setOnShowListener(this);
        this.setOnDismissListener(this);
        this.dialogRatingBar = (RatingBar)this.findViewById(D.id.ratingBar);
        Styles.setAccentColor(this.getContext(), this.dialogRatingBar.getProgressDrawable());
        this.dialogRatingBar.setOnTouchListener((View.OnTouchListener)this);
        this.likeStatus = (TextView)this.findViewById(D.id.like_status);
        this.addtionalFeedback = (EditText)this.findViewById(D.id.additional_feedback);
        Button submit = (Button)this.findViewById(D.id.submit);
        submit.setOnClickListener((View.OnClickListener)this);
    }

    public void onShow(DialogInterface dialogInterface) {
        HSFunnel.pushEvent("sr");
        this.dialogRatingBar.setRating(this.rating);
        String ratingValue = this.context.getResources().getQuantityString(D.plurals.hs__csat_rating_value, (int)this.rating, new Object[]{(int)this.rating});
        if ((double)this.rating > 2.0) {
            this.likeStatus.setText(D.string.hs__csat_like_message);
        } else {
            this.likeStatus.setText(D.string.hs__csat_dislike_message);
        }
        this.dialogRatingBar.setContentDescription((CharSequence)ratingValue);
    }

    public void onDismiss(DialogInterface dialogInterface) {
        if (this.submitted) {
            this.csatView.dismiss();
        } else {
            HSFunnel.pushEvent("cr");
            this.csatView.getRatingBar().setRating(0.0f);
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == D.id.submit) {
            this.csatView.sendCSATSurvey(this.dialogRatingBar.getRating(), this.addtionalFeedback.getText().toString());
            this.submitted = true;
            this.showSubmitToast();
            this.dismiss();
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        int id2 = view.getId();
        return id2 == D.id.ratingBar;
    }

    protected void show(CSATView csatView) {
        this.csatView = csatView;
        this.rating = csatView.getRatingBar().getRating();
        this.show();
    }

    private void showSubmitToast() {
        SnackbarUtil.showSnackbar((View)this.csatView, this.context.getString(R.string.hs__csat_submit_toast), 0);
    }
}

