/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import com.helpshift.support.D;
import com.helpshift.support.util.Styles;
import com.helpshift.support.widget.CSATDialog;

public class CSATView
extends RelativeLayout
implements RatingBar.OnRatingBarChangeListener {
    private CSATDialog csatDialog;
    private RatingBar ratingBar;
    private CSATListener csatListener = null;

    public CSATView(Context context) {
        super(context);
        this.initView(context);
    }

    public CSATView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public CSATView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    private void initView(Context context) {
        View.inflate((Context)context, (int)D.layout.hs__csat_view, (ViewGroup)this);
        this.csatDialog = new CSATDialog(context);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.ratingBar = (RatingBar)this.findViewById(D.id.ratingBar);
        Styles.setAccentColor(this.getContext(), this.ratingBar.getProgressDrawable());
        this.ratingBar.setOnRatingBarChangeListener((RatingBar.OnRatingBarChangeListener)this);
    }

    public void onRatingChanged(RatingBar ratingBar, float rating, boolean fromUser) {
        if (fromUser) {
            this.csatDialog.show(this);
        }
    }

    protected RatingBar getRatingBar() {
        return this.ratingBar;
    }

    protected void dismiss() {
        this.setVisibility(8);
        this.csatDialog = null;
        if (this.csatListener != null) {
            this.csatListener.csatViewDissmissed();
        }
    }

    protected void sendCSATSurvey(float rating, String feedback) {
        if (this.csatListener != null) {
            this.csatListener.sendCSATSurvey(Math.round(rating), feedback);
        }
    }

    public void setCSATListener(CSATListener csatListener) {
        this.csatListener = csatListener;
    }

    public static interface CSATListener {
        public void csatViewDissmissed();

        public void sendCSATSurvey(int var1, String var2);
    }
}

