/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.supportCampaigns;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.widget.Toast;
import com.helpshift.R;
import com.helpshift.app.MainLifecycleCallback;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.AnalyticsEvent;
import com.helpshift.support.Support;
import java.util.HashMap;

public class NotificationActivity
extends Activity {
    private static final String OPEN_DEEP_LINK = "1";
    private static final String SHOW_FAQS = "2";
    private static final String SHOW_FAQ_SECTION = "3";
    private static final String SHOW_CONVERSATION = "4";
    private static final String SHOW_SINGLE_FAQ = "5";
    private static final String SHOW_ALERT_TO_RATE_APP = "6";
    private static final String LAUNCH_APP = "7";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        String action = intent.getStringExtra("action");
        if (action == null) {
            action = "0";
        }
        String data = intent.getStringExtra("data");
        String campaignId = intent.getStringExtra("campaignId");
        boolean isForeground = intent.getBooleanExtra("foregroundStatus", true);
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        notificationManager.cancel(campaignId, 1);
        int type = intent.getIntExtra("type", AnalyticsEvent.AnalyticsEventType.DEFAULT.intValue());
        ControllerFactory.getInstance().analyticsEventController.recordAnalyticsEvent(type, campaignId);
        if (isForeground) {
            switch (action) {
                case "1": {
                    Intent deepLinkIntent = new Intent("android.intent.action.VIEW");
                    deepLinkIntent.setData(Uri.parse((String)data));
                    if (deepLinkIntent.resolveActivity(this.getPackageManager()) != null) {
                        this.startActivity(deepLinkIntent);
                        break;
                    }
                    Toast.makeText((Context)this, (CharSequence)this.getString(R.string.hs__could_not_open_attachment_msg), (int)0).show();
                    break;
                }
                case "2": {
                    Support.showFAQs(this);
                    break;
                }
                case "3": {
                    Support.showFAQSection(this, data);
                    break;
                }
                case "4": {
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("conversationPrefillText", data);
                    Support.showConversation(this, config);
                    break;
                }
                case "5": {
                    Support.showSingleFAQ(this, data);
                    break;
                }
                case "6": {
                    Support.showAlertToRateApp(data, null);
                    break;
                }
                default: {
                    if (!MainLifecycleCallback.isForeground()) {
                        PackageManager pm = this.getPackageManager();
                        Intent launchIntentForPackage = pm.getLaunchIntentForPackage(this.getApplicationContext().getPackageName());
                        this.startActivity(launchIntentForPackage);
                        break;
                    }
                    this.finish();
                    break;
                }
            }
        } else {
            this.finish();
        }
    }
}

