/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;

public class ApplicationUtil {
    private static final String TAG = "HelpshiftDebug";

    public static String getApplicationVersion(Context c) {
        String appVersion = null;
        try {
            String packageName = c.getPackageName();
            PackageInfo p = c.getPackageManager().getPackageInfo(packageName, 0);
            appVersion = p.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)TAG, (String)"Package not found exception", (Throwable)e);
        }
        return appVersion;
    }

    public static String getApplicationName(Context context) {
        String appName = null;
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo ai = context.getApplicationInfo();
            appName = pm.getApplicationLabel(ai).toString();
        }
        catch (NullPointerException e) {
            Log.d((String)TAG, (String)"getApplicationName", (Throwable)e);
        }
        if (appName == null) {
            return "Support";
        }
        return appName;
    }

    public static boolean hasVibratePermission(Context context) {
        String packageName;
        PackageManager packageManager = context.getPackageManager();
        int permissionStatus = packageManager.checkPermission("android.permission.VIBRATE", packageName = context.getPackageName());
        return permissionStatus == 0;
    }

    public static int getDeviceApiVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isPermissionGranted(Context context, String permissionName) {
        String packageName;
        PackageManager packageManager = context.getPackageManager();
        return packageManager.checkPermission(permissionName, packageName = context.getPackageName()) == 0;
    }
}

