/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HSJSONUtils {
    private static final String TAG = "HelpshiftDebug";

    public static String[] getJSONObjectKeys(JSONObject inputObject) {
        Iterator keys = inputObject.keys();
        ArrayList<String> objectKeys = new ArrayList<String>();
        while (keys != null && keys.hasNext()) {
            objectKeys.add((String)keys.next());
        }
        String[] returnArray = new String[objectKeys.size()];
        return objectKeys.toArray(returnArray);
    }

    public static HashMap<String, String> toStringHashMap(JSONObject object) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                if (!(object.get(key) instanceof String)) continue;
                map.put(key, object.getString(key));
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"JsonException ", (Throwable)e);
            }
        }
        return map;
    }

    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            map.put(key, HSJSONUtils.fromJson(object.get(key)));
        }
        return map;
    }

    public static List toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(HSJSONUtils.fromJson(array.get(i)));
        }
        return list;
    }

    private static Object fromJson(Object json) throws JSONException {
        if (json == JSONObject.NULL) {
            return null;
        }
        if (json instanceof JSONObject) {
            return HSJSONUtils.toMap((JSONObject)json);
        }
        if (json instanceof JSONArray) {
            return HSJSONUtils.toList((JSONArray)json);
        }
        return json;
    }

    public static JSONObject fromNestedMap(Map<String, ArrayList> complexMap) {
        JSONObject returnObject = new JSONObject();
        try {
            for (Map.Entry<String, ArrayList> entry : complexMap.entrySet()) {
                returnObject.put(entry.getKey(), (Object)new JSONArray((Collection)entry.getValue()));
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSON Exception in parsing complex object", (Throwable)e);
        }
        return returnObject;
    }

    public static JSONArray fromListOfMaps(List<HashMap> mapList) {
        JSONArray returnArray = new JSONArray();
        try {
            for (HashMap hashMap : mapList) {
                JSONObject object = new JSONObject();
                for (Object key : hashMap.keySet()) {
                    if (!(key instanceof String)) continue;
                    object.put((String)key, hashMap.get(key));
                }
                returnArray.put((Object)object);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSON Exception in parsing complex list", (Throwable)e);
        }
        return returnArray;
    }

    public static ArrayList<String> jsonToStringArrayList(String input) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            JSONArray jsonArray = new JSONArray(input);
            int length = jsonArray.length();
            for (int i = 0; i < length; ++i) {
                list.add(jsonArray.getString(i));
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"jsonToStringArrayList", (Throwable)e);
        }
        return list;
    }
}

