/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.annotation.SuppressLint;
import android.location.Location;
import android.location.LocationManager;
import com.helpshift.util.HelpshiftContext;

public class LocationUtil {
    private static final long LOCATION_MIN_TIME = 2000L;
    private static final float LOCATION_MIN_DISTANCE = 10.0f;
    private static final int TWO_MINUTES = 120000;
    private static Location currentLocation = null;

    public static boolean isBetterLocation(Location location, Location currentBestLocation) {
        boolean isNewer;
        if (currentBestLocation == null) {
            return true;
        }
        long timeDelta = location.getTime() - currentBestLocation.getTime();
        boolean isSignificantlyNewer = timeDelta > 120000L;
        boolean isSignificantlyOlder = timeDelta < -120000L;
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyNewer) {
            return true;
        }
        if (isSignificantlyOlder) {
            return false;
        }
        int accuracyDelta = (int)(location.getAccuracy() - currentBestLocation.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0;
        boolean isMoreAccurate = accuracyDelta < 0;
        boolean isSignificantlyLessAccurate = accuracyDelta > 200;
        boolean isFromSameProvider = LocationUtil.isSameProvider(location.getProvider(), currentBestLocation.getProvider());
        if (isMoreAccurate) {
            return true;
        }
        if (isNewer && !isLessAccurate) {
            return true;
        }
        return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
    }

    public static Location sanitizeLocation(Location location) {
        Location limitedLocation = LocationUtil.limitLatitude(location.getLatitude(), location.getLongitude());
        location.setLatitude(limitedLocation.getLatitude());
        location.setLongitude(limitedLocation.getLongitude());
        return location;
    }

    private static double limitLongitude(double longitudeDegrees) {
        double longitudeReduced = longitudeDegrees % 360.0;
        if (longitudeReduced > 180.0) {
            longitudeReduced -= 360.0;
        } else if (longitudeReduced <= -180.0) {
            longitudeReduced += 360.0;
        }
        return longitudeReduced;
    }

    private static Location limitLatitude(double latitudeDegrees, double longitudeDegrees) {
        latitudeDegrees = LocationUtil.limitLongitude(latitudeDegrees);
        boolean flip = false;
        if (latitudeDegrees > 90.0) {
            latitudeDegrees = 180.0 - latitudeDegrees;
            flip = true;
        } else if (latitudeDegrees < -90.0) {
            latitudeDegrees = -180.0 - latitudeDegrees;
            flip = true;
        }
        if (flip) {
            longitudeDegrees += longitudeDegrees > 0.0 ? -180.0 : 180.0;
        }
        longitudeDegrees = LocationUtil.limitLongitude(longitudeDegrees);
        Location location = new Location("");
        location.setLatitude(latitudeDegrees);
        location.setLongitude(longitudeDegrees);
        return location;
    }

    public static boolean isSameLocation(Location location1, Location location2) {
        if (location1 != null && location2 != null) {
            return location1.distanceTo(location2) <= 10.0f;
        }
        return location1 == null && location2 == null;
    }

    private static boolean isSameProvider(String provider1, String provider2) {
        if (provider1 == null) {
            return provider2 == null;
        }
        return provider1.equals(provider2);
    }

    @SuppressLint(value={"all"})
    public static Location getUpdatedCurrentLocation() {
        Location betterLocation;
        LocationManager locationManager = (LocationManager)HelpshiftContext.getApplicationContext().getSystemService("location");
        Location nwLocation = null;
        Location gpsLocation = null;
        if (locationManager.getAllProviders().contains("network")) {
            nwLocation = locationManager.getLastKnownLocation("network");
        }
        if (locationManager.getAllProviders().contains("gps")) {
            gpsLocation = locationManager.getLastKnownLocation("gps");
        }
        Location location = betterLocation = gpsLocation != null ? gpsLocation : nwLocation;
        if (gpsLocation != null && nwLocation != null && LocationUtil.isBetterLocation(nwLocation, gpsLocation)) {
            betterLocation = nwLocation;
        }
        if (LocationUtil.isBetterLocation(betterLocation, currentLocation)) {
            currentLocation = betterLocation;
        }
        return currentLocation;
    }
}

