/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import android.text.TextUtils;
import com.helpshift.util.HSPattern;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SchemaUtil {
    private static boolean validateInputForComponent(String input, String component) {
        Pattern pattern = HSPattern.getComponentPlaceHolderPattern(component);
        Matcher m = pattern.matcher(input.trim());
        return !TextUtils.isEmpty((CharSequence)input) && m.matches();
    }

    public static boolean validatePlatformId(String platformId) {
        return !TextUtils.isEmpty((CharSequence)platformId) && SchemaUtil.validateInputForComponent(platformId, "platform");
    }

    public static boolean validateTimestamp(String timeStamp) {
        Pattern timeStampPattern = HSPattern.getTimeStampPattern();
        Matcher m = timeStampPattern.matcher(timeStamp.trim());
        return m.matches();
    }

    public static boolean validateDomainName(String domainName) {
        Pattern domainNamePattern = HSPattern.getDomainNamePattern();
        Matcher m = domainNamePattern.matcher(domainName.trim());
        return m.matches();
    }

    public static boolean validatePropertyKey(String propertyKey) {
        Pattern propertyKeyPattern = HSPattern.getPropertyKeyPattern();
        Matcher m = propertyKeyPattern.matcher(propertyKey.trim());
        return m.matches();
    }
}

