/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.util;

import com.helpshift.exceptions.InstallException;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.util.ByteArrayUtil;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SecurityUtil {
    public static String getSignature(String sigString) throws GeneralSecurityException, InstallException {
        String data = sigString;
        String key = InfoModelFactory.getInstance().appInfoModel.getApiKey();
        if (!InfoModelFactory.getInstance().appInfoModel.isInstalled()) {
            throw new InstallException("Install information missing");
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKey);
            byte[] hmacData = mac.doFinal(data.getBytes("UTF-8"));
            return ByteArrayUtil.toHex(hmacData);
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneralSecurityException(e);
        }
    }
}

